/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class DivideOperatorExpressionNode
extends BinaryOperationExpressionNode {
    private final ImplicitConversion implicitConversion;

    public DivideOperatorExpressionNode(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        super(left, right);
        this.implicitConversion = implicitConversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.left().getValue(context).thenCombine(this.right().getValue(context), (left, right) -> {
            if (right == null) {
                throw new OpelException("Can't divide " + left.getClass().getSimpleName() + " by null");
            }
            if (left == null) {
                return BigDecimal.ZERO;
            }
            if (this.implicitConversion.hasConverter(left, BigDecimal.class) && this.implicitConversion.hasConverter(right, BigDecimal.class)) {
                BigDecimal leftNumber = this.implicitConversion.convert(left, BigDecimal.class);
                BigDecimal rightNumber = this.implicitConversion.convert(right, BigDecimal.class);
                return leftNumber.divide(rightNumber, 10, RoundingMode.HALF_DOWN);
            }
            throw new OpelException("Can't divide " + left.getClass().getSimpleName() + " by " + right.getClass().getSimpleName());
        });
    }
}

