/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class MinusOperatorExpressionNode
extends BinaryOperationExpressionNode {
    private final ImplicitConversion implicitConversion;

    public MinusOperatorExpressionNode(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        super(left, right);
        this.implicitConversion = implicitConversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.left().getValue(context).thenCombine(this.right().getValue(context), (left, right) -> {
            if (left == null && right == null) {
                return BigDecimal.ZERO;
            }
            if (left == null && this.implicitConversion.hasConverter(right, BigDecimal.class)) {
                return this.implicitConversion.convert(right, BigDecimal.class).negate();
            }
            if (right == null && this.implicitConversion.hasConverter(left, BigDecimal.class)) {
                return this.implicitConversion.convert(left, BigDecimal.class);
            }
            if (this.implicitConversion.hasConverter(left, BigDecimal.class) && this.implicitConversion.hasConverter(right, BigDecimal.class)) {
                BigDecimal leftNumber = this.implicitConversion.convert(left, BigDecimal.class);
                BigDecimal rightNumber = this.implicitConversion.convert(right, BigDecimal.class);
                return leftNumber.subtract(rightNumber);
            }
            throw new OpelException("Can't subtract " + Optional.ofNullable(left).map(it -> it.getClass().getSimpleName()).orElse("null") + " with " + Optional.ofNullable(right).map(it -> it.getClass().getSimpleName()).orElse("null"));
        });
    }
}

