/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import pl.allegro.tech.opel.ArgumentsListExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.OpelAsyncFunction;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

public class AnonymousFunctionExpressionNode
implements OpelNode {
    private final OpelNode expression;
    private final ArgumentsListExpressionNode arguments;

    public AnonymousFunctionExpressionNode(OpelNode expression, ArgumentsListExpressionNode arguments) {
        this.expression = expression;
        this.arguments = arguments;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.expression.getValue(context).thenCompose(function -> {
            if (function instanceof OpelAsyncFunction) {
                return ((OpelAsyncFunction)function).apply(this.arguments.getArgs().stream().map(it -> it.getValue(context)).collect(Collectors.toList()));
            }
            throw new OpelException("Can't use expression of type " + this.expression.getClass().getSimpleName() + " as a function");
        });
    }
}

