/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.concurrent.CompletableFuture;
import pl.allegro.tech.opel.BinaryOperationExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

class CompareOperatorExpressionNode
extends BinaryOperationExpressionNode {
    private final boolean greater;
    private final boolean equal;
    private final ImplicitConversion implicitConversion;

    private CompareOperatorExpressionNode(boolean greater, boolean equal, OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        super(left, right);
        this.greater = greater;
        this.equal = equal;
        this.implicitConversion = implicitConversion;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.left().getValue(context).thenCombine(this.right().getValue(context), (left, right) -> {
            if (left == null && right == null) {
                return this.equal;
            }
            if (left == null) {
                return !this.greater;
            }
            if (right == null) {
                return this.greater;
            }
            if (left instanceof Comparable && this.implicitConversion.hasConverter(right, left.getClass())) {
                int comparison = ((Comparable)left).compareTo(this.implicitConversion.convert(right, left.getClass()));
                return comparison < 0 && !this.greater || comparison == 0 && this.equal || comparison > 0 && this.greater;
            }
            if (right instanceof Comparable && this.implicitConversion.hasConverter(left, right.getClass())) {
                int comparison = ((Comparable)this.implicitConversion.convert(left, right.getClass())).compareTo(right);
                return comparison < 0 && !this.greater || comparison == 0 && this.equal || comparison > 0 && this.greater;
            }
            throw new OpelException("Can't compare " + left.getClass().getSimpleName() + " with " + right.getClass().getSimpleName());
        });
    }

    public static OpelNode greaterThen(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new CompareOperatorExpressionNode(true, false, left, right, implicitConversion);
    }

    public static OpelNode greaterOrEqual(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new CompareOperatorExpressionNode(true, true, left, right, implicitConversion);
    }

    public static OpelNode lowerThen(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new CompareOperatorExpressionNode(false, false, left, right, implicitConversion);
    }

    public static OpelNode lowerOrEqual(OpelNode left, OpelNode right, ImplicitConversion implicitConversion) {
        return new CompareOperatorExpressionNode(false, true, left, right, implicitConversion);
    }
}

