/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.EvalContextBuilder;
import pl.allegro.tech.opel.FutureUtil;
import pl.allegro.tech.opel.IdentifiersListNode;
import pl.allegro.tech.opel.OpelAsyncFunction;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

public class FunctionInstantiationExpressionNode
implements OpelNode {
    private final IdentifiersListNode arguments;
    private final OpelNode body;

    public FunctionInstantiationExpressionNode(IdentifiersListNode arguments, OpelNode body) {
        this.arguments = arguments;
        this.body = body;
    }

    @Override
    public CompletableFuture<?> getValue(final EvalContext context) {
        return CompletableFuture.completedFuture(new OpelAsyncFunction<Object>(){

            @Override
            public CompletableFuture<Object> apply(List<CompletableFuture<?>> args) {
                List collect = FunctionInstantiationExpressionNode.this.arguments.getIdentifiers().stream().map(it -> it.getValue(context)).map(it -> FunctionInstantiationExpressionNode.this.javaGenericWorkaround(it)).collect(Collectors.toList());
                CompletableFuture argsNames = FutureUtil.sequence(collect);
                return argsNames.thenCompose(names -> {
                    EvalContextBuilder contextBuilder = EvalContextBuilder.create().withExternalEvalContext(context);
                    for (int i = 0; i < names.size(); ++i) {
                        String name = (String)names.get(i);
                        if (args.size() == i) {
                            throw new OpelException("Missing argument '" + name + "' in function call");
                        }
                        CompletionStage value = ((CompletableFuture)args.get(i)).thenApply(Function.identity());
                        contextBuilder.withValue(name, (CompletableFuture<Object>)value);
                    }
                    EvalContext localContext = contextBuilder.build();
                    return FunctionInstantiationExpressionNode.this.body.getValue(localContext).thenApply(Function.identity());
                });
            }
        });
    }

    private CompletableFuture<Object> javaGenericWorkaround(CompletableFuture<?> future) {
        return future.thenApply(Function.identity());
    }
}

