/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import pl.allegro.tech.opel.DeclarationStatementNode;
import pl.allegro.tech.opel.DeclarationsListStatementNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.EvalContextBuilder;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

public class ProgramNode
implements OpelNode {
    private DeclarationsListStatementNode declarations;
    private OpelNode expression;

    public ProgramNode(DeclarationsListStatementNode declarationsList, OpelNode expression) {
        this.declarations = declarationsList;
        this.expression = expression;
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return this.expression.getValue(this.updatedContext(this.declarations.getDeclarations(), context));
    }

    private EvalContext updatedContext(List<DeclarationStatementNode> declarations, EvalContext externalContext) {
        EvalContextBuilder contextBuilder = EvalContextBuilder.create();
        for (DeclarationStatementNode declaration : declarations) {
            String name = declaration.getIdentifier().getIdentifier();
            if (contextBuilder.hasValue(name)) {
                throw new OpelException("Illegal override of value " + declaration.getIdentifier().getIdentifier());
            }
            EvalContext valExpressionContext = EvalContextBuilder.mergeContexts(contextBuilder.build(), externalContext);
            CompletionStage value = declaration.getExpression().getValue(valExpressionContext).thenApply(Function.identity());
            contextBuilder.withValue(name, (CompletableFuture<Object>)value);
        }
        return contextBuilder.withExternalEvalContext(externalContext).build();
    }
}

