/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.opel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import pl.allegro.tech.opel.ArgumentsListExpressionNode;
import pl.allegro.tech.opel.EvalContext;
import pl.allegro.tech.opel.FutureUtil;
import pl.allegro.tech.opel.IdentifierExpressionNode;
import pl.allegro.tech.opel.ImplicitConversion;
import pl.allegro.tech.opel.MethodExecutionFilter;
import pl.allegro.tech.opel.OpelException;
import pl.allegro.tech.opel.OpelNode;

public class MethodCallExpressionNode
implements OpelNode {
    private final OpelNode subject;
    private final String identifier;
    private final Optional<ArgumentsListExpressionNode> arguments;
    private final ImplicitConversion implicitConversion;
    private final MethodExecutionFilter methodExecutionFilter;

    public MethodCallExpressionNode(OpelNode subject, String identifier, Optional<ArgumentsListExpressionNode> arguments, ImplicitConversion implicitConversion, MethodExecutionFilter methodExecutionFilter) {
        this.subject = subject;
        this.identifier = identifier;
        this.arguments = arguments;
        this.implicitConversion = implicitConversion;
        this.methodExecutionFilter = methodExecutionFilter;
    }

    static MethodCallExpressionNode create(OpelNode subject, OpelNode identifier, OpelNode arguments, ImplicitConversion implicitConversion, MethodExecutionFilter methodExecutionFilter) {
        if (!(identifier instanceof IdentifierExpressionNode)) {
            throw new IllegalArgumentException("Cannot create from OpelNode because identifier is of wrong node type " + identifier.getClass().getSimpleName());
        }
        if (!(arguments instanceof ArgumentsListExpressionNode)) {
            throw new IllegalArgumentException("Cannot create from OpelNode because arguments is of wrong node type " + arguments.getClass().getSimpleName());
        }
        return new MethodCallExpressionNode(subject, ((IdentifierExpressionNode)identifier).getIdentifier(), Optional.of((ArgumentsListExpressionNode)arguments), implicitConversion, methodExecutionFilter);
    }

    static MethodCallExpressionNode create(OpelNode subject, OpelNode identifier, ImplicitConversion implicitConversion, MethodExecutionFilter methodExecutionFilter) {
        if (!(identifier instanceof IdentifierExpressionNode)) {
            throw new IllegalArgumentException("Cannot create from OpelNode because identifier is of wrong node type " + identifier.getClass().getSimpleName());
        }
        return new MethodCallExpressionNode(subject, ((IdentifierExpressionNode)identifier).getIdentifier(), Optional.empty(), implicitConversion, methodExecutionFilter);
    }

    @Override
    public CompletableFuture<?> getValue(EvalContext context) {
        return FutureUtil.sequence(this.arguments.map(ags -> ags.getListOfValues(context)).orElse(Collections.emptyList()).stream().map(this::javaGenericsFix).collect(Collectors.toList())).thenCombine(this.subject.getValue(context), (args, sbj) -> this.methodCall(sbj, this.identifier, (List<?>)args));
    }

    private Object methodCall(Object subject, String methodName, List<?> args) {
        try {
            Class[] argsTypes = (Class[])args.stream().map(it -> it == null ? null : it.getClass()).toArray(Class[]::new);
            ImmutablePair chosenMethod = this.implicitConversion.getAllPossibleConversions(subject).map(convertedSubject -> ImmutablePair.of((Object)convertedSubject, this.findMatchingMethod(convertedSubject, methodName, args))).filter(it -> ((Optional)it.getRight()).isPresent()).findFirst().map(it -> ImmutablePair.of((Object)it.left, (Object)((Method)((Optional)it.right).get()))).orElseThrow(() -> new RuntimeException("Can't find method '" + methodName + "' for class '" + subject.getClass().getSimpleName() + "' with arguments: " + Arrays.stream(argsTypes).map(Class::getSimpleName).collect(Collectors.joining(", "))));
            return ((Method)chosenMethod.right).invoke(chosenMethod.left, this.convertArgs(args, (Method)chosenMethod.right));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new OpelException(e);
        }
    }

    private Optional<Method> findMatchingMethod(Object subject, String methodName, List<?> args) {
        if (subject == null) {
            throw new RuntimeException("Can't call '" + methodName + "' on null");
        }
        return Arrays.stream(subject.getClass().getMethods()).filter(method -> this.methodExecutionFilter.filter(subject, (Method)method)).filter(method -> method.getName().equals(methodName)).filter(method -> this.areArgsMatchForMethod((Method)method, args)).findFirst();
    }

    private Object[] convertArgs(List<?> args, Method chosenMethod) {
        Parameter[] parameters = chosenMethod.getParameters();
        ArrayList convertedArgs = new ArrayList();
        for (int i = 0; i < args.size(); ++i) {
            Object arg = args.get(i);
            Class<?> expectedType = parameters[i].getType();
            convertedArgs.add(this.implicitConversion.convert(arg, expectedType));
        }
        return convertedArgs.toArray(new Object[convertedArgs.size()]);
    }

    private boolean areArgsMatchForMethod(Method method, List<?> args) {
        Class<?>[] expectedArgumentsTypes = method.getParameterTypes();
        if (expectedArgumentsTypes.length != args.size()) {
            return false;
        }
        for (int i = 0; i < expectedArgumentsTypes.length; ++i) {
            Class<?> givenType;
            Class<?> expectedType = expectedArgumentsTypes[i];
            Object arg = args.get(i);
            if (arg == null || ClassUtils.isAssignable(givenType = arg.getClass(), expectedType) || this.implicitConversion.hasConverter(arg, expectedType)) continue;
            return false;
        }
        return true;
    }

    private CompletableFuture<Object> javaGenericsFix(CompletableFuture<?> it) {
        return it.thenApply(Function.identity());
    }
}

