/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import com.codahale.metrics.Timer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import pl.allegro.tech.servicemesh.envoycontrol.EnvoyControlSynchronizationTest;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulMultiClusterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlClusteredExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0007J\b\u0010\u000e\u001a\u00020\nH\u0007Ji\u0010\u000f\u001a\u00020\u00102'\u0010\u0011\u001a#\u0012\u0004\u0012\u00020\f\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\n0\u001226\u0010\u0017\u001a2\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001b\u001a\u00020\nH\u0007J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyControlSynchronizationTest;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "deregisterService", "", "serviceId", "", "latency between service registration in local dc and being able to access it via envoy should be less than 0,5s + stateSampleDuration", "latency between service registration in remote dc and being able to access it via envoy should be similar to envoy-control polling interval", "measureRegistrationToAccessLatency", "Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyControlSynchronizationTest$LatencySummary;", "registerService", "Lkotlin/Function2;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "Lkotlin/ParameterName;", "name", "echoServiceExtension", "readinessCheck", "registerServiceInLocalDc", "target", "registerServiceInRemoteDc", "should prefer services from local dc and fallback to remote dc when needed", "waitServiceOkAndFrom", "Companion", "LatencySummary", "envoy-control-tests"})
public final class EnvoyControlSynchronizationTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy logger$delegate = LoggerKt.logger((Object)this);
    private static final Duration pollingInterval = Duration.ofSeconds(1L);
    private static final Duration stateSampleDuration = Duration.ofSeconds(1L);
    @NotNull
    private static final Duration defaultDuration;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulMultiClusterExtension consulClusters;
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControlDc1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControlDc2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension serviceLocal;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension serviceRemote;

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    @Test
    public final void should prefer services from local dc and fallback to remote dc when needed() {
        this.registerServiceInRemoteDc("echo", serviceRemote);
        String serviceId = this.registerServiceInLocalDc("echo", serviceLocal);
        this.waitServiceOkAndFrom("echo", serviceLocal);
        this.deregisterService(serviceId);
        this.waitServiceOkAndFrom("echo", serviceRemote);
        this.registerServiceInLocalDc("echo", serviceLocal);
        this.waitServiceOkAndFrom("echo", serviceLocal);
    }

    @Test
    public final void latency between service registration in remote dc and being able to access it via envoy should be similar to envoy-control polling interval() {
        LatencySummary latency2 = this.measureRegistrationToAccessLatency((Function2<? super String, ? super EchoServiceExtension, Unit>)((Function2)new Function2<String, EchoServiceExtension, Unit>(this){
            final /* synthetic */ EnvoyControlSynchronizationTest this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull EchoServiceExtension target) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                this.this$0.registerServiceInRemoteDc(name, target);
            }
        }), (Function2<? super String, ? super EchoServiceExtension, Unit>)((Function2)new Function2<String, EchoServiceExtension, Unit>(this){
            final /* synthetic */ EnvoyControlSynchronizationTest this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull EchoServiceExtension target) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                EnvoyControlSynchronizationTest.access$waitServiceOkAndFrom(this.this$0, name, target);
            }
        }));
        this.getLogger().info("remote dc latency: " + latency2);
        Duration tolerance = Duration.ofMillis(400L).plus(stateSampleDuration);
        long expectedMax = pollingInterval.plus(tolerance).toMillis();
        Assertions.assertThat((long)latency2.max()).isLessThanOrEqualTo(expectedMax);
    }

    @Test
    public final void latency between service registration in local dc and being able to access it via envoy should be less than 0,5s + stateSampleDuration() {
        LatencySummary latency2 = this.measureRegistrationToAccessLatency((Function2<? super String, ? super EchoServiceExtension, Unit>)((Function2)new Function2<String, EchoServiceExtension, Unit>(this){
            final /* synthetic */ EnvoyControlSynchronizationTest this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull EchoServiceExtension target) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                this.this$0.registerServiceInLocalDc(name, target);
            }
        }), (Function2<? super String, ? super EchoServiceExtension, Unit>)((Function2)new Function2<String, EchoServiceExtension, Unit>(this){
            final /* synthetic */ EnvoyControlSynchronizationTest this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull EchoServiceExtension target) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                EnvoyControlSynchronizationTest.access$waitServiceOkAndFrom(this.this$0, name, target);
            }
        }));
        this.getLogger().info("local dc latency: " + latency2);
        Assertions.assertThat((long)latency2.max()).isLessThanOrEqualTo((long)500 + stateSampleDuration.toMillis());
    }

    private final LatencySummary measureRegistrationToAccessLatency(Function2<? super String, ? super EchoServiceExtension, Unit> registerService2, Function2<? super String, ? super EchoServiceExtension, Unit> readinessCheck) {
        Timer timer = new Timer();
        int n = 1;
        while (n < 6) {
            int i = n++;
            String serviceName = "service-" + i;
            registerService2.invoke((Object)serviceName, (Object)serviceLocal);
            timer.time(() -> EnvoyControlSynchronizationTest.measureRegistrationToAccessLatency$lambda-1(readinessCheck, serviceName));
        }
        return new LatencySummary(timer);
    }

    private final void deregisterService(String serviceId) {
        consulClusters.getServerFirst().getOperations().deregisterService(serviceId);
    }

    private final void waitServiceOkAndFrom(String name, EchoServiceExtension echoServiceExtension) {
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Response>(name, echoServiceExtension){
            final /* synthetic */ String $name;
            final /* synthetic */ EchoServiceExtension $echoServiceExtension;
            {
                this.$name = $name;
                this.$echoServiceExtension = $echoServiceExtension;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2 = EgressOperations.callService$default(EnvoyControlSynchronizationTest.envoy.getEgressOperations(), this.$name, null, null, null, null, 30, null);
                EchoServiceExtension echoServiceExtension = this.$echoServiceExtension;
                Response it = response2;
                boolean bl = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(it)");
                ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoServiceExtension);
                return response2;
            }
        }, 3, null);
    }

    @NotNull
    public final String registerServiceInLocalDc(@NotNull String name, @NotNull EchoServiceExtension target) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return ConsulOperations.registerService$default(consulClusters.getServerFirst().getOperations(), target, null, name, false, null, null, 58, null);
    }

    @NotNull
    public final String registerServiceInRemoteDc(@NotNull String name, @NotNull EchoServiceExtension target) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return ConsulOperations.registerService$default(consulClusters.getServerSecond().getOperations(), target, null, name, false, null, null, 58, null);
    }

    private static final void measureRegistrationToAccessLatency$lambda-1$lambda-0(Function2 $readinessCheck, String $serviceName) {
        Intrinsics.checkNotNullParameter((Object)$readinessCheck, (String)"$readinessCheck");
        Intrinsics.checkNotNullParameter((Object)$serviceName, (String)"$serviceName");
        $readinessCheck.invoke((Object)$serviceName, (Object)serviceLocal);
    }

    private static final void measureRegistrationToAccessLatency$lambda-1(Function2 $readinessCheck, String $serviceName) {
        Intrinsics.checkNotNullParameter((Object)$readinessCheck, (String)"$readinessCheck");
        Intrinsics.checkNotNullParameter((Object)$serviceName, (String)"$serviceName");
        Awaitility.await().pollDelay(50L, TimeUnit.MILLISECONDS).atMost(defaultDuration).untilAsserted(() -> EnvoyControlSynchronizationTest.measureRegistrationToAccessLatency$lambda-1$lambda-0($readinessCheck, $serviceName));
    }

    public static final /* synthetic */ void access$waitServiceOkAndFrom(EnvoyControlSynchronizationTest $this, String name, EchoServiceExtension echoServiceExtension) {
        $this.waitServiceOkAndFrom(name, echoServiceExtension);
    }

    static {
        Pair[] pairArray = Duration.ofSeconds(90L);
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"ofSeconds(90)");
        defaultDuration = pairArray;
        consulClusters = new ConsulMultiClusterExtension();
        pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.stateSampleDuration", (Object)stateSampleDuration), TuplesKt.to((Object)"envoy-control.sync.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.sync.polling-interval", (Object)pollingInterval.getSeconds())};
        properties = MapsKt.mapOf((Pair[])pairArray);
        envoyControlDc1 = new EnvoyControlClusteredExtension(consulClusters.getServerFirst(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControlDc1.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consulClusters));
        envoyControlDc2 = new EnvoyControlClusteredExtension(consulClusters.getServerSecond(), null, CollectionsKt.listOf((Object)consulClusters), 2, null);
        envoy = new EnvoyExtension(envoyControlDc1, null, null, 6, null);
        serviceLocal = new EchoServiceExtension();
        serviceRemote = new EchoServiceExtension();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR%\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00010\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\n \u000f*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\b\u00a8\u0006\u001b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyControlSynchronizationTest$Companion;", "", "()V", "consulClusters", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulMultiClusterExtension;", "defaultDuration", "Ljava/time/Duration;", "getDefaultDuration", "()Ljava/time/Duration;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControlDc1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlClusteredExtension;", "envoyControlDc2", "pollingInterval", "kotlin.jvm.PlatformType", "getPollingInterval", "properties", "", "", "getProperties", "()Ljava/util/Map;", "serviceLocal", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "serviceRemote", "stateSampleDuration", "getStateSampleDuration", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getPollingInterval() {
            return pollingInterval;
        }

        public final Duration getStateSampleDuration() {
            return stateSampleDuration;
        }

        @NotNull
        public final Duration getDefaultDuration() {
            return defaultDuration;
        }

        @NotNull
        public final Map<String, Object> getProperties() {
            return properties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyControlSynchronizationTest$LatencySummary;", "", "timer", "Lcom/codahale/metrics/Timer;", "(Lcom/codahale/metrics/Timer;)V", "max", "", "nanosToMillis", "nanos", "toString", "", "envoy-control-tests"})
    private static final class LatencySummary {
        @NotNull
        private final Timer timer;

        public LatencySummary(@NotNull Timer timer) {
            Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
            this.timer = timer;
        }

        private final long nanosToMillis(long nanos) {
            return Duration.ofNanos(nanos).toMillis();
        }

        public final long max() {
            return this.nanosToMillis(this.timer.getSnapshot().getMax());
        }

        @NotNull
        public String toString() {
            return "LatencySummary(max = " + this.nanosToMillis(this.timer.getSnapshot().getMax()) + " ms, median = " + this.nanosToMillis((long)this.timer.getSnapshot().getMedian()) + " ms)";
        }
    }
}

