/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.Container;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.GenericServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH&J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H&J\b\u0010\u0013\u001a\u00020\u000fH&J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017\u00a8\u0006\u0016"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyOriginalDstListenerTests;", "", "cleanIpTables", "", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "getHostname", "", "body", "getSNI", "httpDomain", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "httpsService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/GenericServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoContainer;", "service", "should use transparent proxy to communicate with https domains", "should use transparent proxy to communicate with services and domain", "envoy-control-tests"})
public interface EnvoyOriginalDstListenerTests {
    @NotNull
    public ConsulExtension consul();

    @NotNull
    public EnvoyControlExtension envoyControl();

    @NotNull
    public EchoServiceExtension service();

    @NotNull
    public EnvoyExtension envoy();

    @NotNull
    public EchoServiceExtension httpDomain();

    @NotNull
    public GenericServiceExtension<HttpsEchoContainer> httpsService();

    @Test
    public void should use transparent proxy to communicate with services and domain();

    @Test
    public void should use transparent proxy to communicate with https domains();

    @AfterEach
    public void cleanIpTables();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void should use transparent proxy to communicate with services and domain(@NotNull EnvoyOriginalDstListenerTests this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.envoy().getContainer().addIptablesRedirect(5000, 80);
            this_.envoy().getContainer().addIptablesRedirect(5000, 5678);
            this_.envoy().getContainer().addHost("echo", "127.0.0.1");
            ConsulOperations.registerService$default(this_.consul().getServer().getOperations(), this_.service(), null, "echo", false, null, null, 58, null);
            AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractIntegerAssert<?>>(this_){
                final /* synthetic */ EnvoyOriginalDstListenerTests this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final AbstractIntegerAssert<?> invoke() {
                    Container.ExecResult resultService = EnvoyContainer.callInContainer$default(this.this$0.envoy().getContainer(), "echo", null, false, 6, null);
                    Assertions.assertThat((Object)resultService).isNotNull();
                    Container.ExecResult execResult = resultService;
                    Intrinsics.checkNotNull((Object)execResult);
                    String string = execResult.getStdout();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultService!!.stdout");
                    Assertions.assertThat((String)((Object)StringsKt.trim((CharSequence)string)).toString()).isEqualTo(this.this$0.service().container().getResponse());
                    string = this.this$0.envoy().getContainer().admin().statValue("cluster.echo.upstream_rq_200");
                    return Assertions.assertThat(string == null ? null : Integer.valueOf(Integer.parseInt(string))).isEqualTo(1);
                }
            }, 3, null);
            AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractIntegerAssert<?>>(this_){
                final /* synthetic */ EnvoyOriginalDstListenerTests this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final AbstractIntegerAssert<?> invoke() {
                    Container.ExecResult resultDomain = EnvoyContainer.callInContainer$default(this.this$0.envoy().getContainer(), "myhttp.example.com:5678", null, false, 6, null);
                    Assertions.assertThat((Object)resultDomain).isNotNull();
                    Container.ExecResult execResult = resultDomain;
                    Intrinsics.checkNotNull((Object)execResult);
                    String string = execResult.getStdout();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultDomain!!.stdout");
                    Assertions.assertThat((String)((Object)StringsKt.trim((CharSequence)string)).toString()).isEqualTo(this.this$0.httpDomain().container().getResponse());
                    string = this.this$0.envoy().getContainer().admin().statValue("cluster.myhttp_example_com_5678.upstream_rq_200");
                    return Assertions.assertThat(string == null ? null : Integer.valueOf(Integer.parseInt(string))).isEqualTo(1);
                }
            }, 3, null);
        }

        @Test
        public static void should use transparent proxy to communicate with https domains(@NotNull EnvoyOriginalDstListenerTests this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.envoy().getContainer().addIptablesRedirect(5000, 443);
            AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this_){
                final /* synthetic */ EnvoyOriginalDstListenerTests this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final AbstractStringAssert<?> invoke() {
                    Container.ExecResult response2 = EnvoyContainer.callInContainer$default(this.this$0.envoy().getContainer(), "my.example.com", null, true, 2, null);
                    Assertions.assertThat((Object)response2).isNotNull();
                    Container.ExecResult execResult = response2;
                    Intrinsics.checkNotNull((Object)execResult);
                    Assertions.assertThat((String)execResult.getStdout()).isNotBlank();
                    String string = response2.getStdout();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response!!.stdout");
                    Assertions.assertThat((String)DefaultImpls.access$getSNI(this.this$0, string)).isEqualTo("my.example.com");
                    string = response2.getStdout();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response!!.stdout");
                    return Assertions.assertThat((String)DefaultImpls.access$getHostname(this.this$0, string)).isEqualTo(this.this$0.httpsService().container().containerName());
                }
            }, 3, null);
        }

        @AfterEach
        public static void cleanIpTables(@NotNull EnvoyOriginalDstListenerTests this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            this_.envoy().getContainer().cleanIptables();
            this_.envoy().getContainer().removeHost("echo");
        }

        private static String getSNI(EnvoyOriginalDstListenerTests this_, String body) {
            String string = HttpsEchoResponse.Companion.getObjectMapper().readTree(body).at("/connection/servername").textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HttpsEchoResponse.object\u2026/servername\").textValue()");
            return string;
        }

        private static String getHostname(EnvoyOriginalDstListenerTests this_, String body) {
            String string = HttpsEchoResponse.Companion.getObjectMapper().readTree(body).at("/os/hostname").textValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HttpsEchoResponse.object\u2026os/hostname\").textValue()");
            return string;
        }

        public static final /* synthetic */ String access$getSNI(EnvoyOriginalDstListenerTests this_, String body) {
            return DefaultImpls.getSNI(this_, body);
        }

        public static final /* synthetic */ String access$getHostname(EnvoyOriginalDstListenerTests this_, String body) {
            return DefaultImpls.getHostname(this_, body);
        }
    }
}

