/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.HostHeaderRewritingTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.GenericServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/HostHeaderRewritingTest;", "", "()V", "should not override Host header when target service has host-header-rewriting disabled", "", "should override Host header with value from specified custom header", "Companion", "envoy-control-tests"})
public final class HostHeaderRewritingTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String customHostHeader = "x-envoy-original-host-test";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<HttpsEchoContainer> httpsService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;

    @Test
    public final void should override Host header with value from specified custom header() {
        ConsulOperations.registerService$default(consul.getServer().getOperations(), httpsService, null, "host-rewrite-service", false, null, null, 58, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, should override Host header with value from specified custom header.1.INSTANCE, 3, null);
    }

    @Test
    public final void should not override Host header when target service has host-header-rewriting disabled() {
        ConsulOperations.registerService$default(consul.getServer().getOperations(), httpsService, null, "service-1", false, null, null, 58, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, should not override Host header when target service has host-header-rewriting disabled.1.INSTANCE, 3, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.egress.host-header-rewriting.custom-host-header", (Object)customHostHeader), TuplesKt.to((Object)"envoy-control.envoy.snapshot.egress.host-header-rewriting.enabled", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])pairArray));
        httpsService = new GenericServiceExtension<ServiceContainer>(new HttpsEchoContainer());
        envoy = new EnvoyExtension(envoyControl, null, null, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/HostHeaderRewritingTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "customHostHeader", "", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "httpsService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/GenericServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoContainer;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

