/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.discovery.consul.recipes.internal.http.MediaType;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HttpResponseCloser;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.OAuthServerExtension;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.OAuthProvider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\r\u0010\n\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u0004H\u0007J\b\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\b\u0010\u0011\u001a\u00020\u0004H\u0007J\b\u0010\u0012\u001a\u00020\u0004H\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0007J\b\u0010\u0016\u001a\u00020\u0004H\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0007J\b\u0010\u0018\u001a\u00020\u0004H\u0007J\b\u0010\u0019\u001a\u00020\u0004H\u0007J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\b\u0010\u001c\u001a\u00020\u0004H\u0007J\u001a\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\u001f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/JWTFilterTest;", "", "()V", "registerClientWithAuthority", "", "provider", "", "clientId", "authority", "registerEnvoyServiceAndWait", "registerOAuthAndWait", "registerOAuthAndWait$envoy_control_tests", "should allow client with listed name and no token to access endpoint when oauth policy is allowMissing", "should allow client with oauth selector when oauth is not specified for given endpoint", "should allow request  with token from unlisted client when policy is strict, unlisted clients policy is log and there are other clients defined", "should allow request to endpoint with client having OAuth selector from other provider if token has necessary claims", "should allow request with token when policy is strict, unlisted clients policy is log and there are no clients", "should allow request with valid jwt", "should allow request with valid token when policy is allow missing", "should allow request with wrong token when policy is allowMissingOrFailed", "should allow requests to endpoint with client having OAuth selector if token has necessary claims", "should allow requests with valid jwt when many providers are defined", "should reject access to endpoint with client having OAuth selector if token does not have necessary claims", "should reject request with expired Token", "should reject request with token from wrong provider", "should reject request with valid token when unlistedClientsPolicy is blockAndLog", "should reject request with wrong token when policy is allow missing", "should reject request with wrong token when policy is strict, unlisted clients policy is log and there are no clients", "should reject request without jwt", "tokenForProvider", "Companion", "envoy-control-tests"})
public final class JWTFilterTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final OAuthServerExtension oAuthServer = new OAuthServerExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service;
    @NotNull
    private static final EnvoyConfig echoConfig;
    @NotNull
    private static final String oauthConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension oauthEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;
    @NotNull
    private static final String echo2Config;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;

    @BeforeEach
    public final void registerOAuthAndWait$envoy_control_tests() {
        String[] stringArray = consul.getServer().getOperations();
        EnvoyExtension envoyExtension = oauthEnvoy;
        ConsulOperations.registerServiceWithEnvoyOnIngress$default((ConsulOperations)stringArray, envoyExtension, null, "oauth", false, null, 26, null);
        stringArray = new String[]{"oauth"};
        envoy.waitForReadyServices(stringArray);
    }

    @Test
    public final void should reject request without jwt() {
        this.registerEnvoyServiceAndWait();
        Response response2 = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/first-provider-protected", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
    }

    @Test
    public final void should allow request with valid jwt() {
        String token = JWTFilterTest.tokenForProvider$default(this, "first-provider", null, 2, null);
        this.registerEnvoyServiceAndWait();
        EgressOperations egressOperations = echo2Envoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + token)));
        Response response2 = EgressOperations.callService$default(egressOperations, "echo", map, "/first-provider-protected", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)egressOperations), service);
    }

    @Test
    public final void should reject request with expired Token() {
        URL uRL = this.getClass().getClassLoader().getResource("oauth/invalid_jwks_token");
        Intrinsics.checkNotNull((Object)uRL);
        URL uRL2 = uRL;
        Object object = Charsets.UTF_8;
        Object object2 = TextStreamsKt.readBytes((URL)uRL2);
        String invalidToken = new String((byte[])object2, (Charset)object);
        this.registerEnvoyServiceAndWait();
        object = echo2Envoy.getEgressOperations();
        object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + invalidToken)));
        Response response2 = EgressOperations.callService$default((EgressOperations)object, "echo", (Map)object2, "/first-provider-protected", null, null, 24, null);
        object = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)object);
    }

    @Test
    public final void should reject request with token from wrong provider() {
        String token = JWTFilterTest.tokenForProvider$default(this, "wrong-provider", null, 2, null);
        this.registerEnvoyServiceAndWait();
        EgressOperations egressOperations = echo2Envoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + token)));
        Response response2 = EgressOperations.callService$default(egressOperations, "echo", map, "/first-provider-protected", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)egressOperations);
    }

    @Test
    public final void should allow requests with valid jwt when many providers are defined() {
        String firstProviderToken = JWTFilterTest.tokenForProvider$default(this, "first-provider", null, 2, null);
        String secondProviderToken = JWTFilterTest.tokenForProvider$default(this, "second-provider", null, 2, null);
        this.registerEnvoyServiceAndWait();
        EgressOperations egressOperations = echo2Envoy.getEgressOperations();
        Object object = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + firstProviderToken)));
        Response firstProviderResponse = EgressOperations.callService$default(egressOperations, "echo", (Map)object, "/first-provider-protected", null, null, 24, null);
        object = echo2Envoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + secondProviderToken)));
        Response secondProviderResponse = EgressOperations.callService$default((EgressOperations)object, "echo", map, "/second-provider-protected", null, null, 24, null);
        object = Assertions.assertThat((Object)firstProviderResponse);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(firstProviderResponse)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)object);
        object = Assertions.assertThat((Object)secondProviderResponse);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(secondProviderResponse)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)object);
    }

    @Test
    public final void should reject access to endpoint with client having OAuth selector if token does not have necessary claims() {
        this.registerClientWithAuthority("first-provider", "unauthorized-client", "wrong-team");
        String token = this.tokenForProvider("first-provider", "unauthorized-client");
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/rbac-clients-test", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)stringArray);
    }

    @Test
    public final void should allow requests to endpoint with client having OAuth selector if token has necessary claims() {
        this.registerClientWithAuthority("first-provider", "client1-rbac", "team1");
        this.registerClientWithAuthority("first-provider", "client2-rbac", "team2");
        String token = this.tokenForProvider("first-provider", "client1-rbac");
        String token2 = this.tokenForProvider("first-provider", "client2-rbac");
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/rbac-clients-test", Headers.Companion.of(stringArray));
        String[] stringArray2 = new String[]{"Authorization", "Bearer " + token2};
        Response response22 = envoy.getIngressOperations().callLocalService("/rbac-clients-test", Headers.Companion.of(stringArray2));
        stringArray2 = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"assertThat(response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)stringArray2), service);
        stringArray2 = Assertions.assertThat((Object)response22);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"assertThat(response2)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)stringArray2), service);
    }

    @Test
    public final void should allow request to endpoint with client having OAuth selector from other provider if token has necessary claims() {
        this.registerClientWithAuthority("second-provider", "client-rbac", "team3");
        String token = this.tokenForProvider("second-provider", "client-rbac");
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/rbac-clients-test", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)stringArray), service);
    }

    @Test
    public final void should allow request with valid token when policy is allow missing() {
        String token = JWTFilterTest.tokenForProvider$default(this, "first-provider", null, 2, null);
        this.registerEnvoyServiceAndWait();
        EgressOperations egressOperations = echo2Envoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + token)));
        Response echoResponse = EgressOperations.callService$default(egressOperations, "echo", map, "/oauth-or-tls", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)egressOperations);
    }

    @Test
    public final void should allow client with listed name and no token to access endpoint when oauth policy is allowMissing() {
        this.registerEnvoyServiceAndWait();
        Response echoResponse = EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo", null, "/oauth-or-tls", null, null, 26, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), service);
    }

    @Test
    public final void should reject request with wrong token when policy is allow missing() {
        String token = JWTFilterTest.tokenForProvider$default(this, "wrong-provider", null, 2, null);
        this.registerEnvoyServiceAndWait();
        EgressOperations egressOperations = echo2Envoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + token)));
        Response echoResponse = EgressOperations.callService$default(egressOperations, "echo", map, "/oauth-or-tls", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)egressOperations);
    }

    @Test
    public final void should reject request with valid token when unlistedClientsPolicy is blockAndLog() {
        String token = JWTFilterTest.tokenForProvider$default(this, "first-provider", null, 2, null);
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/rbac-clients-test", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)stringArray);
    }

    @Test
    public final void should allow request with wrong token when policy is allowMissingOrFailed() {
        String token = JWTFilterTest.tokenForProvider$default(this, "wrong-provider", null, 2, null);
        this.registerEnvoyServiceAndWait();
        EgressOperations egressOperations = echo2Envoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + token)));
        Response echoResponse = EgressOperations.callService$default(egressOperations, "echo", map, "/first-provider-allow-missing-or-failed", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isOk(ResponseAssertionsKt.isFrom((ObjectAssert<Response>)egressOperations, service));
    }

    @Test
    public final void should allow client with oauth selector when oauth is not specified for given endpoint() {
        this.registerClientWithAuthority("first-provider", "client1-rbac", "team1");
        String token = this.tokenForProvider("first-provider", "client1-rbac");
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/team-access", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)stringArray), service);
    }

    @Test
    public final void should allow request with token when policy is strict, unlisted clients policy is log and there are no clients() {
        String token = JWTFilterTest.tokenForProvider$default(this, "first-provider", null, 2, null);
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/no-clients", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)stringArray), service);
    }

    @Test
    public final void should allow request  with token from unlisted client when policy is strict, unlisted clients policy is log and there are other clients defined() {
        String token = JWTFilterTest.tokenForProvider$default(this, "first-provider", null, 2, null);
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/log-with-clients", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)stringArray), service);
    }

    @Test
    public final void should reject request with wrong token when policy is strict, unlisted clients policy is log and there are no clients() {
        String token = JWTFilterTest.tokenForProvider$default(this, "wrong-provider", null, 2, null);
        String[] stringArray = new String[]{"Authorization", "Bearer " + token};
        Response response2 = envoy.getIngressOperations().callLocalService("/no-clients", Headers.Companion.of(stringArray));
        stringArray = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"assertThat(response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)stringArray);
    }

    private final void registerEnvoyServiceAndWait() {
        String[] stringArray = consul.getServer().getOperations();
        EnvoyExtension envoyExtension = envoy;
        List list = CollectionsKt.listOf((Object)"mtls:enabled");
        ConsulOperations.registerServiceWithEnvoyOnIngress$default((ConsulOperations)stringArray, envoyExtension, null, "echo", false, list, 10, null);
        stringArray = new String[]{"echo"};
        echo2Envoy.waitForAvailableEndpoints(stringArray);
    }

    private final String tokenForProvider(String provider, String clientId) {
        ResponseBody responseBody = HttpResponseCloser.INSTANCE.addToCloseableResponses(new OkHttpClient().newCall(new Request.Builder().post((RequestBody)new FormBody.Builder(null, 1, null).add("client_id", clientId).build()).url(oAuthServer.getTokenAddress(provider)).build()).execute()).body();
        Intrinsics.checkNotNull((Object)responseBody);
        return responseBody.string();
    }

    static /* synthetic */ String tokenForProvider$default(JWTFilterTest jWTFilterTest, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "client1";
        }
        return jWTFilterTest.tokenForProvider(string, string2);
    }

    private final void registerClientWithAuthority(String provider, String clientId, String authority) {
        String body = "{\n            \"clientId\": \"" + clientId + "\",\n            \"clientSecret\": \"secret\",\n             \"authorities\":[\"" + authority + "\"]\n        }";
        new OkHttpClient().newCall(new Request.Builder().put(RequestBody.Companion.create(MediaType.JSON_MEDIA_TYPE, body)).url("http://localhost:" + oAuthServer.container().port() + "/" + provider + "/client").build()).execute().close();
    }

    static {
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.outgoing-permissions.enabled", (Object)true);
        pairArray[1] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true);
        pairArray[2] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true);
        Pair[] pairArray2 = new Pair[2];
        URI uRI = URI.create("http://oauth/first-provider/jwks");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"http://oauth/first-provider/jwks\")");
        pairArray2[0] = TuplesKt.to((Object)"first-provider", (Object)new OAuthProvider(uRI, false, "oauth", 0, null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"first-provider-prefix", (Object)"authorities")), 58, null));
        uRI = URI.create(oAuthServer.getJwksAddress("second-provider"));
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(oAuthServer.getJw\u2026dress(\"second-provider\"))");
        pairArray2[1] = TuplesKt.to((Object)"second-provider", (Object)new OAuthProvider(uRI, true, "second-provider", oAuthServer.container().oAuthPort(), null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"second-provider-prefix", (Object)"authorities")), 48, null));
        pairArray[3] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.jwt.providers", (Object)MapsKt.mapOf((Pair[])pairArray2));
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])pairArray));
        service = new EchoServiceExtension();
        echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"oauth\"\n      incoming:\n        unlistedEndpointsPolicy: blockAndLog\n        endpoints: \n        - path: '/first-provider-protected'\n          clients: ['echo2']\n          unlistedClientsPolicy: blockAndLog\n          oauth:\n            provider: 'first-provider'\n            verification: offline\n            policy: strict\n        - path: '/second-provider-protected'\n          clients: ['echo2']\n          unlistedClientsPolicy: blockAndLog\n          oauth:\n            provider: 'second-provider'\n            verification: offline\n            policy: strict\n        - path: '/rbac-clients-test'\n          clients: ['first-provider-prefix:team1', 'first-provider-prefix:team2','second-provider-prefix:team3']\n          unlistedClientsPolicy: blockAndLog\n          oauth:\n            provider: 'first-provider'\n            verification: offline\n            policy: strict\n        - path: '/oauth-or-tls'\n          clients: ['first-provider-prefix:team1', 'first-provider-prefix:team2', 'echo2']\n          unlistedClientsPolicy: blockAndLog\n          oauth:\n            provider: 'first-provider'\n            verification: offline\n            policy: allowMissing\n        - path: '/first-provider-allow-missing-or-failed'\n          clients: ['echo2']\n          unlistedClientsPolicy: blockAndLog\n          oauth:\n            provider: 'first-provider'\n            verification: offline\n            policy: allowMissingOrFailed\n        - path: '/team-access'\n          clients: ['first-provider-prefix:team1']\n          unlistedClientsPolicy: blockAndLog\n        - pathPrefix: '/no-clients'\n          clients: []\n          unlistedClientsPolicy: log\n          oauth:\n            provider: 'first-provider'\n            verification: offline\n            policy: strict\n        - path: '/log-with-clients'\n          clients: [some-service, other-service]\n          methods: [ GET ]\n          unlistedClientsPolicy: log\n          oauth:\n            provider: 'first-provider'\n            verification: offline\n            policy: strict", null, null, null, 59, null);
        oauthConfig = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        unlistedEndpointsPolicy: log\n        endpoints: []";
        oauthEnvoy = new EnvoyExtension(envoyControl, oAuthServer, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getOAuthEnvoyConfig(), null, "oauth", oauthConfig, null, null, null, 57, null));
        envoy = new EnvoyExtension(envoyControl, service, echoConfig);
        echo2Config = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"";
        echo2Envoy = new EnvoyExtension(envoyControl, service, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, echo2Config, null, null, null, 59, null));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/JWTFilterTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo2Config", "", "echo2Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echoConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "envoy", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "oAuthServer", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/OAuthServerExtension;", "oauthConfig", "oauthEnvoy", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

