/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import com.ecwid.consul.v1.agent.model.NewService;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Headers;
import okhttp3.Response;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import pl.allegro.tech.servicemesh.envoycontrol.RateLimitTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J<\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H&J\b\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u0003H\u0017\u00a8\u0006\u001c"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RateLimitTest;", "", "awaitBeginningOfASecond", "", "awaitBeginningOfNextSecond", "awaitMaxSecond", "maxSecond", "", "awaitUntilLimited", "endpoint", "", "clientServiceName", "poll", "Ljava/time/Duration;", "resultFn", "Lkotlin/Function1;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "rateLimitService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpContainer;", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "should limit using rateLimit", "envoy-control-tests"})
public interface RateLimitTest {
    @NotNull
    public ConsulExtension consul();

    @NotNull
    public EnvoyControlExtension envoyControl();

    @NotNull
    public EchoServiceExtension service();

    @NotNull
    public EnvoyExtension envoy();

    @NotNull
    public ServiceExtension<? extends HttpContainer> rateLimitService();

    @Test
    public void should limit using rateLimit();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void should limit using rateLimit(@NotNull RateLimitTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ServiceExtension<? extends HttpContainer> extension = this_.rateLimitService();
            ConsulOperations.registerService$default(this_.consul().getServer().getOperations(), extension, null, "ratelimit-grpc", false, CollectionsKt.listOf((Object)"envoy"), (Function1)new Function1<NewService, Unit>(extension){
                final /* synthetic */ ServiceExtension<? extends HttpContainer> $extension;
                {
                    this.$extension = $extension;
                    super(1);
                }

                public final void invoke(@NotNull NewService service) {
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    service.getCheck().setHttp("http://" + this.$extension.container().ipAddress() + ":" + this.$extension.container().httpPort() + "/healthcheck");
                    service.getCheck().setInterval("3s");
                }
            }, 10, null);
            Duration duration = Duration.ofMillis(500L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(500)");
            DefaultImpls.awaitUntilLimited$default(this_, "/banned", null, duration, null, 10, null);
            DefaultImpls.awaitMaxSecond(this_, 55);
            DefaultImpls.awaitUntilLimited$default(this_, "/limited-30-m", null, null, should limit using rateLimit.2.INSTANCE, 6, null);
            DefaultImpls.awaitBeginningOfASecond(this_);
            DefaultImpls.awaitUntilLimited$default(this_, "/limited-15-s", null, null, should limit using rateLimit.3.INSTANCE, 6, null);
            DefaultImpls.awaitBeginningOfNextSecond(this_);
            DefaultImpls.awaitUntilLimited$default(this_, "/limited-15-s", null, null, should limit using rateLimit.4.INSTANCE, 6, null);
            DefaultImpls.awaitBeginningOfNextSecond(this_);
            DefaultImpls.awaitUntilLimited$default(this_, "/one/two/three", null, null, should limit using rateLimit.5.INSTANCE, 6, null);
            DefaultImpls.awaitUntilLimited$default(this_, "/banned-for-harry-potter", "harry-potter", null, should limit using rateLimit.6.INSTANCE, 4, null);
            DefaultImpls.awaitUntilLimited$default(this_, "/banned-for-all", "darth-vader", null, should limit using rateLimit.7.INSTANCE, 4, null);
        }

        private static void awaitBeginningOfASecond(RateLimitTest this_) {
            Duration duration = Duration.ofMillis(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(1)");
            AwaitAssertionsKt.untilAsserted$default(duration, null, awaitBeginningOfASecond.1.INSTANCE, 2, null);
        }

        private static void awaitBeginningOfNextSecond(RateLimitTest this_) {
            long nextSecondStart = (System.currentTimeMillis() / (long)1000 + 1L) * (long)1000;
            Duration duration = Duration.ofMillis(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(1)");
            AwaitAssertionsKt.untilAsserted$default(duration, null, new Function0<AbstractLongAssert<?>>(nextSecondStart){
                final /* synthetic */ long $nextSecondStart;
                {
                    this.$nextSecondStart = $nextSecondStart;
                    super(0);
                }

                public final AbstractLongAssert<?> invoke() {
                    return Assertions.assertThat((long)System.currentTimeMillis()).isGreaterThanOrEqualTo(this.$nextSecondStart);
                }
            }, 2, null);
        }

        private static void awaitMaxSecond(RateLimitTest this_, int maxSecond) {
            Duration duration = Duration.ofMillis(100L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(100)");
            AwaitAssertionsKt.untilAsserted$default(duration, null, new Function0<AbstractLongAssert<?>>(maxSecond){
                final /* synthetic */ int $maxSecond;
                {
                    this.$maxSecond = $maxSecond;
                    super(0);
                }

                public final AbstractLongAssert<?> invoke() {
                    long currentSecond = System.currentTimeMillis() % (long)60000 / (long)1000;
                    return Assertions.assertThat((long)currentSecond).isLessThanOrEqualTo((long)this.$maxSecond);
                }
            }, 2, null);
        }

        private static void awaitUntilLimited(RateLimitTest this_, String endpoint, String clientServiceName, Duration poll, Function1<? super Integer, Unit> resultFn) {
            Ref.IntRef counter = new Ref.IntRef();
            AwaitAssertionsKt.untilAsserted$default(poll, null, new Function0<AbstractIntegerAssert<?>>(counter, this_, endpoint, clientServiceName){
                final /* synthetic */ Ref.IntRef $counter;
                final /* synthetic */ RateLimitTest this$0;
                final /* synthetic */ String $endpoint;
                final /* synthetic */ String $clientServiceName;
                {
                    this.$counter = $counter;
                    this.this$0 = $receiver;
                    this.$endpoint = $endpoint;
                    this.$clientServiceName = $clientServiceName;
                    super(0);
                }

                public final AbstractIntegerAssert<?> invoke() {
                    Headers headers;
                    int n = this.$counter.element;
                    this.$counter.element = n + 1;
                    IngressOperations ingressOperations = this.this$0.envoy().getIngressOperations();
                    String string = this.$endpoint;
                    String string2 = this.$clientServiceName;
                    if (string2 == null) {
                        headers = null;
                    } else {
                        String string3 = string2;
                        String string4 = this.$clientServiceName;
                        String string5 = string3;
                        String string6 = string;
                        IngressOperations ingressOperations2 = ingressOperations;
                        boolean bl = false;
                        String[] stringArray = new String[]{"x-service-name", string4};
                        Headers headers2 = Headers.Companion.of(stringArray);
                        ingressOperations = ingressOperations2;
                        string = string6;
                        headers = headers2;
                    }
                    Headers headers3 = headers;
                    if (headers == null) {
                        headers3 = Headers.Companion.of(new String[0]);
                    }
                    Response response2 = ingressOperations.callLocalService(string, headers3);
                    return Assertions.assertThat((int)response2.code()).isEqualTo(429);
                }
            }, 2, null);
            resultFn.invoke((Object)counter.element);
        }

        public static /* synthetic */ void awaitUntilLimited$default(RateLimitTest rateLimitTest, String string, String string2, Duration duration, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: awaitUntilLimited");
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                Duration duration2 = Duration.ofMillis(0L);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(0)");
                duration = duration2;
            }
            if ((n & 8) != 0) {
                function1 = awaitUntilLimited.1.INSTANCE;
            }
            DefaultImpls.awaitUntilLimited(rateLimitTest, string, string2, duration, (Function1<? super Integer, Unit>)function1);
        }
    }
}

