/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0004J.\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0014J\b\u0010\r\u001a\u00020\u0004H\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0004J\b\u0010\u0014\u001a\u00020\u0013H\u0017J\b\u0010\u0015\u001a\u00020\u0013H\u0017J\b\u0010\u0016\u001a\u00020\u0013H\u0017J\b\u0010\u0017\u001a\u00020\u0013H\u0017J\b\u0010\u0018\u001a\u00020\u0013H\u0017J\b\u0010\u0019\u001a\u00020\u0013H\u0017J\b\u0010\u001a\u001a\u00020\u0013H\u0017J\b\u0010\u001b\u001a\u00020\u0013H\u0017J\b\u0010\u001c\u001a\u00020\u0013H\u0017J\b\u0010\u001d\u001a\u00020\u0013H\u0017\u00a8\u0006\u001f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ServiceTagsTest;", "", "()V", "callEchoServiceRepeatedly", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "repeat", "", "tag", "", "assertNoErrors", "", "callServiceRepeatedly", "service", "callStats", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "registerServices", "", "should not route request with multiple tags if service is not whitelisted", "should not route request with three tags if combination is not allowed", "should not route request with two tags if combination is not allowed", "should return 503 if instance with requested tag is not found", "should return 503 if requested tag is blacklisted", "should route request with three tags if combination is valid", "should route request with two tags if combination is valid", "should route requests to all instances", "should route requests to instance with tag ipsum", "should route requests to instances with tag lorem", "Companion", "envoy-control-tests"})
public class ServiceTagsTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension regularService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension loremService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension loremIpsumService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension genericService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;

    protected final void registerServices() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = regularService;
        List list = CollectionsKt.emptyList();
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = loremService;
        Object[] objectArray = new String[]{"lorem", "blacklisted"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = loremIpsumService;
        objectArray = new String[]{"lorem", "ipsum"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
    }

    @Test
    public void should route requests to instance with tag ipsum() {
        this.registerServices();
        String[] stringArray = new String[]{"echo"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = ServiceTagsTest.callEchoServiceRepeatedly$default(this, 10, "ipsum", false, 4, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(regularService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremIpsumService)).isEqualTo(10);
    }

    @Test
    public void should route requests to instances with tag lorem() {
        this.registerServices();
        String[] stringArray = new String[]{"echo"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = ServiceTagsTest.callEchoServiceRepeatedly$default(this, 20, "lorem", false, 4, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(20);
        Assertions.assertThat((int)stats2.hits(regularService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremService)).isGreaterThan(2);
        Assertions.assertThat((int)stats2.hits(loremIpsumService)).isGreaterThan(2);
        Assertions.assertThat((int)(stats2.hits(loremService) + stats2.hits(loremIpsumService))).isEqualTo(20);
    }

    @Test
    public void should route requests to all instances() {
        this.registerServices();
        String[] stringArray = new String[]{"echo"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = ServiceTagsTest.callEchoServiceRepeatedly$default(this, 20, null, false, 6, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(20);
        Assertions.assertThat((int)stats2.hits(regularService)).isGreaterThan(1);
        Assertions.assertThat((int)stats2.hits(loremService)).isGreaterThan(1);
        Assertions.assertThat((int)stats2.hits(loremIpsumService)).isGreaterThan(1);
        Assertions.assertThat((int)(stats2.hits(regularService) + stats2.hits(loremService) + stats2.hits(loremIpsumService))).isEqualTo(20);
    }

    @Test
    public void should return 503 if instance with requested tag is not found() {
        this.registerServices();
        String[] stringArray = new String[]{"echo"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = this.callEchoServiceRepeatedly(10, "dolom", false);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(regularService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremIpsumService)).isEqualTo(0);
    }

    @Test
    public void should return 503 if requested tag is blacklisted() {
        this.registerServices();
        String[] stringArray = new String[]{"echo"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = this.callEchoServiceRepeatedly(10, "blacklisted", false);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(regularService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(loremIpsumService)).isEqualTo(0);
    }

    @Test
    public void should route request with three tags if combination is valid() {
        EchoServiceExtension matching = loremService;
        EchoServiceExtension notMatching = loremIpsumService;
        String[] stringArray = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, matching, null, "service-1", false, list, null, 42, null);
        stringArray = consul.getServer().getOperations();
        objectArray = new String[]{"version:v1.5", "hardware:c64", "role:master"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, notMatching, null, "service-1", false, list, null, 42, null);
        stringArray = new String[]{"service-1"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = ServiceTagsTest.callServiceRepeatedly$default(this, "service-1", 10, "hardware:c32,role:master,version:v1.5", false, 8, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(matching)).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(notMatching)).isEqualTo(0);
    }

    @Test
    public void should not route request with multiple tags if service is not whitelisted() {
        EchoServiceExtension matching = loremService;
        String[] stringArray = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, matching, null, "service-3", false, list, null, 42, null);
        stringArray = new String[]{"service-3"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats threeTagsStats = this.callServiceRepeatedly("service-3", 10, "hardware:c32,role:master,version:v1.5", false);
        CallStats twoTagsStats = this.callServiceRepeatedly("service-3", 10, "hardware:c32,role:master", false);
        CallStats oneTagStats = ServiceTagsTest.callServiceRepeatedly$default(this, "service-3", 10, "role:master", false, 8, null);
        Assertions.assertThat((int)threeTagsStats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)threeTagsStats.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)threeTagsStats.hits(matching)).isEqualTo(0);
        Assertions.assertThat((int)twoTagsStats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)twoTagsStats.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)twoTagsStats.hits(matching)).isEqualTo(0);
        Assertions.assertThat((int)oneTagStats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)oneTagStats.getFailedHits()).isEqualTo(0);
        Assertions.assertThat((int)oneTagStats.hits(matching)).isEqualTo(10);
    }

    @Test
    public void should not route request with three tags if combination is not allowed() {
        EchoServiceExtension service1Matching = loremService;
        EchoServiceExtension service2Matching = loremIpsumService;
        String[] stringArray = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "ram:512"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, service1Matching, null, "service-1", false, list, null, 42, null);
        stringArray = consul.getServer().getOperations();
        objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, service2Matching, null, "service-2", false, list, null, 42, null);
        stringArray = new String[]{"service-1", "service-2"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats service1Stats = this.callServiceRepeatedly("service-1", 10, "hardware:c32,ram:512,version:v1.5", false);
        CallStats service2Stats = this.callServiceRepeatedly("service-2", 10, "hardware:c32,role:master,version:v1.5", false);
        Assertions.assertThat((int)service1Stats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)service1Stats.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)service1Stats.hits(service1Matching)).isEqualTo(0);
        Assertions.assertThat((int)service2Stats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)service2Stats.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)service2Stats.hits(service1Matching)).isEqualTo(0);
    }

    @Test
    public void should route request with two tags if combination is valid() {
        EchoServiceExtension service1Matching = loremService;
        EchoServiceExtension service1NotMatching = regularService;
        EchoServiceExtension service2Master = loremIpsumService;
        EchoServiceExtension service2Secondary = genericService;
        String[] stringArray = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"version:v2.0", "hardware:c32", "role:master"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, service1Matching, null, "service-1", false, list, null, 42, null);
        stringArray = consul.getServer().getOperations();
        objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, service1NotMatching, null, "service-1", false, list, null, 42, null);
        stringArray = consul.getServer().getOperations();
        objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, service2Master, null, "service-2", false, list, null, 42, null);
        stringArray = consul.getServer().getOperations();
        objectArray = new String[]{"version:v2.0", "hardware:c32", "role:secondary"};
        list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, service2Secondary, null, "service-2", false, list, null, 42, null);
        stringArray = new String[]{"service-1", "service-2"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats service1Stats = ServiceTagsTest.callServiceRepeatedly$default(this, "service-1", 10, "hardware:c32,version:v2.0", false, 8, null);
        CallStats service2MasterStats = ServiceTagsTest.callServiceRepeatedly$default(this, "service-2", 10, "hardware:c32,version:v1.5", false, 8, null);
        CallStats service2SecondaryStats = ServiceTagsTest.callServiceRepeatedly$default(this, "service-2", 10, "role:secondary,version:v2.0", false, 8, null);
        Assertions.assertThat((int)service1Stats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)service1Stats.hits(service1Matching)).isEqualTo(10);
        Assertions.assertThat((int)service2MasterStats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)service2MasterStats.hits(service2Master)).isEqualTo(10);
        Assertions.assertThat((int)service2SecondaryStats.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)service2SecondaryStats.hits(service2Secondary)).isEqualTo(10);
    }

    @Test
    public void should not route request with two tags if combination is not allowed() {
        EchoServiceExtension matching = loremService;
        String[] stringArray = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"version:v1.5", "hardware:c32", "role:master"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default((ConsulOperations)stringArray, matching, null, "service-2", false, list, null, 42, null);
        stringArray = new String[]{"service-2"};
        this.envoy().waitForReadyServices(stringArray);
        CallStats stats2 = this.callServiceRepeatedly("service-2", 10, "hardware:c32,role:master", false);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(matching)).isEqualTo(0);
    }

    @NotNull
    protected final CallStats callEchoServiceRepeatedly(int repeat, @Nullable String tag, boolean assertNoErrors) {
        return this.callServiceRepeatedly("echo", repeat, tag, assertNoErrors);
    }

    public static /* synthetic */ CallStats callEchoServiceRepeatedly$default(ServiceTagsTest serviceTagsTest, int n, String string, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callEchoServiceRepeatedly");
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return serviceTagsTest.callEchoServiceRepeatedly(n, string, bl);
    }

    @NotNull
    protected CallStats callStats() {
        Object[] objectArray = new EchoServiceExtension[]{regularService, loremService, loremIpsumService, genericService};
        return new CallStats(CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected CallStats callServiceRepeatedly(@NotNull String service, int repeat, @Nullable String tag, boolean assertNoErrors) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        CallStats stats2 = this.callStats();
        EgressOperations egressOperations = this.envoy().getEgressOperations();
        String string = service;
        CallStats callStats = stats2;
        int n = repeat;
        int n2 = repeat;
        Function1 function1 = null;
        String string2 = tag;
        if (string2 == null) {
            map = null;
        } else {
            void it;
            String string3 = string2;
            Function1 function12 = function1;
            int n3 = n2;
            int n4 = n;
            CallStats callStats2 = callStats;
            String string4 = string;
            EgressOperations egressOperations2 = egressOperations;
            boolean bl = false;
            Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag", (Object)it));
            egressOperations = egressOperations2;
            string = string4;
            callStats = callStats2;
            n = n4;
            n2 = n3;
            function1 = function12;
            map = map2;
        }
        Map map3 = map;
        if (map == null) {
            map3 = MapsKt.emptyMap();
        }
        EgressOperations.callServiceRepeatedly$default(egressOperations, string, callStats, n, n2, function1, map3, null, assertNoErrors, 80, null);
        return stats2;
    }

    public static /* synthetic */ CallStats callServiceRepeatedly$default(ServiceTagsTest serviceTagsTest, String string, int n, String string2, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callServiceRepeatedly");
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return serviceTagsTest.callServiceRepeatedly(string, n, string2, bl);
    }

    @NotNull
    public EnvoyExtension envoy() {
        return envoy;
    }

    @NotNull
    public EnvoyControlExtension envoyControl() {
        return envoyControl;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.metadata-key", (Object)"tag"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.allowed-tags-combinations[0].service-name", (Object)"service-1"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.allowed-tags-combinations[0].tags", (Object)"version:.*,hardware:.*,role:.*"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.allowed-tags-combinations[1].service-name", (Object)"service-2"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.allowed-tags-combinations[1].tags", (Object)"version:.*,role:.*"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.allowed-tags-combinations[2].service-name", (Object)"service-2"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.allowed-tags-combinations[2].tags", (Object)"version:.*,hardware:.*"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.routing-excluded-tags[0].value", (Object)"blacklist"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.routing-excluded-tags[0].type", (Object)"PREFIX"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.canary.enabled", (Object)false)};
        properties = MapsKt.mapOf((Pair[])pairArray);
        consul = new ConsulExtension();
        envoyControl = new EnvoyControlExtension(consul, properties);
        regularService = new EchoServiceExtension();
        loremService = new EchoServiceExtension();
        loremIpsumService = new EchoServiceExtension();
        genericService = new EchoServiceExtension();
        envoy = new EnvoyExtension(envoyControl, regularService, null, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ServiceTagsTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "genericService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "loremIpsumService", "loremService", "properties", "", "", "regularService", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

