/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.SnapshotDebugResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.debug.Versions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u000eH\u0017J\b\u0010\u0011\u001a\u00020\u000eH\u0017J\b\u0010\u0012\u001a\u00020\u000eH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/SnapshotDebugTest;", "", "()V", "missingNodeJson", "", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "should inform about missing snapshot when given node does not exist", "", "should return global snapshot debug info from ads", "should return global snapshot debug info from xds", "should return snapshot debug info containing snapshot contents", "should return snapshot debug info containing snapshot versions", "Companion", "envoy-control-tests"})
public class SnapshotDebugTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String missingNodeJson = ((Object)StringsKt.trim((CharSequence)"{\n     \"metadata\": {\n      \"service_name\": \"service-mesh-service-first\",\n      \"identity\": \"\",\n      \"service_version\": \"0.1.16-SKYHELIX-839-eds-version-metric-SNAPSHOT\",\n      \"proxy_settings\": {\n       \"incoming\": {\n        \"endpoints\": null,\n        \"healthCheck\": null,\n        \"roles\": null,\n        \"timeoutPolicy\": null\n       },\n       \"outgoing\": {\n        \"dependencies\": [\n         {\n          \"handleInternalRedirect\": null,\n          \"timeoutPolicy\": null,\n          \"endpoints\": [],\n          \"domain\": null,\n          \"service\": \"*\"\n         }\n        ]\n       }\n      },\n      \"ads\": true\n     },\n     \"locality\": {\n      \"zone\": \"dev-dc4\"\n     }\n    }\n")).toString();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(consul, null, 2, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy = new EnvoyExtension(envoyControl, service, null, 4, null);

    @Test
    public void should return snapshot debug info containing snapshot versions() {
        ConsulOperations.registerService$default(this.consul().getServer().getOperations(), this.service(), null, "echo", false, null, null, 58, null);
        String nodeMetadata = this.envoy().getContainer().admin().nodeInfo();
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this, nodeMetadata){
            final /* synthetic */ SnapshotDebugTest this$0;
            final /* synthetic */ String $nodeMetadata;
            {
                this.this$0 = $receiver;
                this.$nodeMetadata = $nodeMetadata;
                super(0);
            }

            public final AbstractStringAssert<?> invoke() {
                SnapshotDebugResponse snapshot = this.this$0.envoyControl().getApp().getSnapshot(this.$nodeMetadata);
                String edsVersion = this.this$0.envoy().getContainer().admin().statValue("cluster.echo.version");
                String cdsVersion = this.this$0.envoy().getContainer().admin().statValue("cluster_manager.cds.version");
                String rdsVersion = this.this$0.envoy().getContainer().admin().statValue("http.egress_http.rds.default_routes.version");
                String ldsVersion = this.this$0.envoy().getContainer().admin().statValue("listener_manager.lds.version");
                Versions versions = snapshot.getVersions();
                Intrinsics.checkNotNull((Object)versions);
                Assertions.assertThat((String)versions.getClusters().getMetric()).isEqualTo(cdsVersion);
                Assertions.assertThat((String)snapshot.getVersions().getEndpoints().getMetric()).isEqualTo(edsVersion);
                Assertions.assertThat((String)snapshot.getVersions().getRoutes().getMetric()).isEqualTo(rdsVersion);
                return Assertions.assertThat((String)snapshot.getVersions().getListeners().getMetric()).isEqualTo(ldsVersion);
            }
        }, 3, null);
    }

    @Test
    public void should return snapshot debug info containing snapshot contents() {
        ConsulOperations.registerService$default(this.consul().getServer().getOperations(), this.service(), null, "echo", false, null, null, 58, null);
        String nodeMetadata = this.envoy().getContainer().admin().nodeInfo();
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<IterableAssert<JsonNode>>(this, nodeMetadata){
            final /* synthetic */ SnapshotDebugTest this$0;
            final /* synthetic */ String $nodeMetadata;
            {
                this.this$0 = $receiver;
                this.$nodeMetadata = $nodeMetadata;
                super(0);
            }

            public final IterableAssert<JsonNode> invoke() {
                SnapshotDebugResponse snapshot = this.this$0.envoyControl().getApp().getSnapshot(this.$nodeMetadata);
                ObjectNode objectNode = snapshot.getSnapshot();
                Intrinsics.checkNotNull((Object)objectNode);
                Assertions.assertThat((Iterable)((Iterable)objectNode.get("clusters"))).isNotEmpty();
                Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("routes"))).isNotEmpty();
                Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("endpoints"))).isNotEmpty();
                return (IterableAssert)Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("listeners"))).isNotEmpty();
            }
        }, 3, null);
    }

    @Test
    public void should inform about missing snapshot when given node does not exist() {
        SnapshotDebugResponse snapshot = this.envoyControl().getApp().getSnapshot(this.missingNodeJson);
        Assertions.assertThat((boolean)snapshot.getFound()).isFalse();
    }

    @Test
    public void should return global snapshot debug info from xds() {
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this){
            final /* synthetic */ SnapshotDebugTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractStringAssert<?> invoke() {
                SnapshotDebugResponse snapshot = this.this$0.envoyControl().getApp().getGlobalSnapshot(true);
                ObjectNode objectNode = snapshot.getSnapshot();
                Intrinsics.checkNotNull((Object)objectNode);
                Assertions.assertThat((Iterable)((Iterable)objectNode.get("clusters"))).isNotEmpty();
                Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("endpoints"))).isNotEmpty();
                CharSequence[] charSequenceArray = snapshot.getSnapshot().get("clusters");
                Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"snapshot.snapshot[\"clusters\"]");
                AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)((JsonNode)CollectionsKt.first((Iterable)((Iterable)charSequenceArray))).get("edsClusterConfig").get("edsConfig").toString());
                charSequenceArray = new CharSequence[]{"envoy-control-xds"};
                return (AbstractStringAssert)abstractStringAssert.contains(charSequenceArray);
            }
        }, 3, null);
    }

    @Test
    public void should return global snapshot debug info from ads() {
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this){
            final /* synthetic */ SnapshotDebugTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractStringAssert<?> invoke() {
                SnapshotDebugResponse snapshotXdsNull = this.this$0.envoyControl().getApp().getGlobalSnapshot(null);
                SnapshotDebugResponse snapshotXdsFalse = this.this$0.envoyControl().getApp().getGlobalSnapshot(false);
                ObjectNode objectNode = snapshotXdsNull.getSnapshot();
                Intrinsics.checkNotNull((Object)objectNode);
                Assertions.assertThat((Iterable)((Iterable)objectNode.get("clusters"))).isNotEmpty();
                Assertions.assertThat((Iterable)((Iterable)snapshotXdsNull.getSnapshot().get("endpoints"))).isNotEmpty();
                ObjectNode objectNode2 = snapshotXdsFalse.getSnapshot();
                Intrinsics.checkNotNull((Object)objectNode2);
                Assertions.assertThat((Iterable)((Iterable)objectNode2.get("clusters"))).isNotEmpty();
                Assertions.assertThat((Iterable)((Iterable)snapshotXdsFalse.getSnapshot().get("endpoints"))).isNotEmpty();
                CharSequence[] charSequenceArray = snapshotXdsNull.getSnapshot().get("clusters");
                Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"snapshotXdsNull.snapshot[\"clusters\"]");
                AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)((JsonNode)CollectionsKt.first((Iterable)((Iterable)charSequenceArray))).get("edsClusterConfig").get("edsConfig").toString());
                charSequenceArray = new CharSequence[]{"ads"};
                abstractStringAssert.contains(charSequenceArray);
                charSequenceArray = snapshotXdsFalse.getSnapshot().get("clusters");
                Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"snapshotXdsFalse.snapshot[\"clusters\"]");
                AbstractStringAssert abstractStringAssert2 = Assertions.assertThat((String)((JsonNode)CollectionsKt.first((Iterable)((Iterable)charSequenceArray))).get("edsClusterConfig").get("edsConfig").toString());
                charSequenceArray = new CharSequence[]{"ads"};
                return (AbstractStringAssert)abstractStringAssert2.contains(charSequenceArray);
            }
        }, 3, null);
    }

    @NotNull
    public ConsulExtension consul() {
        return consul;
    }

    @NotNull
    public EnvoyControlExtension envoyControl() {
        return envoyControl;
    }

    @NotNull
    public EnvoyExtension envoy() {
        return envoy;
    }

    @NotNull
    public EchoServiceExtension service() {
        return service;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/SnapshotDebugTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

