/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.HttpsEchoResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.GenericServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.ClientNameTrustedHeaderTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/ClientNameTrustedHeaderTest;", "", "()V", "beforeEach", "", "should add trusted client identity header to ingress request to local service", "should always remove trusted client identity header from client ingress request", "should not set trusted client identity header based on URIs in certificate SAN fields having invalid format", "should override trusted client identity header in ingress request to local service", "should set trusted client identity header based on all URIs in certificate SAN field", "waitForEnvoysInitialized", "Companion", "envoy-control-tests"})
public final class ClientNameTrustedHeaderTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<HttpsEchoContainer> service;
    @NotNull
    private static String proxySettings;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;
    @NotNull
    private static final String echoClientsConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy2;
    @NotNull
    private static final EnvoyConfig echo4EnvoyAuthConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy4MultipleSANs;
    @NotNull
    private static final EnvoyConfig echo5EnvoyAuthConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy5InvalidSANs;

    @BeforeEach
    public final void beforeEach() {
        ConsulOperations.registerService$default(consul.getServer().getOperations(), "echo", "echo", envoy.getContainer().ipAddress(), 5001, false, CollectionsKt.listOf((Object)"mtls:enabled"), null, 80, null);
        this.waitForEnvoysInitialized();
    }

    private final void waitForEnvoysInitialized() {
        Duration duration = Duration.ofSeconds(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(20)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, waitForEnvoysInitialized.1.INSTANCE, 1, null);
    }

    @Test
    public final void should always remove trusted client identity header from client ingress request() {
        HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(envoy2.getIngressOperations().callLocalService("/endpoint", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-client-name-trusted", (Object)"fake-service")))));
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isFrom((ObjectAssert<HttpsEchoResponse>)objectAssert, service.container());
        Assertions.assertThat(response2.getRequestHeaders()).doesNotContainKey((Object)"x-client-name-trusted");
    }

    @Test
    public final void should add trusted client identity header to ingress request to local service() {
        HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy2.getEgressOperations(), "echo", MapsKt.emptyMap(), "/endpoint", null, null, 24, null));
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isFrom((ObjectAssert<HttpsEchoResponse>)objectAssert, service.container());
        Assertions.assertThat(response2.getRequestHeaders()).containsEntry((Object)"x-client-name-trusted", (Object)"echo2");
    }

    @Test
    public final void should override trusted client identity header in ingress request to local service() {
        Map headers = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-client-name-trusted", (Object)"fake-service"));
        HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy2.getEgressOperations(), "echo", headers, "/endpoint", null, null, 24, null));
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isFrom((ObjectAssert<HttpsEchoResponse>)objectAssert, service.container());
        Assertions.assertThat(response2.getRequestHeaders()).containsEntry((Object)"x-client-name-trusted", (Object)"echo2");
    }

    @Test
    public final void should set trusted client identity header based on all URIs in certificate SAN field() {
        HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy4MultipleSANs.getEgressOperations(), "echo", MapsKt.emptyMap(), "/endpoint", null, null, 24, null));
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isFrom((ObjectAssert<HttpsEchoResponse>)objectAssert, service.container());
        Assertions.assertThat(response2.getRequestHeaders()).containsEntry((Object)"x-client-name-trusted", (Object)"echo4, echo4-special, echo4-admin");
    }

    @Test
    public final void should not set trusted client identity header based on URIs in certificate SAN fields having invalid format() {
        HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(envoy5InvalidSANs.getEgressOperations(), "echo", MapsKt.emptyMap(), "/endpoint", null, null, 24, null));
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
        objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(response)");
        HttpsEchoResponseAssertionsKt.isFrom((ObjectAssert<HttpsEchoResponse>)objectAssert, service.container());
        Assertions.assertThat(response2.getRequestHeaders()).doesNotContainKey((Object)"x-client-name-trusted");
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.tls-authentication.require-client-certificate", (Object)false), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.trusted-client-identity-header", (Object)"x-client-name-trusted"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.tls-authentication.san-uri-format", (Object)"spiffe://{service-name}"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.tls-authentication.service-name-wildcard-regex", (Object)".+"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        service = new GenericServiceExtension<ServiceContainer>(new HttpsEchoContainer());
        proxySettings = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies: []";
        envoy = new EnvoyExtension(envoyControl, (ServiceExtension)service, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, proxySettings, null, null, null, 59, null));
        echoClientsConfig = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"";
        envoy2 = new EnvoyExtension(envoyControl, (ServiceExtension)service, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, echoClientsConfig, null, null, null, 59, null));
        object = EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig();
        String string = echoClientsConfig;
        echo4EnvoyAuthConfig = EnvoyConfig.copy$default((EnvoyConfig)object, null, "echo4", string, null, "/app/fullchain_echo4.pem", "/app/privkey_echo4.pem", 9, null);
        envoy4MultipleSANs = new EnvoyExtension(envoyControl, (ServiceExtension)service, echo4EnvoyAuthConfig);
        object = EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig();
        string = echoClientsConfig;
        echo5EnvoyAuthConfig = EnvoyConfig.copy$default((EnvoyConfig)object, null, "echo5", string, null, "/app/fullchain_echo5.pem", "/app/privkey_echo5.pem", 9, null);
        envoy5InvalidSANs = new EnvoyExtension(envoyControl, (ServiceExtension)service, echo5EnvoyAuthConfig);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/ClientNameTrustedHeaderTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo4EnvoyAuthConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "getEcho4EnvoyAuthConfig", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echo5EnvoyAuthConfig", "getEcho5EnvoyAuthConfig", "echoClientsConfig", "", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoy2", "envoy4MultipleSANs", "envoy5InvalidSANs", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "proxySettings", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/GenericServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoContainer;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnvoyConfig getEcho4EnvoyAuthConfig() {
            return echo4EnvoyAuthConfig;
        }

        @NotNull
        public final EnvoyConfig getEcho5EnvoyAuthConfig() {
            return echo5EnvoyAuthConfig;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

