/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.EnvoyAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.IncomingPermissionsRequestIdTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsRequestIdTest;", "", "()V", "afterEach", "", "beforeEach", "incoming permissions logs should contain requestId if present", "should handle request id containing double quotes", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsRequestIdTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String echoYaml = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints:\n        - path: \"/path\"\n          unlistedClientsPolicy: log\n          clients: []\n      outgoing:\n        dependencies:\n          - service: \"echo\"";
    @NotNull
    private static final EnvoyConfig echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, echoYaml, null, null, null, 59, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;

    @BeforeEach
    public final void beforeEach() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echoEnvoy, null, "echo", false, null, 26, null);
        echoEnvoy.getContainer().getLogRecorder().recordLogs((Function1<? super String, Boolean>)((Function1)beforeEach.1.INSTANCE));
        String[] stringArray = new String[]{"echo"};
        echoEnvoy.waitForAvailableEndpoints(stringArray);
    }

    @AfterEach
    public final void afterEach() {
        echoEnvoy.getContainer().getLogRecorder().stopRecording();
    }

    @Test
    public final void incoming permissions logs should contain requestId if present() {
        EgressOperations egressOperations = echoEnvoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-request-id", (Object)"123"));
        Response response2 = EgressOperations.callService$default(egressOperations, "echo", map, "/path", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(response)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)egressOperations);
        egressOperations = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default((ObjectAssert)egressOperations, "http", null, null, null, null, null, null, null, "123", 254, null);
    }

    @Test
    public final void should handle request id containing double quotes() {
        EgressOperations egressOperations = echoEnvoy.getEgressOperations();
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-request-id", (Object)"\""));
        Response response2 = EgressOperations.callService$default(egressOperations, "echo", map, "/path", null, null, 24, null);
        egressOperations = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(response)");
        ResponseAssertionsKt.isOk((ObjectAssert<Response>)egressOperations);
        egressOperations = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)egressOperations, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default((ObjectAssert)egressOperations, "http", null, null, null, null, null, null, null, "\"", 254, null);
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.request-identification-headers", (Object)CollectionsKt.listOf((Object)"x-request-id"))};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        echoService = new EchoServiceExtension();
        object = envoyControl;
        EnvoyConfig envoyConfig = echoConfig;
        EchoServiceExtension echoServiceExtension = echoService;
        echoEnvoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, envoyConfig);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsRequestIdTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echoConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echoEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echoYaml", "", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

