/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.reliability;

import com.ecwid.consul.v1.OperationException;
import java.io.Closeable;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Durations;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import pl.allegro.tech.servicemesh.envoycontrol.config.BaseEnvoyTest;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfiguration;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.reliability.ConsulRpcLimitReachedTest;
import pl.allegro.tech.servicemesh.envoycontrol.reliability.ReliabilityTest;
import pl.allegro.tech.servicemesh.envoycontrol.reliability.Toxiproxy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulRpcLimitReachedTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ReliabilityTest;", "()V", "assertEchoReachableThroughProxy", "", "burstRpcLimit", "", "consulOperations", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulOperations;", "is resilient to ECs consul client reaching RPC limit", "registerEchoInOtherAgentAfter", "time", "Ljava/time/Duration;", "rpcLimitReached", "Companion", "envoy-control-tests"})
public final class ConsulRpcLimitReachedTest
extends ReliabilityTest {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Test
    public final void is resilient to ECs consul client reaching RPC limit() {
        Duration duration = this.getFailureDuration().dividedBy(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"failureDuration.dividedBy(2L)");
        this.registerEchoInOtherAgentAfter(duration);
        ReliabilityTest reliabilityTest = this;
        duration = Durations.ONE_SECOND;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ONE_SECOND");
        ReliabilityTest.holdAssertionsTrue$default(reliabilityTest, null, duration, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ConsulRpcLimitReachedTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConsulRpcLimitReachedTest.access$rpcLimitReached(this.this$0);
            }
        }, 1, null);
        this.assertEchoReachableThroughProxy();
    }

    private final void assertEchoReachableThroughProxy() {
        Duration duration = BaseEnvoyTest.Companion.getDefaultDuration().multipliedBy(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"defaultDuration.multipliedBy(2L)");
        EnvoyControlTestConfiguration.Companion.untilAsserted(duration, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ ConsulRpcLimitReachedTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ObjectAssert<Response> invoke() {
                ObjectAssert<Response> objectAssert;
                Closeable closeable = (Closeable)EnvoyControlTestConfiguration.Companion.callService$default(EnvoyControlTestConfiguration.Companion, "echo", null, null, null, 14, null);
                ConsulRpcLimitReachedTest consulRpcLimitReachedTest = this.this$0;
                Throwable throwable = null;
                try {
                    Response it = (Response)closeable;
                    boolean bl = false;
                    ObjectAssert objectAssert2 = Assertions.assertThat((Object)it);
                    Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(it)");
                    objectAssert = consulRpcLimitReachedTest.isFrom(consulRpcLimitReachedTest.isOk((ObjectAssert<Response>)objectAssert2), BaseEnvoyTest.Companion.getEchoContainer());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return objectAssert;
            }
        });
    }

    private final void registerEchoInOtherAgentAfter(Duration time) {
        new Thread(() -> ConsulRpcLimitReachedTest.registerEchoInOtherAgentAfter$lambda-0(time)).start();
    }

    private final void rpcLimitReached() {
        EnvoyControlTestConfiguration.Companion.untilAsserted$default(EnvoyControlTestConfiguration.Companion, null, new Function0<AbstractBooleanAssert<?>>(this){
            final /* synthetic */ ConsulRpcLimitReachedTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                boolean limitReached = ConsulRpcLimitReachedTest.access$burstRpcLimit(this.this$0, BaseEnvoyTest.Companion.getLowRpcConsulClient().getOperations());
                return Assertions.assertThat((boolean)limitReached).isEqualTo(true);
            }
        }, 1, null);
    }

    private final boolean burstRpcLimit(ConsulOperations consulOperations) {
        boolean limitReached = false;
        int n = 5;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            try {
                consulOperations.anyRpcOperation();
            }
            catch (OperationException e) {
                limitReached = true;
            }
        }
        return limitReached;
    }

    private static final void registerEchoInOtherAgentAfter$lambda-0(Duration $time) {
        Intrinsics.checkNotNullParameter((Object)$time, (String)"$time");
        Thread.sleep($time.toMillis());
        BaseEnvoyTest.Companion.registerService$default(BaseEnvoyTest.Companion, null, "echo", null, 0, null, false, null, 125, null);
    }

    @JvmStatic
    @BeforeAll
    public static final void setup() {
        Companion.setup();
    }

    public static final /* synthetic */ void access$rpcLimitReached(ConsulRpcLimitReachedTest $this) {
        $this.rpcLimitReached();
    }

    public static final /* synthetic */ boolean access$burstRpcLimit(ConsulRpcLimitReachedTest $this, ConsulOperations consulOperations) {
        return $this.burstRpcLimit(consulOperations);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulRpcLimitReachedTest$Companion;", "", "()V", "setup", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @BeforeAll
        public final void setup() {
            EnvoyControlTestConfiguration.Companion.setup$default(EnvoyControlTestConfiguration.Companion, null, null, null, setup.1.INSTANCE, null, 0, 0, Toxiproxy.Companion.getExternalEnvoyControl1GrpcPort(), null, null, null, false, 3959, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

