/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.LocalReplyMappingTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest;", "", "()V", "should map no healthy upstream to different json format and rewrite status code to 510 when requesting api path", "", "should map no healthy upstream to different json format and rewrite status code to 522", "should return 503 with body in json format", "ApiResponse", "Companion", "Destination", "envoy-control-tests"})
public final class LocalReplyMappingTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String prefix = "envoy-control.envoy.snapshot";
    @NotNull
    private static final String localReplyPrefix = "envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;

    @Test
    public final void should return 503 with body in json format() {
        ConsulOperations.registerService$default(consul.getServer().getOperations(), service, null, "service-1", false, null, null, 58, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, should return 503 with body in json format.1.INSTANCE, 3, null);
    }

    @Test
    public final void should map no healthy upstream to different json format and rewrite status code to 522() {
        AwaitAssertionsKt.untilAsserted$default(null, null, should map no healthy upstream to different json format and rewrite status code to 522.1.INSTANCE, 3, null);
    }

    @Test
    public final void should map no healthy upstream to different json format and rewrite status code to 510 when requesting api path() {
        ApiResponse expectedApiResponse = new ApiResponse("/api", "", "NC", new Destination(null, "/api", "service-2"));
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractIntegerAssert<?>>(expectedApiResponse){
            final /* synthetic */ ApiResponse $expectedApiResponse;
            {
                this.$expectedApiResponse = $expectedApiResponse;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final AbstractIntegerAssert<?> invoke() {
                void $this$readValue$iv;
                String string;
                Response response2 = EgressOperations.callService$default(LocalReplyMappingTest.envoy.getEgressOperations(), "service-2", null, "/api", null, null, 26, null);
                ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper();
                ResponseBody responseBody = response2.body();
                if (responseBody == null) {
                    string = "";
                } else {
                    string = responseBody.string();
                    if (string == null) {
                        string = "";
                    }
                }
                String content$iv = string;
                boolean $i$f$readValue = false;
                String string2 = content$iv;
                void var7_6 = $this$readValue$iv;
                boolean $i$f$jacksonTypeRef = false;
                TypeReference typeReference = (TypeReference)new TypeReference<ApiResponse>(){};
                ApiResponse apiResponse = (ApiResponse)var7_6.readValue(string2, typeReference);
                Assertions.assertThat((Object)apiResponse).isEqualTo((Object)this.$expectedApiResponse);
                return Assertions.assertThat((int)response2.code()).isEqualTo(510);
            }
        }, 3, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.metadata-key", (Object)"tag"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[0].header-matcher.name", (Object)":path"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[0].header-matcher.exactMatch", (Object)"/api"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[0].status-code-to-return", (Object)510), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[0].response-format.json-format", (Object)"{\n                    \"destination\":{\n                        \"serviceName\":\"%REQ(:authority)%\",\n                        \"serviceTag\":\"%REQ(x-service-tag)%\",\n                        \"path\":\"%REQ(:path)%\"\n                    },\n                    \"responseFlags\":\"%RESPONSE_FLAGS%\",\n                    \"body\":\"%LOCAL_REPLY_BODY%\",\n                    \"path\":\"%REQ(:path)%\"\n                }"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[1].response-flag-matcher", (Object)CollectionsKt.listOf((Object)"NC")), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[1].status-code-to-return", (Object)522), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[1].body-to-return", (Object)"my-custom no route body"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.matchers[1].response-format.text-format", (Object)"Request to service: %REQ(:authority)% responseFlags:%RESPONSE_FLAGS% body: %LOCAL_REPLY_BODY%"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.response-format.content-type", (Object)"application/envoy+json"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.dynamic-listeners.local-reply-mapper.response-format.json-format", (Object)"{\n                    \"destination\":\"service-name: %REQ(:authority)%, service-tag: %REQ(x-service-tag)%\",\n                    \"responseFlags\":\"%RESPONSE_FLAGS%\",\n                    \"body\":\"%LOCAL_REPLY_BODY%\"\n                }")};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])pairArray));
        service = new EchoServiceExtension();
        envoy = new EnvoyExtension(envoyControl, service, null, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "localReplyPrefix", "", "prefix", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001a"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest$ApiResponse;", "", "path", "", "body", "responseFlags", "destination", "Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest$Destination;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest$Destination;)V", "getBody", "()Ljava/lang/String;", "getDestination", "()Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest$Destination;", "getPath", "getResponseFlags", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "envoy-control-tests"})
    private static final class ApiResponse {
        @NotNull
        private final String path;
        @NotNull
        private final String body;
        @NotNull
        private final String responseFlags;
        @NotNull
        private final Destination destination;

        public ApiResponse(@NotNull String path, @NotNull String body, @NotNull String responseFlags, @NotNull Destination destination) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)responseFlags, (String)"responseFlags");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.path = path;
            this.body = body;
            this.responseFlags = responseFlags;
            this.destination = destination;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final String getResponseFlags() {
            return this.responseFlags;
        }

        @NotNull
        public final Destination getDestination() {
            return this.destination;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.body;
        }

        @NotNull
        public final String component3() {
            return this.responseFlags;
        }

        @NotNull
        public final Destination component4() {
            return this.destination;
        }

        @NotNull
        public final ApiResponse copy(@NotNull String path, @NotNull String body, @NotNull String responseFlags, @NotNull Destination destination) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)responseFlags, (String)"responseFlags");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return new ApiResponse(path, body, responseFlags, destination);
        }

        public static /* synthetic */ ApiResponse copy$default(ApiResponse apiResponse, String string, String string2, String string3, Destination destination, int n, Object object) {
            if ((n & 1) != 0) {
                string = apiResponse.path;
            }
            if ((n & 2) != 0) {
                string2 = apiResponse.body;
            }
            if ((n & 4) != 0) {
                string3 = apiResponse.responseFlags;
            }
            if ((n & 8) != 0) {
                destination = apiResponse.destination;
            }
            return apiResponse.copy(string, string2, string3, destination);
        }

        @NotNull
        public String toString() {
            return "ApiResponse(path=" + this.path + ", body=" + this.body + ", responseFlags=" + this.responseFlags + ", destination=" + this.destination + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + this.responseFlags.hashCode();
            result = result * 31 + this.destination.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApiResponse)) {
                return false;
            }
            ApiResponse apiResponse = (ApiResponse)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)apiResponse.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)apiResponse.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.responseFlags, (Object)apiResponse.responseFlags)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.destination, (Object)apiResponse.destination);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/LocalReplyMappingTest$Destination;", "", "serviceTag", "", "path", "serviceName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getServiceName", "getServiceTag", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "envoy-control-tests"})
    private static final class Destination {
        @Nullable
        private final String serviceTag;
        @NotNull
        private final String path;
        @NotNull
        private final String serviceName;

        public Destination(@Nullable String serviceTag, @NotNull String path, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            this.serviceTag = serviceTag;
            this.path = path;
            this.serviceName = serviceName;
        }

        @Nullable
        public final String getServiceTag() {
            return this.serviceTag;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getServiceName() {
            return this.serviceName;
        }

        @Nullable
        public final String component1() {
            return this.serviceTag;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final String component3() {
            return this.serviceName;
        }

        @NotNull
        public final Destination copy(@Nullable String serviceTag, @NotNull String path, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            return new Destination(serviceTag, path, serviceName);
        }

        public static /* synthetic */ Destination copy$default(Destination destination, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = destination.serviceTag;
            }
            if ((n & 2) != 0) {
                string2 = destination.path;
            }
            if ((n & 4) != 0) {
                string3 = destination.serviceName;
            }
            return destination.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Destination(serviceTag=" + this.serviceTag + ", path=" + this.path + ", serviceName=" + this.serviceName + ")";
        }

        public int hashCode() {
            int result = this.serviceTag == null ? 0 : this.serviceTag.hashCode();
            result = result * 31 + this.path.hashCode();
            result = result * 31 + this.serviceName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Destination)) {
                return false;
            }
            Destination destination = (Destination)other;
            if (!Intrinsics.areEqual((Object)this.serviceTag, (Object)destination.serviceTag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)destination.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.serviceName, (Object)destination.serviceName);
        }
    }
}

