/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.RoutingPolicyTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.services.ServiceInstance;
import pl.allegro.tech.servicemesh.envoycontrol.services.ServiceInstances;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\rH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0007J\b\u0010\u0011\u001a\u00020\rH\u0007J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RoutingPolicyTest;", "", "()V", "callEchoTenTimes", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "assertNoErrors", "", "tag", "", "callStats", "should change routing when instance with prefered tag appears", "", "should change routing when instance with prefered tag disappers", "should consider client side service-tag", "should filter service instances according to tag preference", "should not filter service instances if autoServiceTag is false", "waitForEcConsulStateSynchronized", "expectedInstancesIds", "", "waitForEndpointReady", "serviceName", "serviceInstance", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "waitForEndpointRemoved", "Companion", "envoy-control-tests"})
public final class RoutingPolicyTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension loremEchoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension ipsumEchoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension otherEchoService;
    @NotNull
    private static String autoServiceTagEnabledSettings;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension autoServiceTagEnabledEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension autoServiceTagDisabledEnvoy;

    @Test
    public final void should filter service instances according to tag preference() {
        Object[] objectArray = new String[3];
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = ipsumEchoService;
        Object[] objectArray2 = new String[]{"ipsum", "other"};
        List list = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[0] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = loremEchoService;
        list = CollectionsKt.listOf((Object)"lorem");
        objectArray[1] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = otherEchoService;
        list = CollectionsKt.emptyList();
        objectArray[2] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats stats2 = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, 6, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(loremEchoService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(otherEchoService)).isEqualTo(0);
    }

    @Test
    public final void should not filter service instances if autoServiceTag is false() {
        Object[] objectArray = new String[3];
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = ipsumEchoService;
        Object[] objectArray2 = new String[]{"ipsum", "other"};
        List list = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[0] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = loremEchoService;
        list = CollectionsKt.listOf((Object)"lorem");
        objectArray[1] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = otherEchoService;
        list = CollectionsKt.emptyList();
        objectArray[2] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats stats2 = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, 6, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats2.hits(loremEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats2.hits(otherEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
    }

    @Test
    public final void should change routing when instance with prefered tag appears() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = otherEchoService;
        List list = CollectionsKt.emptyList();
        String otherEchoId = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object)otherEchoId));
        this.waitForEndpointReady("echo", otherEchoService, autoServiceTagDisabledEnvoy);
        CallStats statsAutoServiceTagAfterOther = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, 4, null);
        CallStats statsNoAutoServiceTagAfterOther = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, 6, null);
        Object[] stats2 = statsAutoServiceTagAfterOther;
        boolean bl = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.getFailedHits()).isEqualTo(10);
        stats2 = statsNoAutoServiceTagAfterOther;
        boolean $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$72 = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(otherEchoService)).isEqualTo(10);
        stats2 = consul.getServer().getOperations();
        EchoServiceExtension $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$72 = loremEchoService;
        List list2 = CollectionsKt.listOf((Object)"lorem");
        String loremEchoId = ConsulOperations.registerService$default((ConsulOperations)stats2, $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$72, null, "echo", false, list2, null, 42, null);
        stats2 = new String[]{otherEchoId, loremEchoId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])stats2));
        this.waitForEndpointReady("echo", loremEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointReady("echo", loremEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsAutoServiceTagAfterLorem = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, 6, null);
        CallStats statsNoAutoServiceTagAfterLorem = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, 6, null);
        Object[] stats3 = statsAutoServiceTagAfterLorem;
        boolean bl2 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(loremEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(otherEchoService)).isEqualTo(0);
        stats3 = statsNoAutoServiceTagAfterLorem;
        boolean $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$82 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(loremEchoService)).isEqualTo(5);
        Assertions.assertThat((int)stats3.hits(otherEchoService)).isEqualTo(5);
        stats3 = consul.getServer().getOperations();
        EchoServiceExtension $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$82 = ipsumEchoService;
        Object[] objectArray = new String[]{"noise", "ipsum"};
        List list3 = CollectionsKt.listOf((Object[])objectArray);
        String ipsumEchoId = ConsulOperations.registerService$default((ConsulOperations)stats3, $i$a$-let-RoutingPolicyTest$should change routing when instance with prefered tag appears$82, null, "echo", false, list3, null, 42, null);
        stats3 = new String[]{otherEchoId, loremEchoId, ipsumEchoId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])stats3));
        this.waitForEndpointReady("echo", ipsumEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointReady("echo", ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsAutoServiceTagAfterIpsum = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, 6, null);
        CallStats statsNoAutoServiceTagAfterIpsum = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, 6, null);
        CallStats stats4 = statsAutoServiceTagAfterIpsum;
        boolean bl3 = false;
        Assertions.assertThat((int)stats4.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats4.hits(ipsumEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats4.hits(loremEchoService)).isEqualTo(0);
        Assertions.assertThat((int)stats4.hits(otherEchoService)).isEqualTo(0);
        stats4 = statsNoAutoServiceTagAfterIpsum;
        boolean bl4 = false;
        Assertions.assertThat((int)stats4.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats4.hits(ipsumEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats4.hits(loremEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)stats4.hits(otherEchoService)).isBetween(Integer.valueOf(3), Integer.valueOf(4));
    }

    @Test
    public final void should change routing when instance with prefered tag disappers() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        Object[] objectArray = ipsumEchoService;
        Object object = new String[]{"ipsum", "other"};
        Object object2 = CollectionsKt.listOf((Object[])object);
        String ipsumId = ConsulOperations.registerService$default(consulOperations, (ServiceExtension)objectArray, null, "echo", false, (List)object2, null, 42, null);
        objectArray = consul.getServer().getOperations();
        object2 = otherEchoService;
        object = CollectionsKt.listOf((Object)"other");
        String otherId = ConsulOperations.registerService$default((ConsulOperations)objectArray, (ServiceExtension)object2, null, "echo", false, (List)object, null, 42, null);
        objectArray = new String[]{ipsumId, otherId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", otherEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointReady("echo", ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsNoAutoServiceTag = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, 6, null);
        CallStats statsAutoServiceTag = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, 6, null);
        CallStats stats2 = statsNoAutoServiceTag;
        boolean bl = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumEchoService)).isEqualTo(5);
        Assertions.assertThat((int)stats2.hits(otherEchoService)).isEqualTo(5);
        stats2 = statsAutoServiceTag;
        boolean bl2 = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(otherEchoService)).isEqualTo(0);
        consul.getServer().getOperations().deregisterService(ipsumId);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object)otherId));
        this.waitForEndpointRemoved("echo", ipsumEchoService, autoServiceTagDisabledEnvoy);
        this.waitForEndpointRemoved("echo", ipsumEchoService, autoServiceTagEnabledEnvoy);
        CallStats statsNoAutoServiceTagAfterNoIpsum = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, null, 6, null);
        CallStats statsAutoServiceTagAfterNoIpsum = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, null, 4, null);
        CallStats stats3 = statsNoAutoServiceTagAfterNoIpsum;
        boolean bl3 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.hits(otherEchoService)).isEqualTo(10);
        stats3 = statsAutoServiceTagAfterNoIpsum;
        boolean bl4 = false;
        Assertions.assertThat((int)stats3.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats3.getFailedHits()).isEqualTo(10);
    }

    @Test
    public final void should consider client side service-tag() {
        EchoServiceExtension ipsumBetaEchoService = ipsumEchoService;
        EchoServiceExtension ipsumAlphaEchoService = otherEchoService;
        EchoServiceExtension loremBetaEchoService = loremEchoService;
        ConsulOperations consulOperations = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"ipsum", "beta"};
        Object object = CollectionsKt.listOf((Object[])objectArray);
        String ipsumBetaId = ConsulOperations.registerService$default(consulOperations, ipsumBetaEchoService, null, "echo", false, (List)object, null, 42, null);
        object = consul.getServer().getOperations();
        Object object2 = new String[]{"lorem", "beta"};
        objectArray = CollectionsKt.listOf((Object[])object2);
        String loremBetaId = ConsulOperations.registerService$default((ConsulOperations)object, loremBetaEchoService, null, "echo", false, (List)objectArray, null, 42, null);
        objectArray = consul.getServer().getOperations();
        Object[] objectArray2 = new String[]{"ipsum", "alpha"};
        object2 = CollectionsKt.listOf((Object[])objectArray2);
        String ipsumAlphaId = ConsulOperations.registerService$default((ConsulOperations)objectArray, ipsumAlphaEchoService, null, "echo", false, (List)object2, null, 42, null);
        objectArray = new String[]{ipsumBetaId, ipsumAlphaId, loremBetaId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", ipsumAlphaEchoService, autoServiceTagEnabledEnvoy);
        this.waitForEndpointReady("echo", ipsumAlphaEchoService, autoServiceTagDisabledEnvoy);
        CallStats statsAutoServiceTag = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagEnabledEnvoy, false, "beta", 2, null);
        CallStats statsNoAutoServiceTag = RoutingPolicyTest.callEchoTenTimes$default(this, autoServiceTagDisabledEnvoy, false, "beta", 2, null);
        CallStats stats2 = statsAutoServiceTag;
        boolean bl = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumBetaEchoService)).isEqualTo(10);
        stats2 = statsNoAutoServiceTag;
        boolean bl2 = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumBetaEchoService)).isEqualTo(5);
        Assertions.assertThat((int)stats2.hits(loremBetaEchoService)).isEqualTo(5);
    }

    private final void waitForEcConsulStateSynchronized(Collection<String> expectedInstancesIds) {
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, (Function0)new Function0<IterableAssert<String>>(expectedInstancesIds){
            final /* synthetic */ Collection<String> $expectedInstancesIds;
            {
                this.$expectedInstancesIds = $expectedInstancesIds;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final IterableAssert<String> invoke() {
                void $this$mapTo$iv$iv;
                ServiceInstances serviceInstances = RoutingPolicyTest.envoyControl.getApp().getState().get("echo");
                Set<E> set = serviceInstances == null ? null : serviceInstances.getInstances();
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set echoInstances = set;
                Iterable $this$map$iv = echoInstances;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ServiceInstance serviceInstance = (ServiceInstance)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getId());
                }
                Object[] objectArray = new Object[]{this.$expectedInstancesIds, echoInstances};
                return (IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv))).withFailMessage("EC instances state of 'echo' service not consistent with consul. Expected instances: %s, Found: %s", objectArray)).isEqualTo((Object)CollectionsKt.toSet((Iterable)this.$expectedInstancesIds));
            }
        }, 1, null);
    }

    private final void waitForEndpointReady(String serviceName, EchoServiceExtension serviceInstance, EnvoyExtension envoy) {
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractBooleanAssert<?>>(envoy, serviceName, serviceInstance){
            final /* synthetic */ EnvoyExtension $envoy;
            final /* synthetic */ String $serviceName;
            final /* synthetic */ EchoServiceExtension $serviceInstance;
            {
                this.$envoy = $envoy;
                this.$serviceName = $serviceName;
                this.$serviceInstance = $serviceInstance;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.$envoy.getContainer().admin().isEndpointHealthy(this.$serviceName, this.$serviceInstance.container().ipAddress())).withFailMessage(() -> waitForEndpointReady.1.invoke$lambda-0(this.$serviceName, this.$serviceInstance, this.$envoy))).isTrue();
            }

            private static final String invoke$lambda-0(String $serviceName, EchoServiceExtension $serviceInstance, EnvoyExtension $envoy) {
                Intrinsics.checkNotNullParameter((Object)$serviceName, (String)"$serviceName");
                Intrinsics.checkNotNullParameter((Object)$serviceInstance, (String)"$serviceInstance");
                Intrinsics.checkNotNullParameter((Object)$envoy, (String)"$envoy");
                return "Expected to see healthy endpoint of cluster '" + $serviceName + "' with address '" + $serviceInstance.container().address() + "' in envoy " + $serviceInstance.container().address() + "/clusters, but it's not present. Found following endpoints: " + $envoy.getContainer().admin().endpointsAddress($serviceName);
            }
        }, 1, null);
    }

    private final void waitForEndpointRemoved(String serviceName, EchoServiceExtension serviceInstance, EnvoyExtension envoy) {
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(5)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractBooleanAssert<?>>(envoy, serviceName, serviceInstance){
            final /* synthetic */ EnvoyExtension $envoy;
            final /* synthetic */ String $serviceName;
            final /* synthetic */ EchoServiceExtension $serviceInstance;
            {
                this.$envoy = $envoy;
                this.$serviceName = $serviceName;
                this.$serviceInstance = $serviceInstance;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.$envoy.getContainer().admin().isEndpointHealthy(this.$serviceName, this.$serviceInstance.container().ipAddress())).withFailMessage(() -> waitForEndpointRemoved.1.invoke$lambda-0(this.$serviceName, this.$serviceInstance, this.$envoy))).isFalse();
            }

            private static final String invoke$lambda-0(String $serviceName, EchoServiceExtension $serviceInstance, EnvoyExtension $envoy) {
                Intrinsics.checkNotNullParameter((Object)$serviceName, (String)"$serviceName");
                Intrinsics.checkNotNullParameter((Object)$serviceInstance, (String)"$serviceInstance");
                Intrinsics.checkNotNullParameter((Object)$envoy, (String)"$envoy");
                return "Expected to not see endpoint of cluster '" + $serviceName + "' with address '" + $serviceInstance.container().address() + "' in envoy " + $serviceInstance.container().address() + "/clusters, but it's still present. Found following endpoints: " + $envoy.getContainer().admin().endpointsAddress($serviceName);
            }
        }, 1, null);
    }

    private final CallStats callStats() {
        Object[] objectArray = new EchoServiceExtension[]{ipsumEchoService, loremEchoService, otherEchoService};
        return new CallStats(CollectionsKt.listOf((Object[])objectArray));
    }

    private final CallStats callEchoTenTimes(EnvoyExtension envoy, boolean assertNoErrors, String tag) {
        Map map;
        CallStats stats2 = this.callStats();
        EgressOperations egressOperations = envoy.getEgressOperations();
        String string = tag;
        if (string == null) {
            map = null;
        } else {
            String it = string;
            boolean bl = false;
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag", (Object)it));
        }
        Map map2 = map;
        if (map == null) {
            map2 = MapsKt.emptyMap();
        }
        Map map3 = map2;
        EgressOperations.callServiceRepeatedly$default(egressOperations, "echo", stats2, 0, 10, null, map3, null, assertNoErrors, 84, null);
        return stats2;
    }

    static /* synthetic */ CallStats callEchoTenTimes$default(RoutingPolicyTest routingPolicyTest, EnvoyExtension envoyExtension, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return routingPolicyTest.callEchoTenTimes(envoyExtension, bl, string);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.metadata-key", (Object)"tag"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.auto-service-tag-enabled", (Object)true)};
        properties = MapsKt.mapOf((Pair[])pairArray);
        consul = new ConsulExtension();
        envoyControl = new EnvoyControlExtension(consul, properties);
        loremEchoService = new EchoServiceExtension();
        ipsumEchoService = new EchoServiceExtension();
        otherEchoService = new EchoServiceExtension();
        autoServiceTagEnabledSettings = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        routingPolicy:\n          autoServiceTag: true\n          serviceTagPreference: [\"ipsum\", \"lorem\"]\n        dependencies:\n          - service: \"echo\" ";
        autoServiceTagEnabledEnvoy = new EnvoyExtension(envoyControl, null, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getRandomConfigFile(), null, null, autoServiceTagEnabledSettings, null, null, null, 59, null), 2, null);
        autoServiceTagDisabledEnvoy = new EnvoyExtension(envoyControl, null, null, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RoutingPolicyTest$Companion;", "", "()V", "autoServiceTagDisabledEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "autoServiceTagEnabledEnvoy", "autoServiceTagEnabledSettings", "", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "ipsumEchoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "loremEchoService", "otherEchoService", "properties", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

