/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.SnapshotDebugResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.debug.Versions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017J\b\u0010\u000f\u001a\u00020\rH\u0017J\b\u0010\u0010\u001a\u00020\rH\u0017J\b\u0010\u0011\u001a\u00020\rH\u0017\u00a8\u0006\u0012"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/SnapshotDebugTest;", "", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "missingNodeJson", "", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "should inform about missing snapshot when given node does not exist", "", "should return global snapshot debug info from ads", "should return global snapshot debug info from xds", "should return snapshot debug info containing snapshot contents", "should return snapshot debug info containing snapshot versions", "envoy-control-tests"})
public interface SnapshotDebugTest {
    @Test
    public void should return snapshot debug info containing snapshot versions();

    @Test
    public void should return snapshot debug info containing snapshot contents();

    @NotNull
    public String missingNodeJson();

    @Test
    public void should inform about missing snapshot when given node does not exist();

    @Test
    public void should return global snapshot debug info from xds();

    @Test
    public void should return global snapshot debug info from ads();

    @NotNull
    public ConsulExtension consul();

    @NotNull
    public EnvoyControlExtension envoyControl();

    @NotNull
    public EnvoyExtension envoy();

    @NotNull
    public EchoServiceExtension service();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void should return snapshot debug info containing snapshot versions(@NotNull SnapshotDebugTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ConsulOperations.registerService$default(this_.consul().getServer().getOperations(), this_.service(), null, "echo", false, null, null, 58, null);
            String nodeMetadata = this_.envoy().getContainer().admin().nodeInfo();
            AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this_, nodeMetadata){
                final /* synthetic */ SnapshotDebugTest this$0;
                final /* synthetic */ String $nodeMetadata;
                {
                    this.this$0 = $receiver;
                    this.$nodeMetadata = $nodeMetadata;
                    super(0);
                }

                public final AbstractStringAssert<?> invoke() {
                    SnapshotDebugResponse snapshot = this.this$0.envoyControl().getApp().getSnapshot(this.$nodeMetadata);
                    String edsVersion = this.this$0.envoy().getContainer().admin().statValue("cluster.echo.version");
                    String cdsVersion = this.this$0.envoy().getContainer().admin().statValue("cluster_manager.cds.version");
                    String rdsVersion = this.this$0.envoy().getContainer().admin().statValue("http.egress_http.rds.default_routes.version");
                    String ldsVersion = this.this$0.envoy().getContainer().admin().statValue("listener_manager.lds.version");
                    Versions versions = snapshot.getVersions();
                    Intrinsics.checkNotNull((Object)versions);
                    Assertions.assertThat((String)versions.getClusters().getMetric()).isEqualTo(cdsVersion);
                    Assertions.assertThat((String)snapshot.getVersions().getEndpoints().getMetric()).isEqualTo(edsVersion);
                    Assertions.assertThat((String)snapshot.getVersions().getRoutes().getMetric()).isEqualTo(rdsVersion);
                    return Assertions.assertThat((String)snapshot.getVersions().getListeners().getMetric()).isEqualTo(ldsVersion);
                }
            }, 3, null);
        }

        @Test
        public static void should return snapshot debug info containing snapshot contents(@NotNull SnapshotDebugTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ConsulOperations.registerService$default(this_.consul().getServer().getOperations(), this_.service(), null, "echo", false, null, null, 58, null);
            String nodeMetadata = this_.envoy().getContainer().admin().nodeInfo();
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<IterableAssert<JsonNode>>(this_, nodeMetadata){
                final /* synthetic */ SnapshotDebugTest this$0;
                final /* synthetic */ String $nodeMetadata;
                {
                    this.this$0 = $receiver;
                    this.$nodeMetadata = $nodeMetadata;
                    super(0);
                }

                public final IterableAssert<JsonNode> invoke() {
                    SnapshotDebugResponse snapshot = this.this$0.envoyControl().getApp().getSnapshot(this.$nodeMetadata);
                    ObjectNode objectNode = snapshot.getSnapshot();
                    Intrinsics.checkNotNull((Object)objectNode);
                    Assertions.assertThat((Iterable)((Iterable)objectNode.get("clusters"))).isNotEmpty();
                    Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("routes"))).isNotEmpty();
                    Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("endpoints"))).isNotEmpty();
                    return (IterableAssert)Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("listeners"))).isNotEmpty();
                }
            }, 3, null);
        }

        @NotNull
        public static String missingNodeJson(@NotNull SnapshotDebugTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return ((Object)StringsKt.trim((CharSequence)"{\n          \"metadata\": {\n            \"service_name\": \"service-mesh-service-first\",\n            \"identity\": \"\",\n            \"service_version\": \"0.1.16-SKYHELIX-839-eds-version-metric-SNAPSHOT\",\n            \"proxy_settings\": {\n              \"incoming\": {\n                \"endpoints\": null,\n                \"healthCheck\": null,\n                \"roles\": null,\n                \"timeoutPolicy\": null\n              },\n              \"outgoing\": {\n                \"dependencies\": [\n                  {\n                    \"handleInternalRedirect\": null,\n                    \"timeoutPolicy\": null,\n                    \"endpoints\": [],\n                    \"domain\": null,\n                    \"service\": \"*\"\n                  }\n                ]\n              }\n            },\n            \"ads\": true\n          },\n          \"locality\": {\n            \"zone\": \"dev-dc4\"\n          }\n        }\n    ")).toString();
        }

        @Test
        public static void should inform about missing snapshot when given node does not exist(@NotNull SnapshotDebugTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            SnapshotDebugResponse snapshot = this_.envoyControl().getApp().getSnapshot(this_.missingNodeJson());
            Assertions.assertThat((boolean)snapshot.getFound()).isFalse();
        }

        @Test
        public static void should return global snapshot debug info from xds(@NotNull SnapshotDebugTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this_){
                final /* synthetic */ SnapshotDebugTest this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final AbstractStringAssert<?> invoke() {
                    SnapshotDebugResponse snapshot = this.this$0.envoyControl().getApp().getGlobalSnapshot(true);
                    ObjectNode objectNode = snapshot.getSnapshot();
                    Intrinsics.checkNotNull((Object)objectNode);
                    Assertions.assertThat((Iterable)((Iterable)objectNode.get("clusters"))).isNotEmpty();
                    Assertions.assertThat((Iterable)((Iterable)snapshot.getSnapshot().get("endpoints"))).isNotEmpty();
                    CharSequence[] charSequenceArray = snapshot.getSnapshot().get("clusters");
                    Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"snapshot.snapshot[\"clusters\"]");
                    AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)((JsonNode)CollectionsKt.first((Iterable)((Iterable)charSequenceArray))).get("edsClusterConfig").get("edsConfig").toString());
                    charSequenceArray = new CharSequence[]{"envoy-control-xds"};
                    return (AbstractStringAssert)abstractStringAssert.contains(charSequenceArray);
                }
            }, 3, null);
        }

        @Test
        public static void should return global snapshot debug info from ads(@NotNull SnapshotDebugTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractStringAssert<?>>(this_){
                final /* synthetic */ SnapshotDebugTest this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final AbstractStringAssert<?> invoke() {
                    SnapshotDebugResponse snapshotXdsNull = this.this$0.envoyControl().getApp().getGlobalSnapshot(null);
                    SnapshotDebugResponse snapshotXdsFalse = this.this$0.envoyControl().getApp().getGlobalSnapshot(false);
                    ObjectNode objectNode = snapshotXdsNull.getSnapshot();
                    Intrinsics.checkNotNull((Object)objectNode);
                    Assertions.assertThat((Iterable)((Iterable)objectNode.get("clusters"))).isNotEmpty();
                    Assertions.assertThat((Iterable)((Iterable)snapshotXdsNull.getSnapshot().get("endpoints"))).isNotEmpty();
                    ObjectNode objectNode2 = snapshotXdsFalse.getSnapshot();
                    Intrinsics.checkNotNull((Object)objectNode2);
                    Assertions.assertThat((Iterable)((Iterable)objectNode2.get("clusters"))).isNotEmpty();
                    Assertions.assertThat((Iterable)((Iterable)snapshotXdsFalse.getSnapshot().get("endpoints"))).isNotEmpty();
                    CharSequence[] charSequenceArray = snapshotXdsNull.getSnapshot().get("clusters");
                    Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"snapshotXdsNull.snapshot[\"clusters\"]");
                    AbstractStringAssert abstractStringAssert = Assertions.assertThat((String)((JsonNode)CollectionsKt.first((Iterable)((Iterable)charSequenceArray))).get("edsClusterConfig").get("edsConfig").toString());
                    charSequenceArray = new CharSequence[]{"ads"};
                    abstractStringAssert.contains(charSequenceArray);
                    charSequenceArray = snapshotXdsFalse.getSnapshot().get("clusters");
                    Intrinsics.checkNotNullExpressionValue((Object)charSequenceArray, (String)"snapshotXdsFalse.snapshot[\"clusters\"]");
                    AbstractStringAssert abstractStringAssert2 = Assertions.assertThat((String)((JsonNode)CollectionsKt.first((Iterable)((Iterable)charSequenceArray))).get("edsClusterConfig").get("edsConfig").toString());
                    charSequenceArray = new CharSequence[]{"ads"};
                    return (AbstractStringAssert)abstractStringAssert2.contains(charSequenceArray);
                }
            }, 3, null);
        }
    }
}

