/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.envoy;

import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyAdmin;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u0018J\u001f\u0010\u001f\u001a\u00020\u00182\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010#J\u001f\u0010$\u001a\u00020\u00182\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010#J\u001f\u0010%\u001a\u00020\u00182\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "Lorg/junit/jupiter/api/extension/AfterAllCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtensionBase;", "localService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;", "config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtensionBase;Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;)V", "container", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "getContainer", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "egressOperations", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EgressOperations;", "getEgressOperations", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EgressOperations;", "ingressOperations", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/IngressOperations;", "getIngressOperations", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/IngressOperations;", "afterAll", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterEach", "beforeAll", "recordRBACLogs", "stopRecordingRBAC", "waitForAvailableEndpoints", "serviceNames", "", "", "([Ljava/lang/String;)V", "waitForNoAvailableEndpoints", "waitForReadyServices", "Companion", "envoy-control-tests"})
public final class EnvoyExtension
implements BeforeAllCallback,
AfterAllCallback,
AfterEachCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvoyControlExtensionBase envoyControl;
    @Nullable
    private final ServiceExtension<?> localService;
    @NotNull
    private final EnvoyConfig config;
    @NotNull
    private final EnvoyContainer container;
    @NotNull
    private final IngressOperations ingressOperations;
    @NotNull
    private final EgressOperations egressOperations;
    @NotNull
    private static final Lazy<Logger> logger$delegate = LoggerKt.logger((Object)Companion);

    public EnvoyExtension(@NotNull EnvoyControlExtensionBase envoyControl2, @Nullable ServiceExtension<?> localService, @NotNull EnvoyConfig config) {
        Intrinsics.checkNotNullParameter((Object)envoyControl2, (String)"envoyControl");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.envoyControl = envoyControl2;
        this.localService = localService;
        this.config = config;
        GenericContainer genericContainer = new EnvoyContainer(this.config, (Function0)new Function0<String>(this){
            final /* synthetic */ EnvoyExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                ServiceExtension serviceExtension = EnvoyExtension.access$getLocalService$p(this.this$0);
                if (serviceExtension == null) {
                    string = "127.0.0.1";
                } else {
                    T t = serviceExtension.container();
                    if (t == null) {
                        string = "127.0.0.1";
                    } else {
                        string = t.ipAddress();
                        if (string == null) {
                            string = "127.0.0.1";
                        }
                    }
                }
                return string;
            }
        }, this.envoyControl.getApp().getGrpcPort(), 0, null, null, 56, null).withNetwork(Network.SHARED);
        Intrinsics.checkNotNullExpressionValue((Object)genericContainer, (String)"EnvoyContainer(\n        \u2026thNetwork(Network.SHARED)");
        this.container = (EnvoyContainer)genericContainer;
        this.ingressOperations = new IngressOperations(this.container);
        this.egressOperations = new EgressOperations(this.container);
    }

    public /* synthetic */ EnvoyExtension(EnvoyControlExtensionBase envoyControlExtensionBase, ServiceExtension serviceExtension, EnvoyConfig envoyConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serviceExtension = null;
        }
        if ((n & 4) != 0) {
            envoyConfig = EnvoyControlTestConfigurationKt.getRandomConfigFile();
        }
        this(envoyControlExtensionBase, serviceExtension, envoyConfig);
    }

    @NotNull
    public final EnvoyContainer getContainer() {
        return this.container;
    }

    @NotNull
    public final IngressOperations getIngressOperations() {
        return this.ingressOperations;
    }

    @NotNull
    public final EgressOperations getEgressOperations() {
        return this.egressOperations;
    }

    public void beforeAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ServiceExtension<?> serviceExtension = this.localService;
        if (serviceExtension != null) {
            serviceExtension.beforeAll(context);
        }
        this.envoyControl.beforeAll(context);
        try {
            this.container.start();
        }
        catch (Exception e) {
            Companion.getLogger().error("Logs from failed container: " + this.container.getLogs());
            throw e;
        }
    }

    public void afterAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.container.stop();
    }

    public void afterEach(@Nullable ExtensionContext context) {
        this.container.admin().resetCounters();
    }

    public final void waitForReadyServices(String ... serviceNames) {
        Intrinsics.checkNotNullParameter((Object)serviceNames, (String)"serviceNames");
        String[] $this$forEach$iv = serviceNames;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String it = element$iv;
            boolean bl = false;
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(this, it){
                final /* synthetic */ EnvoyExtension this$0;
                final /* synthetic */ String $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Response response2;
                    Response it = response2 = EgressOperations.callService$default(this.this$0.getEgressOperations(), this.$it, null, null, null, null, 30, null);
                    boolean bl = false;
                    ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                    Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(it)");
                    ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                }
            }, 3, null);
        }
    }

    public final void waitForAvailableEndpoints(String ... serviceNames) {
        Intrinsics.checkNotNullParameter((Object)serviceNames, (String)"serviceNames");
        EnvoyAdmin admin = this.container.admin();
        String[] $this$forEach$iv = serviceNames;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String it = element$iv;
            boolean bl = false;
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(admin, it){
                final /* synthetic */ EnvoyAdmin $admin;
                final /* synthetic */ String $it;
                {
                    this.$admin = $admin;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Assertions.assertThat((int)this.$admin.numOfEndpoints(this.$it)).isGreaterThan(0);
                }
            }, 3, null);
        }
    }

    public final void waitForNoAvailableEndpoints(String ... serviceNames) {
        Intrinsics.checkNotNullParameter((Object)serviceNames, (String)"serviceNames");
        EnvoyAdmin admin = this.container.admin();
        String[] $this$forEach$iv = serviceNames;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String it = element$iv;
            boolean bl = false;
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(admin, it){
                final /* synthetic */ EnvoyAdmin $admin;
                final /* synthetic */ String $it;
                {
                    this.$admin = $admin;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Assertions.assertThat((int)this.$admin.numOfEndpoints(this.$it)).isEqualTo(0);
                }
            }, 3, null);
        }
    }

    public final void recordRBACLogs() {
        this.container.getLogRecorder().recordLogs((Function1<? super String, Boolean>)((Function1)recordRBACLogs.1.INSTANCE));
    }

    public final void stopRecordingRBAC() {
        this.container.getLogRecorder().stopRecording();
    }

    public static final /* synthetic */ ServiceExtension access$getLocalService$p(EnvoyExtension $this) {
        return $this.localService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

