/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.dockerfile.statement.Statement;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.ContainerUnableToObtainHostIpException;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.LogRecorder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 7*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\u0012\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0007J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010%\u001a\n '*\u0004\u0018\u00010&0&J\u0019\u0010(\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0007H\u0002J\b\u0010.\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\u0014H\u0016J\u000e\u00100\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J+\u00101\u001a\u00028\u00002\b\u00102\u001a\u0004\u0018\u00010\u00072\b\u00103\u001a\u0004\u0018\u00010\u00072\b\u00104\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "SELF", "Lorg/testcontainers/containers/GenericContainer;", "image", "Lorg/testcontainers/images/builder/ImageFromDockerfile;", "(Lorg/testcontainers/images/builder/ImageFromDockerfile;)V", "dockerImageName", "", "(Ljava/lang/String;)V", "statements", "", "Lorg/testcontainers/images/builder/dockerfile/statement/Statement;", "(Ljava/util/List;)V", "HOST_IP_SCRIPT", "HOST_IP_SCRIPT_DEST", "logRecorder", "Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/LogRecorder;", "getLogRecorder", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/LogRecorder;", "addHost", "", "host", "ip", "blockTrafficTo", "clearAllIptablesRules", "configure", "containerIsStarting", "containerInfo", "Lcom/github/dockerjava/api/command/InspectContainerResponse;", "containerName", "gatewayIp", "hostIp", "ipAddress", "notAlreadyMounted", "", "destination", "removeHost", "restart", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "runCommands", "commands", "", "([Ljava/lang/String;)V", "sendSignal", "signal", "sigcont", "sigstop", "unblockTrafficTo", "withClasspathResourceMapping", "resourcePath", "containerPath", "mode", "Lorg/testcontainers/containers/BindMode;", "(Ljava/lang/String;Ljava/lang/String;Lorg/testcontainers/containers/BindMode;)Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "Companion", "envoy-control-tests"})
public class GenericContainer<SELF extends GenericContainer<SELF>>
extends org.testcontainers.containers.GenericContainer<SELF> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogRecorder logRecorder;
    @NotNull
    private final String HOST_IP_SCRIPT;
    @NotNull
    private final String HOST_IP_SCRIPT_DEST;
    @NotNull
    public static final String allInterfaces = "0.0.0.0";

    public GenericContainer(@NotNull ImageFromDockerfile image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super((Future)image);
        this.logRecorder = new LogRecorder();
        this.HOST_IP_SCRIPT = "testcontainers/host_ip.sh";
        this.HOST_IP_SCRIPT_DEST = "/usr/local/bin/host_ip.sh";
    }

    public GenericContainer(@NotNull String dockerImageName) {
        Intrinsics.checkNotNullParameter((Object)dockerImageName, (String)"dockerImageName");
        super(dockerImageName);
        this.logRecorder = new LogRecorder();
        this.HOST_IP_SCRIPT = "testcontainers/host_ip.sh";
        this.HOST_IP_SCRIPT_DEST = "/usr/local/bin/host_ip.sh";
    }

    public GenericContainer(@NotNull List<? extends Statement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        super((Future)new ImageFromDockerfile().withDockerfileFromBuilder(arg_0 -> GenericContainer._init_$lambda-1(statements, arg_0)));
        this.logRecorder = new LogRecorder();
        this.HOST_IP_SCRIPT = "testcontainers/host_ip.sh";
        this.HOST_IP_SCRIPT_DEST = "/usr/local/bin/host_ip.sh";
    }

    @NotNull
    public final LogRecorder getLogRecorder() {
        return this.logRecorder;
    }

    protected void configure() {
        super.configure();
        this.withClasspathResourceMapping(this.HOST_IP_SCRIPT, this.HOST_IP_SCRIPT_DEST, BindMode.READ_ONLY);
    }

    @NotNull
    public SELF withClasspathResourceMapping(@Nullable String resourcePath, @Nullable String containerPath, @Nullable BindMode mode) {
        GenericContainer genericContainer;
        if (this.notAlreadyMounted(containerPath)) {
            org.testcontainers.containers.GenericContainer genericContainer2 = super.withClasspathResourceMapping(resourcePath, containerPath, mode);
            Intrinsics.checkNotNullExpressionValue((Object)genericContainer2, (String)"{\n            super.with\u2026inerPath, mode)\n        }");
            genericContainer = (GenericContainer)genericContainer2;
        } else {
            Container container2 = this.self();
            Intrinsics.checkNotNullExpressionValue((Object)container2, (String)"{\n            this.self()\n        }");
            genericContainer = (GenericContainer)container2;
        }
        return (SELF)((Object)genericContainer);
    }

    protected void containerIsStarting(@Nullable InspectContainerResponse containerInfo) {
        this.followOutput((Consumer)((Object)this.logRecorder));
    }

    public final void addHost(@NotNull String host, @NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"sh", "-c", "echo \"" + ip + "\t" + host + "\" >> /etc/hosts"};
        this.execInContainer(stringArray);
    }

    public final void removeHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String[] stringArray = new String[]{"sh", "-c", "grep -v '[[:blank:]]" + host + "$' /etc/hosts > /tmp/hosts"};
        this.execInContainer(stringArray);
        stringArray = new String[]{"sh", "-c", "cat /tmp/hosts > /etc/hosts"};
        this.execInContainer(stringArray);
    }

    public final boolean notAlreadyMounted(@Nullable String destination) {
        boolean bl;
        block3: {
            List list = this.getBinds();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"binds");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Bind it = (Bind)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVolume().getPath(), (Object)destination)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final String hostIp() {
        Object object = new String[]{this.HOST_IP_SCRIPT_DEST};
        Container.ExecResult result = this.execInContainer((String[])object);
        object = result.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.stderr");
        boolean bl = ((CharSequence)object).length() > 0;
        object = result.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.stdout");
        if (bl | ((CharSequence)object).length() == 0) {
            throw new ContainerUnableToObtainHostIpException("stderr: " + result.getStderr());
        }
        object = result.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.stdout");
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
    }

    @NotNull
    public final String ipAddress() {
        Object v = this.getContainerInfo().getNetworkSettings().getNetworks().get(((Network.NetworkImpl)this.getNetwork()).getName());
        Intrinsics.checkNotNull(v);
        String string = ((ContainerNetwork)v).getIpAddress();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"containerInfo\n          \u2026\n            .ipAddress!!");
        return string2;
    }

    @NotNull
    public final String gatewayIp() {
        Object v = this.getContainerInfo().getNetworkSettings().getNetworks().get(((Network.NetworkImpl)this.getNetwork()).getName());
        Intrinsics.checkNotNull(v);
        String string = ((ContainerNetwork)v).getGateway();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"containerInfo\n          \u2026!!\n            .gateway!!");
        return string2;
    }

    public void sigstop() {
        this.sendSignal("STOP");
    }

    public void sigcont() {
        this.sendSignal("CONT");
    }

    public final void blockTrafficTo(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"iptables -A INPUT -s " + ip + " -j DROP", "iptables -A OUTPUT -d " + ip + " -j DROP"};
        this.runCommands(stringArray);
    }

    public final void unblockTrafficTo(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"iptables -D INPUT -s " + ip + " -j DROP", "iptables -D OUTPUT -d " + ip + " -j DROP"};
        this.runCommands(stringArray);
    }

    public final void clearAllIptablesRules() {
        String[] stringArray = new String[]{"iptables -t nat -F", "iptables -t mangle -F", "iptables -F", "iptables -X"};
        this.runCommands(stringArray);
    }

    public final void runCommands(@NotNull String[] commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        String[] $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String command = element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) != null) continue;
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
    }

    public final Void restart() {
        return this.dockerClient.restartContainerCmd(this.getContainerId()).exec();
    }

    private final void sendSignal(String signal) {
        this.getDockerClient().killContainerCmd(this.getContainerId()).withSignal(signal).exec();
    }

    @NotNull
    public final String containerName() {
        String string = this.getContainerId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containerId");
        String string2 = string.substring(0, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private static final void _init_$lambda-1(List $statements, DockerfileBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)$statements, (String)"$statements");
        Iterable $this$forEach$iv = $statements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Statement it = (Statement)element$iv;
            boolean bl = false;
            builder.withStatement(it);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer$Companion;", "", "()V", "allInterfaces", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

