/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.EnvoyAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.EndpointMatch;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\u0013\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsAllowedClientTest;", "", "()V", "cleanupTest", "", "echo should allow special client with name from header to access endpoint and log it when policy log", "echo should allow special client with name from the certificate to access endpoint and log it when policy blockAndLog", "echo should allow special client with name from the certificate to access endpoint and log it when policy log", "echo should block special client with name from header over https and log request when unlistedEndpointsPolicy is blockAndLog", "echo should block special client with name from header to access endpoint and log it when policy blockAndLog", "echo2 should allow special client with name from header over https and log request when unlistedEndpointsPolicy is log", "startRecordingRBACLogs", "ingressTlsRequests", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;)Ljava/lang/Integer;", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsAllowedClientTest {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String prefix = "envoy-control.envoy.snapshot";
    @NotNull
    private static final Map<String, Object> properties;
    @NotNull
    private static final String echo3Yaml;
    @NotNull
    private static final EnvoyConfig echoConfig;
    @NotNull
    private static final EnvoyConfig echo2Config;
    @NotNull
    private static final EnvoyConfig envoy3Config;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy3;

    @Test
    public final void echo should allow special client with name from the certificate to access endpoint and log it when policy log() {
        String[] stringArray = consul.getServer().getOperations();
        Object object = echoEnvoy;
        Object object2 = CollectionsKt.listOf((Object)"mtls:enabled");
        ConsulOperations.registerServiceWithEnvoyOnIngress$default((ConsulOperations)stringArray, (EnvoyExtension)object, null, "echo", false, (List)object2, 10, null);
        stringArray = new String[]{"echo"};
        envoy3.waitForAvailableEndpoints(stringArray);
        object = envoy3.getEgressOperations();
        object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"allowed-client"));
        Response echoResponse = EgressOperations.callService$default((EgressOperations)object, "echo", (Map)object2, "/log-unlisted-clients", null, null, 24, null);
        object = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)object), service);
        object = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessAllowedWithActionLog$default((ObjectAssert)object, "https", "/log-unlisted-clients", "GET", "echo3", true, null, true, envoy3.getContainer().ipAddress(), null, 288, null);
    }

    @Test
    public final void echo should allow special client with name from the certificate to access endpoint and log it when policy blockAndLog() {
        String[] stringArray = consul.getServer().getOperations();
        EnvoyExtension envoyExtension = echoEnvoy;
        List list = CollectionsKt.listOf((Object)"mtls:enabled");
        ConsulOperations.registerServiceWithEnvoyOnIngress$default((ConsulOperations)stringArray, envoyExtension, null, "echo", false, list, 10, null);
        stringArray = new String[]{"echo"};
        envoy3.waitForAvailableEndpoints(stringArray);
        Response echoResponse = EgressOperations.callService$default(envoy3.getEgressOperations(), "echo", null, "/block-unlisted-clients", null, null, 26, null);
        envoyExtension = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)envoyExtension, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)envoyExtension), service);
        envoyExtension = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)envoyExtension, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessAllowedWithActionLog$default((ObjectAssert)envoyExtension, "https", "/block-unlisted-clients", "GET", "echo3", true, null, true, envoy3.getContainer().ipAddress(), null, 288, null);
    }

    @Test
    public final void echo should allow special client with name from header to access endpoint and log it when policy log() {
        String[] stringArray = consul.getServer().getOperations();
        EnvoyExtension envoyExtension = echoEnvoy;
        List list = CollectionsKt.listOf((Object)"mtls:enabled");
        ConsulOperations.registerServiceWithEnvoyOnIngress$default((ConsulOperations)stringArray, envoyExtension, null, "echo", false, list, 10, null);
        stringArray = new String[]{"echo"};
        envoy3.waitForAvailableEndpoints(stringArray);
        Response echoResponse = echoEnvoy.getIngressOperations().callLocalService("/log-unlisted-clients", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"echo3"))));
        envoyExtension = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)envoyExtension, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)envoyExtension), service);
        envoyExtension = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)envoyExtension, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default((ObjectAssert)envoyExtension, "http", "/log-unlisted-clients", "GET", "echo3", false, null, true, echoEnvoy.getContainer().gatewayIp(), null, 288, null);
    }

    @Test
    public final void echo should block special client with name from header to access endpoint and log it when policy blockAndLog() {
        String[] stringArray = consul.getServer().getOperations();
        EnvoyExtension envoyExtension = echoEnvoy;
        Object object = CollectionsKt.listOf((Object)"mtls:enabled");
        ConsulOperations.registerServiceWithEnvoyOnIngress$default((ConsulOperations)stringArray, envoyExtension, null, "echo", false, (List)object, 10, null);
        stringArray = new String[]{"echo"};
        envoy3.waitForAvailableEndpoints(stringArray);
        Response echoResponse = echoEnvoy.getIngressOperations().callLocalService("/block-unlisted-clients", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"echo3"))));
        envoyExtension = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)envoyExtension, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)envoyExtension);
        envoyExtension = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        object = echoEnvoy.getContainer().ingressHost();
        String string = echoEnvoy.getContainer().gatewayIp();
        Intrinsics.checkNotNullExpressionValue((Object)envoyExtension, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock((ObjectAssert<EnvoyContainer>)envoyExtension, "http", "/block-unlisted-clients", "GET", "echo3", false, (String)object, string, true);
    }

    @Test
    public final void echo2 should allow special client with name from header over https and log request when unlistedEndpointsPolicy is log() {
        Response echo2Response = echo2Envoy.getIngressOperations().callLocalServiceInsecure("/log-unlisted-endpoint", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"echo3"))), true);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echo2Response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), service);
        Assertions.assertThat((Integer)this.ingressTlsRequests(echo2Envoy.getContainer())).isOne();
        objectAssert = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echo2Envoy.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert, "https", "/log-unlisted-endpoint", "GET", "echo3 (not trusted)", false, null, true, echo2Envoy.getContainer().gatewayIp(), null, 288, null);
    }

    @Test
    public final void echo should block special client with name from header over https and log request when unlistedEndpointsPolicy is blockAndLog() {
        Response echoResponse = echoEnvoy.getIngressOperations().callLocalServiceInsecure("/block-and-log-unlisted-endpoint", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"echo3"))), true);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        Assertions.assertThat((Integer)this.ingressTlsRequests(echoEnvoy.getContainer())).isOne();
        objectAssert = Assertions.assertThat((Object)((Object)echoEnvoy.getContainer()));
        String string = echoEnvoy.getContainer().ingressHost();
        String string2 = echoEnvoy.getContainer().gatewayIp();
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echoEnvoy.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock((ObjectAssert<EnvoyContainer>)objectAssert, "https", "/block-and-log-unlisted-endpoint", "GET", "echo3 (not trusted)", false, string, string2, true);
    }

    @BeforeEach
    public final void startRecordingRBACLogs() {
        echoEnvoy.recordRBACLogs();
        echo2Envoy.recordRBACLogs();
    }

    @AfterEach
    public final void cleanupTest() {
        echoEnvoy.getContainer().admin().resetCounters();
        echoEnvoy.getContainer().getLogRecorder().stopRecording();
        echo2Envoy.getContainer().admin().resetCounters();
        echo2Envoy.getContainer().getLogRecorder().stopRecording();
    }

    private final Integer ingressTlsRequests(EnvoyContainer $this$ingressTlsRequests) {
        String string = $this$ingressTlsRequests.admin().statValue("http.ingress_https.downstream_rq_completed");
        return string == null ? null : Integer.valueOf(Integer.parseInt(string));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void it;
        EndpointMatch endpointMatch;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true);
        pairArray[1] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true);
        pairArray[2] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.status.create-virtual-cluster", (Object)true);
        Object[] objectArray = new EndpointMatch[1];
        EndpointMatch endpointMatch2 = endpointMatch = new EndpointMatch();
        int n = 0;
        Object[] objectArray2 = objectArray;
        String string = "envoy-control.envoy.snapshot.routes.status.endpoints";
        int n2 = 3;
        Pair[] pairArray2 = pairArray;
        boolean bl = false;
        it.setPath("/status/");
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = endpointMatch;
        pairArray2[n2] = TuplesKt.to((Object)string, (Object)CollectionsKt.mutableListOf((Object[])objectArray));
        pairArray[4] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.status.enabled", (Object)true);
        pairArray[5] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.clients-allowed-to-all-endpoints", (Object)CollectionsKt.listOf((Object)"echo3"));
        properties = MapsKt.mapOf((Pair[])pairArray);
        echo3Yaml = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"\n          - service: \"echo2\"";
        echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, IncomingPermissionsAllowedClientTest.Companion.proxySettings("blockAndLog"), null, null, null, 59, null);
        echo2Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, IncomingPermissionsAllowedClientTest.Companion.proxySettings("log"), null, null, null, 59, null);
        envoy3Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho3EnvoyAuthConfig(), null, null, echo3Yaml, null, null, null, 59, null);
        consul = new ConsulExtension();
        envoyControl = new EnvoyControlExtension(consul, properties);
        service = new EchoServiceExtension();
        echoEnvoy = new EnvoyExtension(envoyControl, service, echoConfig);
        echo2Envoy = new EnvoyExtension(envoyControl, service, echo2Config);
        envoy3 = new EnvoyExtension(envoyControl, null, envoy3Config, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsAllowedClientTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo2Config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echo2Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echo3Yaml", "", "echoConfig", "echoEnvoy", "envoy3", "envoy3Config", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "prefix", "properties", "", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "proxySettings", "unlistedEndpointsPolicy", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        private final String proxySettings(String unlistedEndpointsPolicy) {
            return StringsKt.trimIndent((String)("\n            node: \n              metadata: \n                proxy_settings: \n                  incoming:\n                    unlistedEndpointsPolicy: " + unlistedEndpointsPolicy + "\n                    endpoints:\n                    - path: \"/block-unlisted-clients\"\n                      clients: [\"echo\"]\n                      unlistedClientsPolicy: blockAndLog\n                    - path: \"/log-unlisted-clients\"\n                      methods: [GET]\n                      clients: [\"echo\"]\n                      unlistedClientsPolicy: log\n                  outgoing:\n                    dependencies: []\n        "));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

