/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.EnvoyAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsEmptyClientsTest;", "", "()V", "cleanupTest", "", "echo should allow clients access to 'unlisted' endpoint and log it", "echo should deny clients access to 'blocked-for-all' endpoint", "echo2 should allow clients access to 'logged-for-all' endpoint and log it", "echo2 should deny clients access to 'unlisted' endpoint", "startRecordingRBACLogs", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsEmptyClientsTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EnvoyConfig echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        unlistedEndpointsPolicy: log\n        endpoints: \n        - path: /blocked-for-all\n          clients: []", null, null, null, 59, null);
    @NotNull
    private static final EnvoyConfig echo2Config = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints: \n        - path: /logged-for-all\n          clients: []\n          unlistedClientsPolicy: log", null, null, null, 59, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echo;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echo2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy2;

    @Test
    public final void echo should deny clients access to 'blocked-for-all' endpoint() {
        Response echoResponse = IngressOperations.callLocalService$default(envoy1.getIngressOperations(), "/blocked-for-all", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        objectAssert = Assertions.assertThat((Object)((Object)envoy1.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(envoy1.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert, "http", "/blocked-for-all", "GET", "", false, envoy1.getContainer().ingressHost(), envoy1.getContainer().gatewayIp(), false, 128, null);
    }

    @Test
    public final void echo should allow clients access to 'unlisted' endpoint and log it() {
        Response echoResponse = IngressOperations.callLocalService$default(envoy1.getIngressOperations(), "/unlisted", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echoResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echoResponse)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo);
        objectAssert = Assertions.assertThat((Object)((Object)envoy1.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(envoy1.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert, "http", "/unlisted", "GET", "", null, null, null, envoy1.getContainer().gatewayIp(), null, 368, null);
    }

    @Test
    public final void echo2 should allow clients access to 'logged-for-all' endpoint and log it() {
        Response echo2Response = IngressOperations.callLocalService$default(envoy2.getIngressOperations(), "/logged-for-all", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echo2Response)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echo2);
        objectAssert = Assertions.assertThat((Object)((Object)envoy2.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(envoy2.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionLog$default(objectAssert, "http", "/logged-for-all", "GET", "", null, null, null, envoy2.getContainer().gatewayIp(), null, 368, null);
    }

    @Test
    public final void echo2 should deny clients access to 'unlisted' endpoint() {
        Response echo2Response = IngressOperations.callLocalService$default(envoy2.getIngressOperations(), "/unlisted", null, 2, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)echo2Response);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(echo2Response)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        objectAssert = Assertions.assertThat((Object)((Object)envoy2.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(envoy2.container)");
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert, "http", "/unlisted", "GET", "", false, envoy2.getContainer().ingressHost(), envoy2.getContainer().gatewayIp(), false, 128, null);
    }

    @BeforeEach
    public final void startRecordingRBACLogs() {
        Object[] objectArray = new EnvoyExtension[]{envoy1, envoy2};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnvoyExtension it = (EnvoyExtension)element$iv;
            boolean bl = false;
            it.recordRBACLogs();
        }
    }

    @AfterEach
    public final void cleanupTest() {
        Object[] objectArray = new EnvoyExtension[]{envoy1, envoy2};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnvoyExtension it = (EnvoyExtension)element$iv;
            boolean bl = false;
            it.getContainer().admin().resetCounters();
            it.getContainer().getLogRecorder().stopRecording();
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])pairArray));
        echo = new EchoServiceExtension();
        echo2 = new EchoServiceExtension();
        envoy1 = new EnvoyExtension(envoyControl, echo, echoConfig);
        envoy2 = new EnvoyExtension(envoyControl, echo2, echo2Config);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsEmptyClientsTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echo2", "echo2Config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echoConfig", "envoy1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoy2", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

