/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Response;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import pl.allegro.tech.servicemesh.envoycontrol.config.BaseEnvoyTest;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfiguration;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.containers.ToxiproxyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.SourceIpBasedAuthenticationTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0007J\b\u0010\r\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/SourceIpBasedAuthenticationTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyControlTestConfiguration;", "()V", "callEcho2", "Lokhttp3/Response;", "from", "", "callEcho2ThroughEnvoy1", "callEcho2ThroughEnvoy2Ingress", "registerEcho1WithEnvoy1OnIngress", "", "registerEcho2WithEnvoy2OnIngress", "should allow access to selected clients using ip-from-discovery based authentication over plain http", "should allow access to selected clients using ip-from-range based authentication over plain http", "Companion", "envoy-control-tests"})
public final class SourceIpBasedAuthenticationTest
extends EnvoyControlTestConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Container
    private static final ToxiproxyContainer loremContainer = (ToxiproxyContainer)new ToxiproxyContainer(1).withNetwork(BaseEnvoyTest.Companion.getNetwork());
    @Container
    private static final ToxiproxyContainer ipsumContainer = (ToxiproxyContainer)new ToxiproxyContainer(1).withNetwork(BaseEnvoyTest.Companion.getNetwork());
    @NotNull
    private static final String prefix = "envoy-control.envoy.snapshot";
    @NotNull
    private static final Function0<Map<String, Object>> properties = Companion.properties.1.INSTANCE;
    @NotNull
    private static final EnvoyConfig echo2EnvoyConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints:\n          - path: \"/secured_endpoint\"\n            clients: [\"echo\", \"lorem\"]", null, null, null, 59, null);

    @Test
    public final void should allow access to selected clients using ip-from-discovery based authentication over plain http() {
        this.registerEcho1WithEnvoy1OnIngress();
        this.registerEcho2WithEnvoy2OnIngress();
        EnvoyControlTestConfiguration.Companion.untilAsserted$default(EnvoyControlTestConfiguration.Companion, null, new Function0<AbstractIntegerAssert<?>>(this){
            final /* synthetic */ SourceIpBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractIntegerAssert<?> invoke() {
                EnvoyControlTestConfiguration.Companion.getEnvoyContainer2().admin().resetCounters();
                Response requestFromEcho1Response = SourceIpBasedAuthenticationTest.access$callEcho2ThroughEnvoy1(this.this$0);
                Response directRequestResponse = SourceIpBasedAuthenticationTest.access$callEcho2ThroughEnvoy2Ingress(this.this$0);
                String string = EnvoyControlTestConfiguration.Companion.getEnvoyContainer2().admin().statValue("http.ingress_http.rbac.denied");
                Integer plainHttpAccessDenials = string == null ? null : Integer.valueOf(Integer.parseInt(string));
                String string2 = EnvoyControlTestConfiguration.Companion.getEnvoyContainer2().admin().statValue("listener.0.0.0.0_5001.ssl.handshake");
                Integer sslHandshakes = string2 == null ? null : Integer.valueOf(Integer.parseInt(string2));
                string2 = Assertions.assertThat((Object)requestFromEcho1Response);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assertThat(requestFromEcho1Response)");
                this.this$0.isFrom(this.this$0.isOk((ObjectAssert<Response>)string2), BaseEnvoyTest.Companion.getEchoContainer2());
                string2 = Assertions.assertThat((Object)directRequestResponse);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assertThat(directRequestResponse)");
                this.this$0.isForbidden((ObjectAssert<Response>)string2);
                Assertions.assertThat((Integer)sslHandshakes).isZero();
                return Assertions.assertThat((Integer)plainHttpAccessDenials).isOne();
            }
        }, 1, null);
    }

    @Test
    public final void should allow access to selected clients using ip-from-range based authentication over plain http() {
        ToxiproxyContainer toxiproxyContainer = loremContainer;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)toxiproxyContainer), (String)"loremContainer");
        String loremToEcho2Proxy = EnvoyControlTestConfiguration.Companion.createProxyToEnvoyIngress(toxiproxyContainer, EnvoyControlTestConfiguration.Companion.getEnvoyContainer2());
        ToxiproxyContainer toxiproxyContainer2 = ipsumContainer;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)toxiproxyContainer2), (String)"ipsumContainer");
        String ipsumToEcho2Proxy = EnvoyControlTestConfiguration.Companion.createProxyToEnvoyIngress(toxiproxyContainer2, EnvoyControlTestConfiguration.Companion.getEnvoyContainer2());
        Response requestFromLoremResponse = this.callEcho2(loremToEcho2Proxy);
        Response requestFromIpsumResponse = this.callEcho2(ipsumToEcho2Proxy);
        String string = EnvoyControlTestConfiguration.Companion.getEnvoyContainer2().admin().statValue("http.ingress_http.rbac.denied");
        Integer plainHttpAccessDenials = string == null ? null : Integer.valueOf(Integer.parseInt(string));
        String string2 = EnvoyControlTestConfiguration.Companion.getEnvoyContainer2().admin().statValue("listener.0.0.0.0_5001.ssl.handshake");
        Integer sslHandshakes = string2 == null ? null : Integer.valueOf(Integer.parseInt(string2));
        string2 = Assertions.assertThat((Object)requestFromLoremResponse);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assertThat(requestFromLoremResponse)");
        this.isFrom(this.isOk((ObjectAssert<Response>)string2), BaseEnvoyTest.Companion.getEchoContainer2());
        string2 = Assertions.assertThat((Object)requestFromIpsumResponse);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assertThat(requestFromIpsumResponse)");
        this.isForbidden((ObjectAssert<Response>)string2);
        Assertions.assertThat((Integer)sslHandshakes).isZero();
        Assertions.assertThat((Integer)plainHttpAccessDenials).isOne();
    }

    private final void registerEcho1WithEnvoy1OnIngress() {
        BaseEnvoyTest.Companion.registerService$default(BaseEnvoyTest.Companion, "echo", "echo", EnvoyControlTestConfiguration.Companion.getEnvoyContainer1().ipAddress(), 5001, null, 16, null);
    }

    private final void registerEcho2WithEnvoy2OnIngress() {
        BaseEnvoyTest.Companion.registerService$default(BaseEnvoyTest.Companion, "echo2", "echo2", EnvoyControlTestConfiguration.Companion.getEnvoyContainer2().ipAddress(), 5001, null, 16, null);
    }

    private final Response callEcho2(String from) {
        return EnvoyControlTestConfiguration.Companion.call$default(EnvoyControlTestConfiguration.Companion, null, from, null, "/secured_endpoint", null, null, null, 117, null);
    }

    private final Response callEcho2ThroughEnvoy2Ingress() {
        return EnvoyControlTestConfiguration.Companion.callLocalService("/secured_endpoint", Headers.Companion.of(new String[0]), EnvoyControlTestConfiguration.Companion.getEnvoyContainer2());
    }

    private final Response callEcho2ThroughEnvoy1() {
        return EnvoyControlTestConfiguration.Companion.callService$default(EnvoyControlTestConfiguration.Companion, "echo2", null, null, "/secured_endpoint", 6, null);
    }

    @JvmStatic
    @BeforeAll
    public static final void setupTest() {
        Companion.setupTest();
    }

    public static final /* synthetic */ Function0 access$getProperties$cp() {
        return properties;
    }

    public static final /* synthetic */ Response access$callEcho2ThroughEnvoy1(SourceIpBasedAuthenticationTest $this) {
        return $this.callEcho2ThroughEnvoy1();
    }

    public static final /* synthetic */ Response access$callEcho2ThroughEnvoy2Ingress(SourceIpBasedAuthenticationTest $this) {
        return $this.callEcho2ThroughEnvoy2Ingress();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/SourceIpBasedAuthenticationTest$Companion;", "", "()V", "echo2EnvoyConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "ipsumContainer", "Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ToxiproxyContainer;", "kotlin.jvm.PlatformType", "getIpsumContainer", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/ToxiproxyContainer;", "loremContainer", "getLoremContainer", "prefix", "", "properties", "Lkotlin/Function0;", "", "setupTest", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public final ToxiproxyContainer getLoremContainer() {
            return loremContainer;
        }

        public final ToxiproxyContainer getIpsumContainer() {
            return ipsumContainer;
        }

        @JvmStatic
        @BeforeAll
        public final void setupTest() {
            EnvoyControlTestConfiguration.Companion companion = EnvoyControlTestConfiguration.Companion;
            EnvoyConfig envoyConfig = EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig();
            EnvoyConfig envoyConfig2 = echo2EnvoyConfig;
            EnvoyControlTestConfiguration.Companion.setup$default(companion, envoyConfig, envoyConfig2, null, setupTest.1.INSTANCE, null, 0, 2, null, null, null, null, false, 4020, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

