/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.reliability;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import pl.allegro.tech.servicemesh.envoycontrol.config.BaseEnvoyTest;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfiguration;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulSetup;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.GenericContainer;
import pl.allegro.tech.servicemesh.envoycontrol.reliability.ReliabilityTest;
import pl.allegro.tech.servicemesh.envoycontrol.reliability.Toxiproxy;

@Tag(value="reliability")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\bH\u0007J&\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J(\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0002J&\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ReliabilityTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyControlTestConfiguration;", "()V", "failureDuration", "Ljava/time/Duration;", "getFailureDuration", "()Ljava/time/Duration;", "assertConsulHasALeader", "", "consulOperations", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulOperations;", "assertConsulHasNoLeader", "assertReachableThroughEnvoy", "service", "", "assertReachableThroughEnvoyOnce", "assertUnreachableThroughEnvoy", "assertUnreachableThroughEnvoyOnce", "cleanup", "holdAssertionsTrue", "duration", "interval", "assertion", "Lkotlin/Function0;", "probes", "", "repeatWithSleep", "runRepeat", "intervalInMs", "Companion", "envoy-control-tests"})
public class ReliabilityTest
extends EnvoyControlTestConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration failureDuration;

    /*
     * WARNING - void declaration
     */
    public ReliabilityTest() {
        long l;
        ReliabilityTest reliabilityTest = this;
        String string = System.getProperty("RELIABILITY_FAILURE_DURATION_SECONDS");
        if (string == null) {
            l = 20L;
        } else {
            long l2;
            void it;
            String string2 = string;
            ReliabilityTest reliabilityTest2 = reliabilityTest;
            boolean bl = false;
            reliabilityTest = reliabilityTest2;
            String string3 = Strings.emptyToNull((String)it);
            l = string3 == null ? 20L : (l2 = Long.parseLong(string3));
        }
        Duration duration = Duration.ofSeconds(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(\n        Syste\u2026)\n            ?: 20\n    )");
        reliabilityTest.failureDuration = duration;
    }

    /*
     * WARNING - void declaration
     */
    @AfterEach
    public final void cleanup() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)BaseEnvoyTest.Companion.getConsulMastersInDc1(), (Iterable)BaseEnvoyTest.Companion.getConsulMastersInDc2());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConsulSetup consulSetup = (ConsulSetup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContainer());
        }
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)CollectionsKt.listOf((Object)((Object)EnvoyControlTestConfiguration.Companion.getEnvoyContainer1())));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenericContainer it = (GenericContainer)((Object)element$iv);
            boolean bl = false;
            it.sigcont();
            it.clearAllIptablesRules();
        }
    }

    public final void assertConsulHasNoLeader(@NotNull ConsulOperations consulOperations) {
        Intrinsics.checkNotNullParameter((Object)consulOperations, (String)"consulOperations");
        EnvoyControlTestConfiguration.Companion.untilAsserted$default(EnvoyControlTestConfiguration.Companion, null, (Function0)new Function0<Unit>(consulOperations){
            final /* synthetic */ ConsulOperations $consulOperations;
            {
                this.$consulOperations = $consulOperations;
                super(0);
            }

            public final void invoke() {
                Assertions.assertThat((String)this.$consulOperations.leader()).isEmpty();
            }
        }, 1, null);
    }

    public static /* synthetic */ void assertConsulHasNoLeader$default(ReliabilityTest reliabilityTest, ConsulOperations consulOperations, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertConsulHasNoLeader");
        }
        if ((n & 1) != 0) {
            consulOperations = BaseEnvoyTest.Companion.getConsulOperationsInFirstDc();
        }
        reliabilityTest.assertConsulHasNoLeader(consulOperations);
    }

    public final void assertConsulHasALeader(@NotNull ConsulOperations consulOperations) {
        Intrinsics.checkNotNullParameter((Object)consulOperations, (String)"consulOperations");
        EnvoyControlTestConfiguration.Companion.untilAsserted$default(EnvoyControlTestConfiguration.Companion, null, new Function0<AbstractStringAssert<?>>(consulOperations){
            final /* synthetic */ ConsulOperations $consulOperations;
            {
                this.$consulOperations = $consulOperations;
                super(0);
            }

            public final AbstractStringAssert<?> invoke() {
                return (AbstractStringAssert)Assertions.assertThat((String)this.$consulOperations.leader()).isNotEmpty();
            }
        }, 1, null);
    }

    public static /* synthetic */ void assertConsulHasALeader$default(ReliabilityTest reliabilityTest, ConsulOperations consulOperations, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertConsulHasALeader");
        }
        if ((n & 1) != 0) {
            consulOperations = BaseEnvoyTest.Companion.getConsulOperationsInFirstDc();
        }
        reliabilityTest.assertConsulHasALeader(consulOperations);
    }

    public final void assertReachableThroughEnvoy(@NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        EnvoyControlTestConfiguration.Companion.untilAsserted$default(EnvoyControlTestConfiguration.Companion, null, (Function0)new Function0<Unit>(this, service){
            final /* synthetic */ ReliabilityTest this$0;
            final /* synthetic */ String $service;
            {
                this.this$0 = $receiver;
                this.$service = $service;
                super(0);
            }

            public final void invoke() {
                this.this$0.assertReachableThroughEnvoyOnce(this.$service);
            }
        }, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertReachableThroughEnvoyOnce(@NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Closeable closeable = (Closeable)EnvoyControlTestConfiguration.Companion.callService$default(EnvoyControlTestConfiguration.Companion, service, null, null, null, 14, null);
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            ObjectAssert objectAssert = Assertions.assertThat((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(it)");
            ObjectAssert<Response> objectAssert2 = this.isFrom(this.isOk((ObjectAssert<Response>)objectAssert), BaseEnvoyTest.Companion.getEchoContainer());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void assertUnreachableThroughEnvoy(@NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        EnvoyControlTestConfiguration.Companion.untilAsserted$default(EnvoyControlTestConfiguration.Companion, null, (Function0)new Function0<Unit>(this, service){
            final /* synthetic */ ReliabilityTest this$0;
            final /* synthetic */ String $service;
            {
                this.this$0 = $receiver;
                this.$service = $service;
                super(0);
            }

            public final void invoke() {
                this.this$0.assertUnreachableThroughEnvoyOnce(this.$service);
            }
        }, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertUnreachableThroughEnvoyOnce(@NotNull String service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Closeable closeable = (Closeable)EnvoyControlTestConfiguration.Companion.callService$default(EnvoyControlTestConfiguration.Companion, service, null, null, null, 14, null);
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl = false;
            ObjectAssert objectAssert = Assertions.assertThat((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(it)");
            ObjectAssert<Response> objectAssert2 = this.isUnreachable((ObjectAssert<Response>)objectAssert);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void holdAssertionsTrue(@NotNull Duration duration, @NotNull Duration interval, @NotNull Function0<Unit> assertion) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter(assertion, (String)"assertion");
        long intervalInMs = interval.toMillis();
        long probes = duration.toMillis() / intervalInMs;
        this.runRepeat(probes, intervalInMs, assertion);
    }

    public static /* synthetic */ void holdAssertionsTrue$default(ReliabilityTest reliabilityTest, Duration duration, Duration duration2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: holdAssertionsTrue");
        }
        if ((n & 1) != 0) {
            duration = reliabilityTest.failureDuration;
        }
        reliabilityTest.holdAssertionsTrue(duration, duration2, (Function0<Unit>)function0);
    }

    public final void holdAssertionsTrue(@NotNull Duration duration, long probes, @NotNull Function0<Unit> assertion) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(assertion, (String)"assertion");
        long millis = duration.toMillis();
        long interval = millis / probes;
        this.runRepeat(probes, interval, assertion);
    }

    public static /* synthetic */ void holdAssertionsTrue$default(ReliabilityTest reliabilityTest, Duration duration, long l, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: holdAssertionsTrue");
        }
        if ((n & 1) != 0) {
            duration = reliabilityTest.failureDuration;
        }
        if ((n & 2) != 0) {
            l = 10L;
        }
        reliabilityTest.holdAssertionsTrue(duration, l, (Function0<Unit>)function0);
    }

    private final void runRepeat(long probes, long intervalInMs, Function0<Unit> assertion) {
        if (probes == 0L) {
            this.repeatWithSleep(1L, intervalInMs, (Function0<Unit>)((Function0)new Function0<Unit>(assertion){
                final /* synthetic */ Function0<Unit> $assertion;
                {
                    this.$assertion = $assertion;
                    super(0);
                }

                public final void invoke() {
                    this.$assertion.invoke();
                }
            }));
        } else {
            this.repeatWithSleep(probes, intervalInMs, (Function0<Unit>)((Function0)new Function0<Unit>(assertion){
                final /* synthetic */ Function0<Unit> $assertion;
                {
                    this.$assertion = $assertion;
                    super(0);
                }

                public final void invoke() {
                    this.$assertion.invoke();
                }
            }));
        }
    }

    private final void repeatWithSleep(long probes, long interval, Function0<Unit> assertion) {
        int n = (int)probes;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int it = n3 = n2++;
            boolean bl = false;
            assertion.invoke();
            if (interval <= 0L) continue;
            Thread.sleep(interval);
        }
    }

    @NotNull
    public final Duration getFailureDuration() {
        return this.failureDuration;
    }

    @JvmStatic
    @BeforeAll
    public static final void setup() {
        Companion.setup();
    }

    @JvmStatic
    @AfterAll
    public static final void after() {
        Companion.after();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004J\b\u0010\u000b\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ReliabilityTest$Companion;", "", "()V", "after", "", "cutOffConnectionBetweenECs", "makeEnvoyControl2Available", "makeEnvoyControl2Unavailable", "makeEnvoyControlAvailable", "makeEnvoyControlUnavailable", "restoreConnectionBetweenECs", "setup", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @BeforeAll
        public final void setup() {
            EnvoyControlTestConfiguration.Companion.setup$default(EnvoyControlTestConfiguration.Companion, null, null, null, setup.1.INSTANCE, null, 0, 0, Toxiproxy.Companion.getExternalEnvoyControl1GrpcPort(), null, null, null, false, 3959, null);
        }

        @JvmStatic
        @AfterAll
        public final void after() {
            EnvoyControlTestConfiguration.Companion.teardown();
            this.makeEnvoyControlAvailable();
            this.makeEnvoyControl2Available();
        }

        public final void makeEnvoyControlAvailable() {
            Toxiproxy.Companion.getEnvoyControl1Proxy().enable();
            Toxiproxy.Companion.getEnvoyControl1HttpProxy().enable();
        }

        public final void makeEnvoyControlUnavailable() {
            Toxiproxy.Companion.getEnvoyControl1Proxy().disable();
            Toxiproxy.Companion.getEnvoyControl1HttpProxy().disable();
        }

        public final void makeEnvoyControl2Available() {
            Toxiproxy.Companion.getEnvoyControl2Proxy().enable();
            Toxiproxy.Companion.getEnvoyControl2HttpProxy().enable();
        }

        public final void makeEnvoyControl2Unavailable() {
            Toxiproxy.Companion.getEnvoyControl2Proxy().disable();
            Toxiproxy.Companion.getEnvoyControl2HttpProxy().disable();
        }

        public final void cutOffConnectionBetweenECs() {
            Toxiproxy.Companion.getEnvoyControl1HttpProxy().disable();
            Toxiproxy.Companion.getEnvoyControl2HttpProxy().disable();
        }

        public final void restoreConnectionBetweenECs() {
            Toxiproxy.Companion.getEnvoyControl1HttpProxy().enable();
            Toxiproxy.Companion.getEnvoyControl2HttpProxy().enable();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

