/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.springframework.http.HttpStatus;
import pl.allegro.tech.servicemesh.envoycontrol.ChaosControllerTestKt;
import pl.allegro.tech.servicemesh.envoycontrol.chaos.api.ExperimentsListResponse;
import pl.allegro.tech.servicemesh.envoycontrol.chaos.api.NetworkDelayResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlTestApp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007J\b\u0010\u0012\u001a\u00020\fH\u0007J\b\u0010\u0013\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ChaosControllerTest;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "convertResponseToExperimentsListResponse", "Lpl/allegro/tech/servicemesh/envoycontrol/chaos/api/ExperimentsListResponse;", "response", "Lokhttp3/Response;", "convertResponseToNetworkDelayResponse", "Lpl/allegro/tech/servicemesh/envoycontrol/chaos/api/NetworkDelayResponse;", "removeAllFromStorage", "", "should accept delete request and return NO_CONTENT (204)", "should post a chaos fault request and get response with storage object", "should remove correct Network Delay item from storage", "should response with list of posted Network Delay", "should return UNAUTHORIZED for invalid user", "should return empty experiment list when no experiment is running", "should return experiment list with OK (200) status", "ChaosFaultInvalidResponseException", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nChaosControllerTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChaosControllerTest.kt\npl/allegro/tech/servicemesh/envoycontrol/ChaosControllerTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class ChaosControllerTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper objectMapper;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(consul, null, 2, null);

    public ChaosControllerTest() {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KotlinModule.Builder().build()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"configure(...)");
        this.objectMapper = objectMapper;
    }

    @Test
    public final void should return UNAUTHORIZED for invalid user() {
        Response response2 = envoyControl.getApp().postChaosFaultRequest("bad-user", "wrong-pass", ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p());
        Assertions.assertThat((int)response2.code()).isEqualTo(HttpStatus.UNAUTHORIZED.value());
    }

    @Test
    public final void should post a chaos fault request and get response with storage object() {
        NetworkDelayResponse response2;
        NetworkDelayResponse $this$should_post_a_chaos_fault_request_and_get_response_with_storage_object_u24lambda_u240 = response2 = this.convertResponseToNetworkDelayResponse(EnvoyControlTestApp.DefaultImpls.postChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p(), 3, null));
        boolean bl = false;
        Assertions.assertThat((String)$this$should_post_a_chaos_fault_request_and_get_response_with_storage_object_u24lambda_u240.getId()).isNotEmpty();
        Assertions.assertThat((String)$this$should_post_a_chaos_fault_request_and_get_response_with_storage_object_u24lambda_u240.getAffectedService()).isEqualTo(ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p().getAffectedService());
        Assertions.assertThat((String)$this$should_post_a_chaos_fault_request_and_get_response_with_storage_object_u24lambda_u240.getDelay()).isEqualTo(ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p().getDelay());
        Assertions.assertThat((String)$this$should_post_a_chaos_fault_request_and_get_response_with_storage_object_u24lambda_u240.getDuration()).isEqualTo(ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p().getDuration());
        Assertions.assertThat((String)$this$should_post_a_chaos_fault_request_and_get_response_with_storage_object_u24lambda_u240.getTargetService()).isEqualTo(ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p().getTargetService());
    }

    @Test
    public final void should accept delete request and return NO_CONTENT (204)() {
        Response response2 = EnvoyControlTestApp.DefaultImpls.deleteChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayId$p(), 3, null);
        Assertions.assertThat((int)response2.code()).isEqualTo(HttpStatus.NO_CONTENT.value());
    }

    @Test
    public final void should return experiment list with OK (200) status() {
        Response response2 = EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null);
        Assertions.assertThat((int)response2.code()).isEqualTo(HttpStatus.OK.value());
    }

    @Test
    public final void should return empty experiment list when no experiment is running() {
        ExperimentsListResponse response2 = this.convertResponseToExperimentsListResponse(EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null));
        Assertions.assertThat((List)response2.getExperimentList()).isEqualTo((Object)CollectionsKt.emptyList());
    }

    @Test
    public final void should response with list of posted Network Delay() {
        this.removeAllFromStorage();
        NetworkDelayResponse item1 = this.convertResponseToNetworkDelayResponse(EnvoyControlTestApp.DefaultImpls.postChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p(), 3, null));
        NetworkDelayResponse item2 = this.convertResponseToNetworkDelayResponse(EnvoyControlTestApp.DefaultImpls.postChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p(), 3, null));
        ExperimentsListResponse itemsList = this.convertResponseToExperimentsListResponse(EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null));
        List $this$should_response_with_list_of_posted_Network_Delay_u24lambda_u241 = itemsList.getExperimentList();
        boolean bl = false;
        Assertions.assertThat((int)$this$should_response_with_list_of_posted_Network_Delay_u24lambda_u241.size()).isEqualTo(2);
        Object[] objectArray = new NetworkDelayResponse[]{item1, item2};
        Assertions.assertThat((boolean)$this$should_response_with_list_of_posted_Network_Delay_u24lambda_u241.containsAll(CollectionsKt.listOf((Object[])objectArray)));
    }

    @Test
    public final void should remove correct Network Delay item from storage() {
        this.removeAllFromStorage();
        NetworkDelayResponse item1 = this.convertResponseToNetworkDelayResponse(EnvoyControlTestApp.DefaultImpls.postChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p(), 3, null));
        NetworkDelayResponse item2 = this.convertResponseToNetworkDelayResponse(EnvoyControlTestApp.DefaultImpls.postChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p(), 3, null));
        NetworkDelayResponse item3 = this.convertResponseToNetworkDelayResponse(EnvoyControlTestApp.DefaultImpls.postChaosFaultRequest$default(envoyControl.getApp(), null, null, ChaosControllerTestKt.access$getSampleNetworkDelayRequest$p(), 3, null));
        ExperimentsListResponse itemsList = this.convertResponseToExperimentsListResponse(EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null));
        Assertions.assertThat((int)itemsList.getExperimentList().size()).isEqualTo(3);
        Response response2 = EnvoyControlTestApp.DefaultImpls.deleteChaosFaultRequest$default(envoyControl.getApp(), null, null, item2.getId(), 3, null);
        ExperimentsListResponse resultItemsList = this.convertResponseToExperimentsListResponse(EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null));
        List $this$should_remove_correct_Network_Delay_item_from_storage_u24lambda_u242 = resultItemsList.getExperimentList();
        boolean bl = false;
        Assertions.assertThat((int)$this$should_remove_correct_Network_Delay_item_from_storage_u24lambda_u242.size()).isEqualTo(2);
        Object[] objectArray = new NetworkDelayResponse[]{item1, item3};
        Assertions.assertThat((boolean)$this$should_remove_correct_Network_Delay_item_from_storage_u24lambda_u242.containsAll(CollectionsKt.listOf((Object[])objectArray)));
    }

    private final void removeAllFromStorage() {
        ExperimentsListResponse response2 = this.convertResponseToExperimentsListResponse(EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null));
        for (NetworkDelayResponse item : response2.getExperimentList()) {
            EnvoyControlTestApp.DefaultImpls.deleteChaosFaultRequest$default(envoyControl.getApp(), null, null, item.getId(), 3, null);
        }
        response2 = this.convertResponseToExperimentsListResponse(EnvoyControlTestApp.DefaultImpls.getExperimentsListRequest$default(envoyControl.getApp(), null, null, 3, null));
        Assertions.assertThat((int)response2.getExperimentList().size()).isEqualTo(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkDelayResponse convertResponseToNetworkDelayResponse(Response response2) {
        NetworkDelayResponse networkDelayResponse;
        ResponseBody responseBody = response2.body();
        if (responseBody != null) {
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                NetworkDelayResponse networkDelayResponse2 = (NetworkDelayResponse)this.objectMapper.readValue(it.byteStream(), NetworkDelayResponse.class);
                v0 = networkDelayResponse2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            v0 = networkDelayResponse = null;
        }
        if (networkDelayResponse == null) {
            throw new ChaosFaultInvalidResponseException();
        }
        return networkDelayResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExperimentsListResponse convertResponseToExperimentsListResponse(Response response2) {
        ExperimentsListResponse experimentsListResponse;
        ResponseBody responseBody = response2.body();
        if (responseBody != null) {
            Closeable closeable = (Closeable)responseBody;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl = false;
                ExperimentsListResponse experimentsListResponse2 = (ExperimentsListResponse)this.objectMapper.readValue(it.byteStream(), ExperimentsListResponse.class);
                v0 = experimentsListResponse2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            v0 = experimentsListResponse = null;
        }
        if (experimentsListResponse == null) {
            throw new ChaosFaultInvalidResponseException();
        }
        return experimentsListResponse;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ChaosControllerTest$ChaosFaultInvalidResponseException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "envoy-control-tests"})
    private static final class ChaosFaultInvalidResponseException
    extends RuntimeException {
        public ChaosFaultInvalidResponseException() {
            super("Expected NetworkDelayResponse in response body but got none");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ChaosControllerTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

