/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.ClusterCircuitBreakerDefaultSettingsTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.Threshold;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ClusterCircuitBreakerDefaultSettingsTest;", "", "()V", "pendingRqLessThan", "", "value", "", "should enable setting circuit breaker threstholds setting", "", "should have decreased remaining pending rq", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nClusterCircuitBreakerDefaultSettingsTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterCircuitBreakerDefaultSettingsTest.kt\npl/allegro/tech/servicemesh/envoycontrol/ClusterCircuitBreakerDefaultSettingsTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class ClusterCircuitBreakerDefaultSettingsTest {
    @NotNull
    public static final Companion Companion;
    public static final int maxPending = 2;
    @NotNull
    private static final Map<String, Threshold> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy2;

    @Test
    public final void should enable setting circuit breaker threstholds setting() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        ConsulOperations.registerService$default(consulOperations, service, null, "echo", false, null, null, 58, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, should enable setting circuit breaker threstholds setting.1.INSTANCE, 3, null);
        int maxRequestsSetting = envoy.getContainer().admin().circuitBreakerSetting("echo", "max_requests", "default_priority");
        int maxRetriesSetting = envoy.getContainer().admin().circuitBreakerSetting("echo", "max_retries", "high_priority");
        String remainingPendingMetric = envoy.getContainer().admin().statValue("cluster.echo.circuit_breakers.default.remaining_pending");
        String remainingRqMetric = envoy.getContainer().admin().statValue("cluster.echo.circuit_breakers.default.remaining_rq");
        Assertions.assertThat((int)maxRequestsSetting).isEqualTo(1);
        Assertions.assertThat((int)maxRetriesSetting).isEqualTo(8);
        Assertions.assertThat((String)remainingPendingMetric).isNotNull();
        Assertions.assertThat((String)remainingRqMetric).isNotNull();
    }

    @Tag(value="flaky")
    @Test
    public final void should have decreased remaining pending rq() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consulOperations, envoy, null, "echo", false, null, 26, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, should have decreased remaining pending rq.1.INSTANCE, 3, null);
        CountDownLatch latch = new CountDownLatch(1);
        Callable<Boolean> callTask = ClusterCircuitBreakerDefaultSettingsTest::should_have_decreased_remaining_pending_rq$lambda$0;
        Callable<Boolean> checkTask = () -> ClusterCircuitBreakerDefaultSettingsTest.should_have_decreased_remaining_pending_rq$lambda$1(this, latch);
        int rqNum = 10;
        ArrayList callableTasks = new ArrayList();
        IntStream.range(0, rqNum).forEach(arg_0 -> ClusterCircuitBreakerDefaultSettingsTest.should_have_decreased_remaining_pending_rq$lambda$2(callableTasks, callTask, checkTask, arg_0));
        ExecutorService executor = Executors.newFixedThreadPool(2 * rqNum);
        executor.invokeAll(callableTasks);
        Assertions.assertThat((boolean)latch.await(2L, TimeUnit.SECONDS)).isTrue();
        executor.shutdown();
    }

    private final boolean pendingRqLessThan(int value) {
        boolean bl;
        String string = envoy2.getContainer().admin().statValue("cluster.echo.circuit_breakers.default.remaining_pending");
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            Integer n = StringsKt.toIntOrNull((String)it);
            int n2 = value;
            bl = n == null || n != n2;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Boolean should_have_decreased_remaining_pending_rq$lambda$0() {
        EgressOperations.callService$default(envoy2.getEgressOperations(), "echo", null, null, null, null, 30, null);
        return true;
    }

    private static final Boolean should_have_decreased_remaining_pending_rq$lambda$1(ClusterCircuitBreakerDefaultSettingsTest this$0, CountDownLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        if (this$0.pendingRqLessThan(2)) {
            $latch.countDown();
        }
        return true;
    }

    private static final void should_have_decreased_remaining_pending_rq$lambda$2(ArrayList $callableTasks, Callable $callTask, Callable $checkTask, int it) {
        Intrinsics.checkNotNullParameter((Object)$callableTasks, (String)"$callableTasks");
        Intrinsics.checkNotNullParameter((Object)$callTask, (String)"$callTask");
        Intrinsics.checkNotNullParameter((Object)$checkTask, (String)"$checkTask");
        $callableTasks.add($callTask);
        $callableTasks.add($checkTask);
    }

    static {
        Threshold it;
        Threshold threshold;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[2];
        Threshold threshold2 = threshold = new Threshold("DEFAULT");
        String string = "envoy-control.envoy.snapshot.egress.commonHttp.circuitBreakers.defaultThreshold";
        int n = 0;
        Pair[] pairArray2 = pairArray;
        boolean bl = false;
        it.setMaxConnections(1);
        it.setMaxPendingRequests(2);
        it.setMaxRequests(1);
        it.setMaxRetries(4);
        Unit unit = Unit.INSTANCE;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)threshold);
        it = threshold = new Threshold("HIGH");
        string = "envoy-control.envoy.snapshot.egress.commonHttp.circuitBreakers.highThreshold";
        n = 1;
        pairArray2 = pairArray;
        boolean bl2 = false;
        it.setMaxConnections(5);
        it.setMaxPendingRequests(6);
        it.setMaxRequests(7);
        it.setMaxRetries(8);
        unit = Unit.INSTANCE;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)threshold);
        properties = MapsKt.mapOf((Pair[])pairArray);
        consul = new ConsulExtension(false, 1, null);
        envoyControl = new EnvoyControlExtension(consul, properties);
        service = new EchoServiceExtension();
        envoy = new EnvoyExtension(envoyControl, service, null, null, 12, null);
        envoy2 = new EnvoyExtension(envoyControl, null, null, null, 14, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/ClusterCircuitBreakerDefaultSettingsTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoy2", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "maxPending", "", "properties", "", "", "Lpl/allegro/tech/servicemesh/envoycontrol/snapshot/Threshold;", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

