/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tags;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.DeltaXdsReconnectionTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/DeltaXdsReconnectionTest;", "", "()V", "assertMetricValue", "", "urlType", "", "getReconnectionRequestCounterValue", "", "type", "(Ljava/lang/String;)Ljava/lang/Integer;", "should increase counters on reconnect request", "startControlPlane", "stopControlPlane", "Companion", "envoy-control-tests"})
public final class DeltaXdsReconnectionTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Boolean> properties = MapsKt.mapOf((Pair)TuplesKt.to((Object)"envoy-control.envoy.snapshot.deltaXdsEnabled", (Object)true));
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(consul, properties);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService1 = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService2 = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoClient = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyEcho = new EnvoyExtension(envoyControl, echoService1, EnvoyControlTestConfigurationKt.getDeltaAds(), null, 8, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyEcho2 = new EnvoyExtension(envoyControl, echoService2, EnvoyControlTestConfigurationKt.getDeltaAds(), null, 8, null);
    @NotNull
    private static final String echoClientConfig = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoClientEnvoy = new EnvoyExtension(envoyControl, echoClient, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getDeltaAds(), null, null, echoClientConfig, null, null, null, 59, null), null, 8, null);

    @Test
    public final void should increase counters on reconnect request() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consulOperations, envoyEcho, null, "echo", false, null, 26, null);
        consulOperations = consul.getServer().getOperations();
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consulOperations, envoyEcho2, null, "echo", false, null, 26, null);
        consulOperations = consul.getServer().getOperations();
        ConsulOperations.registerServiceWithEnvoyOnEgress$default(consulOperations, echoClientEnvoy, null, "echoClient", false, null, 26, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, should increase counters on reconnect request.1.INSTANCE, 3, null);
        Assertions.assertThat((Integer)this.getReconnectionRequestCounterValue("eds")).isNull();
        this.stopControlPlane();
        Thread.sleep(1000L);
        this.startControlPlane();
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ DeltaXdsReconnectionTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DeltaXdsReconnectionTest.access$assertMetricValue(this.this$0, "eds");
                DeltaXdsReconnectionTest.access$assertMetricValue(this.this$0, "cds");
                DeltaXdsReconnectionTest.access$assertMetricValue(this.this$0, "rds");
                DeltaXdsReconnectionTest.access$assertMetricValue(this.this$0, "lds");
            }
        }, 3, null);
    }

    private final void stopControlPlane() {
        envoyControl.getApp().stop();
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(DeltaXdsReconnectionTest::stopControlPlane$lambda$1);
    }

    private final void startControlPlane() {
        envoyControl.getApp().run();
        AwaitAssertionsKt.untilAsserted$default(null, null, startControlPlane.1.INSTANCE, 3, null);
    }

    private final Integer getReconnectionRequestCounterValue(String type) {
        Counter counter = envoyControl.getApp().meterRegistry().find("request.reconnection.stats").tags((Iterable)Tags.of((String)"stream-type", (String)type)).counter();
        return counter != null ? Integer.valueOf((int)counter.count()) : null;
    }

    private final void assertMetricValue(String urlType) {
        int numberOfReconnectingClients = 2;
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)this.getReconnectionRequestCounterValue(urlType)).isNotNull()).isEqualTo(numberOfReconnectingClients);
    }

    private static final void stopControlPlane$lambda$1$lambda$0() {
        envoyControl.getApp().isHealthy();
    }

    private static final void stopControlPlane$lambda$1() {
        Assertions.assertThatThrownBy(DeltaXdsReconnectionTest::stopControlPlane$lambda$1$lambda$0).isInstanceOf(ConnectException.class);
    }

    public static final /* synthetic */ void access$assertMetricValue(DeltaXdsReconnectionTest $this, String urlType) {
        $this.assertMetricValue(urlType);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/DeltaXdsReconnectionTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echoClient", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echoClientConfig", "", "echoClientEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echoService1", "echoService2", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoyEcho", "envoyEcho2", "properties", "", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

