/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.EnvoyLoadBalancingPrioritiesTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulClusterSetup;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulMultiClusterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlClusteredExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J%\u0010\u000b\u001a\u00020\f*\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000f\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0014\u0010\u0015\u001a\u00020\u0004*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J%\u0010\u0016\u001a\u00020\u0004*\u00020\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000f\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyLoadBalancingPrioritiesTest;", "", "()V", "should prioritize local dc having no priorities properties", "", "should route traffic according to priorities when all instances are healthy", "should route traffic to dc2 when there are no healthy instances in dc1", "should route traffic to dc3 only when there are no healthy instances in others", "waitServiceOkAndFrom", "echoServiceExtension", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "callEchoServiceRepeatedly", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "services", "", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;[Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;)Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "registerService", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulClusterSetup;", "service", "registerServiceAndVerifyCall", "verifyNoCallsRoutedTo", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;[Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;)V", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nEnvoyLoadBalancingPrioritiesTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvoyLoadBalancingPrioritiesTest.kt\npl/allegro/tech/servicemesh/envoycontrol/EnvoyLoadBalancingPrioritiesTest\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,198:1\n13309#2,2:199\n*S KotlinDebug\n*F\n+ 1 EnvoyLoadBalancingPrioritiesTest.kt\npl/allegro/tech/servicemesh/envoycontrol/EnvoyLoadBalancingPrioritiesTest\n*L\n194#1:199,2\n*E\n"})
public final class EnvoyLoadBalancingPrioritiesTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String serviceName = "echo";
    private static final int numberOfCalls = 30;
    private static final Duration pollingInterval = Duration.ofSeconds(1L);
    private static final Duration stateSampleDuration = Duration.ofSeconds(1L);
    @NotNull
    private static final Map<String, Object> syncProps;
    @NotNull
    private static final Map<String, Map<String, Map<String, Integer>>> priorityProps;
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulMultiClusterExtension consulClusters;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControl3;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControlNoPriorities;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyDC1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyDC2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyDC3;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyNoPriorities;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension serviceDC1_1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension serviceDC2_1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension serviceDC3_1;

    @Test
    public final void should route traffic according to priorities when all instances are healthy() {
        this.registerService(consulClusters.getServerFirst(), serviceDC1_1);
        this.registerService(consulClusters.getServerSecond(), serviceDC2_1);
        this.registerService(consulClusters.getServerThird(), serviceDC3_1);
        this.waitServiceOkAndFrom(serviceDC1_1);
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1, serviceDC3_1};
        CallStats callStats = this.callEchoServiceRepeatedly(envoyDC1, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC2_1, serviceDC3_1};
        this.verifyNoCallsRoutedTo(callStats, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1, serviceDC3_1};
        CallStats callStats2 = this.callEchoServiceRepeatedly(envoyDC2, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC3_1};
        this.verifyNoCallsRoutedTo(callStats2, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1, serviceDC3_1};
        CallStats callStats3 = this.callEchoServiceRepeatedly(envoyDC3, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC2_1, serviceDC1_1};
        this.verifyNoCallsRoutedTo(callStats3, echoServiceExtensionArray);
    }

    @Test
    public final void should prioritize local dc having no priorities properties() {
        this.registerService(consulClusters.getServerFirst(), serviceDC1_1);
        this.registerService(consulClusters.getServerSecond(), serviceDC2_1);
        this.registerService(consulClusters.getServerThird(), serviceDC3_1);
        AwaitAssertionsKt.untilAsserted$default(null, null, should prioritize local dc having no priorities properties.1.INSTANCE, 3, null);
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1, serviceDC3_1};
        CallStats callStats = this.callEchoServiceRepeatedly(envoyNoPriorities, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1};
        this.verifyNoCallsRoutedTo(callStats, echoServiceExtensionArray);
    }

    @Test
    public final void should route traffic to dc2 when there are no healthy instances in dc1() {
        this.registerServiceAndVerifyCall(consulClusters.getServerSecond(), serviceDC2_1);
        this.registerService(consulClusters.getServerThird(), serviceDC3_1);
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC2_1, serviceDC3_1};
        CallStats callStats = this.callEchoServiceRepeatedly(envoyDC1, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC3_1};
        this.verifyNoCallsRoutedTo(callStats, echoServiceExtensionArray);
        this.registerServiceAndVerifyCall(consulClusters.getServerFirst(), serviceDC1_1);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1, serviceDC3_1};
        CallStats callStats2 = this.callEchoServiceRepeatedly(envoyDC1, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC2_1, serviceDC3_1};
        this.verifyNoCallsRoutedTo(callStats2, echoServiceExtensionArray);
    }

    @Test
    public final void should route traffic to dc3 only when there are no healthy instances in others() {
        this.registerServiceAndVerifyCall(consulClusters.getServerThird(), serviceDC3_1);
        this.registerServiceAndVerifyCall(consulClusters.getServerFirst(), serviceDC2_1);
        EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC2_1, serviceDC3_1};
        CallStats callStats = this.callEchoServiceRepeatedly(envoyDC1, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC3_1};
        this.verifyNoCallsRoutedTo(callStats, echoServiceExtensionArray);
        this.registerServiceAndVerifyCall(consulClusters.getServerFirst(), serviceDC1_1);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC1_1, serviceDC2_1, serviceDC3_1};
        CallStats callStats2 = this.callEchoServiceRepeatedly(envoyDC1, echoServiceExtensionArray);
        echoServiceExtensionArray = new EchoServiceExtension[]{serviceDC3_1};
        this.verifyNoCallsRoutedTo(callStats2, echoServiceExtensionArray);
    }

    private final void waitServiceOkAndFrom(EchoServiceExtension echoServiceExtension) {
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Response>(echoServiceExtension){
            final /* synthetic */ EchoServiceExtension $echoServiceExtension;
            {
                this.$echoServiceExtension = $echoServiceExtension;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2 = EgressOperations.callService$default(EnvoyLoadBalancingPrioritiesTest.envoyDC1.getEgressOperations(), "echo", null, null, null, null, 30, null);
                EchoServiceExtension echoServiceExtension = this.$echoServiceExtension;
                Response it = response2;
                boolean bl = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoServiceExtension);
                return response2;
            }
        }, 3, null);
    }

    private final CallStats callEchoServiceRepeatedly(EnvoyExtension $this$callEchoServiceRepeatedly, EchoServiceExtension ... services) {
        CallStats stats2 = new CallStats(ArraysKt.asList((Object[])services));
        EgressOperations.callServiceRepeatedly$default($this$callEchoServiceRepeatedly.getEgressOperations(), serviceName, stats2, 30, 30, callEchoServiceRepeatedly.1.INSTANCE, MapsKt.emptyMap(), null, false, 192, null);
        return stats2;
    }

    private final String registerService(ConsulClusterSetup $this$registerService, EchoServiceExtension service) {
        return ConsulOperations.registerService$default($this$registerService.getOperations(), service, null, serviceName, false, null, null, 58, null);
    }

    private final void registerServiceAndVerifyCall(ConsulClusterSetup $this$registerServiceAndVerifyCall, EchoServiceExtension service) {
        ConsulOperations.registerService$default($this$registerServiceAndVerifyCall.getOperations(), service, null, serviceName, false, null, null, 58, null);
        this.waitServiceOkAndFrom(service);
    }

    private final void verifyNoCallsRoutedTo(CallStats $this$verifyNoCallsRoutedTo, EchoServiceExtension ... services) {
        EchoServiceExtension[] $this$forEach$iv = services;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            EchoServiceExtension element$iv;
            EchoServiceExtension it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Assertions.assertThat((int)$this$verifyNoCallsRoutedTo.hits(it)).isEqualTo(0);
        }
    }

    public static final /* synthetic */ Map access$getProperties$cp() {
        return properties;
    }

    public static final /* synthetic */ Map access$getSyncProps$cp() {
        return syncProps;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.stateSampleDuration", (Object)stateSampleDuration), TuplesKt.to((Object)"envoy-control.sync.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.sync.polling-interval", (Object)pollingInterval.getSeconds())};
        syncProps = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[3];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"dc1", (Object)0), TuplesKt.to((Object)"dc2", (Object)1), TuplesKt.to((Object)"dc3", (Object)2)};
        pairArray[0] = TuplesKt.to((Object)"dc1", (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"dc1", (Object)2), TuplesKt.to((Object)"dc2", (Object)0), TuplesKt.to((Object)"dc3", (Object)1)};
        pairArray[1] = TuplesKt.to((Object)"dc2", (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to((Object)"dc1", (Object)1), TuplesKt.to((Object)"dc2", (Object)2), TuplesKt.to((Object)"dc3", (Object)0)};
        pairArray[2] = TuplesKt.to((Object)"dc3", (Object)MapsKt.mapOf((Pair[])pairArray2));
        priorityProps = MapsKt.mapOf((Pair)TuplesKt.to((Object)"envoy-control.envoy.snapshot.loadBalancing.priorities.zonePriorities", (Object)MapsKt.mapOf((Pair[])pairArray)));
        properties = MapsKt.plus(syncProps, priorityProps);
        consulClusters = new ConsulMultiClusterExtension();
        envoyControl = new EnvoyControlClusteredExtension(consulClusters.getServerFirst(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consulClusters));
        envoyControl2 = new EnvoyControlClusteredExtension(consulClusters.getServerSecond(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl2.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consulClusters));
        envoyControl3 = new EnvoyControlClusteredExtension(consulClusters.getServerThird(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControl3.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consulClusters));
        envoyControlNoPriorities = new EnvoyControlClusteredExtension(consulClusters.getServerThird(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControlNoPriorities.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consulClusters));
        envoyDC1 = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        envoyDC2 = new EnvoyExtension(envoyControl2, null, null, null, 14, null);
        envoyDC3 = new EnvoyExtension(envoyControl3, null, null, null, 14, null);
        envoyNoPriorities = new EnvoyExtension(envoyControlNoPriorities, null, null, null, 14, null);
        serviceDC1_1 = new EchoServiceExtension();
        serviceDC2_1 = new EchoServiceExtension();
        serviceDC3_1 = new EchoServiceExtension();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0014\u001a&\u0012\u0004\u0012\u00020\u0016\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u00150\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00010\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00010\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyLoadBalancingPrioritiesTest$Companion;", "", "()V", "consulClusters", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulMultiClusterExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlClusteredExtension;", "envoyControl2", "envoyControl3", "envoyControlNoPriorities", "envoyDC1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyDC2", "envoyDC3", "envoyNoPriorities", "numberOfCalls", "", "pollingInterval", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "priorityProps", "", "", "properties", "serviceDC1_1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "serviceDC2_1", "serviceDC3_1", "serviceName", "stateSampleDuration", "syncProps", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

