/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HealthStatus;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HostStatus;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u000b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/OutlierDetectionTest;", "", "()V", "hasOutlierCheckFailed", "", "cluster", "", "unhealthyIp", "should not send requests to instance when outlier check failed", "", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nOutlierDetectionTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutlierDetectionTest.kt\npl/allegro/tech/servicemesh/envoycontrol/OutlierDetectionTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class OutlierDetectionTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair)TuplesKt.to((Object)"envoy-control.envoy.snapshot.cluster-outlier-detection.enabled", (Object)true)));
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension healthyService = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension unhealthyService = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy = new EnvoyExtension(envoyControl, null, EnvoyControlTestConfigurationKt.getRandomConfigFile(), null, 10, null);

    @Test
    public final void should not send requests to instance when outlier check failed() {
        String unhealthyIp = unhealthyService.container().ipAddress();
        ConsulOperations.registerService$default(consul.getServer().getOperations(), healthyService, null, "echo", false, null, null, 58, null);
        ConsulOperations.registerService$default(consul.getServer().getOperations(), unhealthyService, null, "echo", false, null, null, 58, null);
        unhealthyService.container().stop();
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractBooleanAssert<?>>(this, unhealthyIp){
            final /* synthetic */ OutlierDetectionTest this$0;
            final /* synthetic */ String $unhealthyIp;
            {
                this.this$0 = $receiver;
                this.$unhealthyIp = $unhealthyIp;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                EgressOperations.callService$default(OutlierDetectionTest.envoy.getEgressOperations(), "echo", null, null, null, null, 30, null);
                return Assertions.assertThat((boolean)this.this$0.hasOutlierCheckFailed("echo", this.$unhealthyIp)).isTrue();
            }
        }, 3, null);
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Response response2 = EgressOperations.callService$default(envoy.getEgressOperations(), "echo", null, null, null, null, 30, null);
            ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
            Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
            ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), healthyService);
        }
    }

    public final boolean hasOutlierCheckFailed(@NotNull String cluster, @NotNull String unhealthyIp) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)unhealthyIp, (String)"unhealthyIp");
        Object object = envoy.getContainer().admin().hostStatus(cluster, unhealthyIp);
        HostStatus it = object;
        boolean bl2 = false;
        HostStatus hostStatus = it;
        System.out.println((Object)("HOST STATUS: " + (hostStatus != null ? hostStatus.getHealthStatus() : null)));
        HostStatus hostStatus2 = object;
        return hostStatus2 != null && (object = hostStatus2.getHealthStatus()) != null && (bl = ((HealthStatus)object).getFailedOutlierCheck()) != null ? bl : false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/OutlierDetectionTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "healthyService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "unhealthyService", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

