/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import pl.allegro.tech.servicemesh.envoycontrol.RequestIdTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.HttpsEchoResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.GenericServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoResponse;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u001c\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u001c\u0010\t\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u001c\u0010\n\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u001c\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a8\u0006\r"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RequestIdTest;", "", "()V", "setup", "", "should generate x-request-id on the egress port when it is missing in request", "extraHeaders", "", "", "should generate x-request-id on the ingress port when it is missing in request", "should propagate x-request-id on the egress port when it is available in request", "should propagate x-request-id on the ingress port when it is available in request", "Companion", "envoy-control-tests"})
public final class RequestIdTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(consul, null, 2, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<HttpsEchoContainer> localService = new GenericServiceExtension<ServiceContainer>(new HttpsEchoContainer());
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy = new EnvoyExtension(envoyControl, localService, null, null, 12, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<HttpsEchoContainer> externalService = new GenericServiceExtension<ServiceContainer>(new HttpsEchoContainer());

    @BeforeEach
    public final void setup() {
        ConsulOperations.registerService$default(consul.getServer().getOperations(), externalService, null, "service-1", false, null, null, 58, null);
    }

    @ParameterizedTest
    @MethodSource(value={"extraHeadersSource"})
    public final void should propagate x-request-id on the egress port when it is available in request(@NotNull Map<String, String> extraHeaders) {
        Intrinsics.checkNotNullParameter(extraHeaders, (String)"extraHeaders");
        Map requestIdHeader = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-request-id", (Object)"egress-fake-request-id"));
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<MapAssert<String, String>>((Map<String, String>)requestIdHeader, extraHeaders){
            final /* synthetic */ Map<String, String> $requestIdHeader;
            final /* synthetic */ Map<String, String> $extraHeaders;
            {
                this.$requestIdHeader = $requestIdHeader;
                this.$extraHeaders = $extraHeaders;
                super(0);
            }

            public final MapAssert<String, String> invoke() {
                HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(RequestIdTest.envoy.getEgressOperations(), "service-1", MapsKt.plus(this.$requestIdHeader, this.$extraHeaders), null, null, null, 28, null));
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
                return (MapAssert)Assertions.assertThat(response2.getRequestHeaders()).containsEntry((Object)"x-request-id", (Object)"egress-fake-request-id");
            }
        }, 3, null);
    }

    @ParameterizedTest
    @MethodSource(value={"extraHeadersSource"})
    public final void should generate x-request-id on the egress port when it is missing in request(@NotNull Map<String, String> extraHeaders) {
        Intrinsics.checkNotNullParameter(extraHeaders, (String)"extraHeaders");
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<MapAssert<String, String>>(extraHeaders){
            final /* synthetic */ Map<String, String> $extraHeaders;
            {
                this.$extraHeaders = $extraHeaders;
                super(0);
            }

            public final MapAssert<String, String> invoke() {
                HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(EgressOperations.callService$default(RequestIdTest.envoy.getEgressOperations(), "service-1", this.$extraHeaders, null, null, null, 28, null));
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
                return (MapAssert)Assertions.assertThat(response2.getRequestHeaders()).hasEntrySatisfying((Object)"x-request-id", arg_0 -> should generate x-request-id on the egress port when it is missing in request.1.invoke$lambda$0(should generate x-request-id on the egress port when it is missing in request.1.INSTANCE, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, 3, null);
    }

    @ParameterizedTest
    @MethodSource(value={"extraHeadersSource"})
    public final void should propagate x-request-id on the ingress port when it is available in request(@NotNull Map<String, String> extraHeaders) {
        Intrinsics.checkNotNullParameter(extraHeaders, (String)"extraHeaders");
        Map requestIdHeader = MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-request-id", (Object)"ingress-fake-request-id"));
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<MapAssert<String, String>>((Map<String, String>)requestIdHeader, extraHeaders){
            final /* synthetic */ Map<String, String> $requestIdHeader;
            final /* synthetic */ Map<String, String> $extraHeaders;
            {
                this.$requestIdHeader = $requestIdHeader;
                this.$extraHeaders = $extraHeaders;
                super(0);
            }

            public final MapAssert<String, String> invoke() {
                HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(RequestIdTest.envoy.getIngressOperations().callLocalService("/", Headers.Companion.of(MapsKt.plus(this.$requestIdHeader, this.$extraHeaders))));
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
                return (MapAssert)Assertions.assertThat(response2.getRequestHeaders()).containsEntry((Object)"x-request-id", (Object)"ingress-fake-request-id");
            }
        }, 3, null);
    }

    @ParameterizedTest
    @MethodSource(value={"extraHeadersSource"})
    public final void should generate x-request-id on the ingress port when it is missing in request(@NotNull Map<String, String> extraHeaders) {
        Intrinsics.checkNotNullParameter(extraHeaders, (String)"extraHeaders");
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<MapAssert<String, String>>(extraHeaders){
            final /* synthetic */ Map<String, String> $extraHeaders;
            {
                this.$extraHeaders = $extraHeaders;
                super(0);
            }

            public final MapAssert<String, String> invoke() {
                HttpsEchoResponse response2 = HttpsEchoContainerKt.asHttpsEchoResponse(RequestIdTest.envoy.getIngressOperations().callLocalService("/", Headers.Companion.of(this.$extraHeaders)));
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                HttpsEchoResponseAssertionsKt.isOk((ObjectAssert<HttpsEchoResponse>)objectAssert);
                return (MapAssert)Assertions.assertThat(response2.getRequestHeaders()).hasEntrySatisfying((Object)"x-request-id", arg_0 -> should generate x-request-id on the ingress port when it is missing in request.1.invoke$lambda$0(should generate x-request-id on the ingress port when it is missing in request.1.INSTANCE, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, 3, null);
    }

    @JvmStatic
    @NotNull
    public static final List<Map<String, String>> extraHeadersSource() {
        return Companion.extraHeadersSource();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RequestIdTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "externalService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/GenericServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoContainer;", "localService", "extraHeadersSource", "", "", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Map<String, String>> extraHeadersSource() {
            Object[] objectArray = new Map[]{MapsKt.emptyMap(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-forwarded-for", (Object)"123.321.231.111")), MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-forwarded-for", (Object)"111.111.222.222,123.123.231.231"))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

