/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.RetryPolicyTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\nH\u0007\u00a8\u0006\u000e"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RetryPolicyTest;", "", "()V", "hasRetriedRequest", "", "numberOfRetries", "", "metricName", "", "should have no retries for get method if post and put specified only", "", "should retry 8 times when configured retry policy route for service", "should retry request 3 times when application is down", "Companion", "envoy-control-tests"})
public final class RetryPolicyTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String RETRY_SETTINGS_CONFIG = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo\"\n            retryPolicy:\n              retryOn: [\"retriable-status-codes\"]\n              numberRetries: 8\n              retryableStatusCodes: [200]\n          - service: \"macho\"\n            retryPolicy:\n              retryOn: [\"retriable-status-codes\"]\n              numberRetries: 8\n              retryableStatusCodes: [200]\n              methods: [\"PUT\", \"POST\"]";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;

    @Test
    public final void should retry request 3 times when application is down() {
        service.container().stop();
        envoy.getIngressOperations().callLocalService("/endpoint", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-name", (Object)"authorizedClient"))));
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractBooleanAssert<?>>(this){
            final /* synthetic */ RetryPolicyTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return Assertions.assertThat((boolean)RetryPolicyTest.access$hasRetriedRequest(this.this$0, 3L, "cluster.local_service.upstream_rq_retry")).isTrue();
            }
        }, 3, null);
    }

    @Test
    public final void should retry 8 times when configured retry policy route for service() {
        service.container().start();
        ConsulOperations.registerService$default(consul.getServer().getOperations(), service, null, "echo", false, null, null, 58, null);
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, should retry 8 times when configured retry policy route for service.1.INSTANCE, 1, null);
        Duration duration2 = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration2, new Function0<AbstractBooleanAssert<?>>(this){
            final /* synthetic */ RetryPolicyTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return Assertions.assertThat((boolean)RetryPolicyTest.access$hasRetriedRequest(this.this$0, 8L, "cluster.echo.upstream_rq_retry")).isTrue();
            }
        }, 1, null);
    }

    @Test
    public final void should have no retries for get method if post and put specified only() {
        service.container().start();
        ConsulOperations.registerService$default(consul.getServer().getOperations(), service, null, "macho", false, null, null, 58, null);
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, should have no retries for get method if post and put specified only.1.INSTANCE, 1, null);
        Duration duration2 = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration2, new Function0<AbstractBooleanAssert<?>>(this){
            final /* synthetic */ RetryPolicyTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return Assertions.assertThat((boolean)RetryPolicyTest.access$hasRetriedRequest(this.this$0, 0L, "cluster.macho.upstream_rq_retry")).isTrue();
            }
        }, 1, null);
    }

    private final boolean hasRetriedRequest(long numberOfRetries, String metricName) {
        String string = envoy.getContainer().admin().statValue(metricName);
        return string != null ? ((Object)Long.parseLong(string)).equals(numberOfRetries) : false;
    }

    public static final /* synthetic */ boolean access$hasRetriedRequest(RetryPolicyTest $this, long numberOfRetries, String metricName) {
        return $this.hasRetriedRequest(numberOfRetries, metricName);
    }

    static {
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.local-service.retry-policy.per-http-method.GET.enabled", (Object)true);
        Object[] objectArray = new String[]{"connect-failure", "reset"};
        pairArray[1] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.local-service.retry-policy.per-http-method.GET.retry-on", (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[2] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.local-service.retry-policy.per-http-method.GET.num-retries", (Object)3);
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])pairArray));
        service = new EchoServiceExtension();
        envoy = new EnvoyExtension(envoyControl, service, EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getXds(), null, null, RETRY_SETTINGS_CONFIG, null, null, null, 59, null), null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/RetryPolicyTest$Companion;", "", "()V", "RETRY_SETTINGS_CONFIG", "", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

