/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.StateControllerTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.ClientsFactory;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HttpResponseCloser;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlRunnerTestApp;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlTestApp;
import pl.allegro.tech.servicemesh.envoycontrol.services.ServicesState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/StateControllerTest;", "", "()V", "buildEnvoyAppWithProperties", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlRunnerTestApp;", "properties", "", "", "getState", "Lokhttp3/Response;", "appPort", "", "should return gzip state", "", "should return json state", "waitUntilHealthy", "app", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlTestApp;", "Companion", "envoy-control-tests"})
public final class StateControllerTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);

    @Test
    public final void should return json state() {
        EnvoyControlRunnerTestApp app2 = new EnvoyControlRunnerTestApp(should return json state.app.1.INSTANCE, consul.getServer().getPort(), null, 0, 0, 28, null);
        app2.run();
        this.waitUntilHealthy(app2);
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, (Function0)new Function0<ObjectAssert<ServicesState>>(this, app2){
            final /* synthetic */ StateControllerTest this$0;
            final /* synthetic */ EnvoyControlRunnerTestApp $app;
            {
                this.this$0 = $receiver;
                this.$app = $app;
                super(0);
            }

            public final ObjectAssert<ServicesState> invoke() {
                Response stateResponse = StateControllerTest.access$getState(this.this$0, this.$app.getAppPort());
                Assertions.assertThat((Object)stateResponse.body()).hasFieldOrPropertyWithValue("contentTypeString", (Object)"application/json");
                ResponseBody responseBody = stateResponse.body();
                ServicesState converted = (ServicesState)this.$app.getObjectMapper().convertValue((Object)(responseBody != null ? responseBody.byteStream() : null), ServicesState.class);
                return (ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)converted).isNotNull()).hasNoNullFieldsOrProperties();
            }
        }, 1, null);
        app2.stop();
    }

    @Test
    public final void should return gzip state() {
        EnvoyControlRunnerTestApp app2 = this.buildEnvoyAppWithProperties(StateControllerTest.Companion.gzipEnabledProperties());
        app2.run();
        this.waitUntilHealthy(app2);
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, (Function0)new Function0<ObjectAssert<ServicesState>>(this, app2){
            final /* synthetic */ StateControllerTest this$0;
            final /* synthetic */ EnvoyControlRunnerTestApp $app;
            {
                this.this$0 = $receiver;
                this.$app = $app;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final ObjectAssert<ServicesState> invoke() {
                Response stateResponse = StateControllerTest.access$getState(this.this$0, this.$app.getAppPort());
                ResponseBody responseBody = stateResponse.body();
                Closeable closeable = new GZIPInputStream(responseBody != null ? responseBody.byteStream() : null);
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Object unGzippedStr = object2;
                ServicesState converted = (ServicesState)this.$app.getObjectMapper().readValue((String)unGzippedStr, ServicesState.class);
                return (ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)converted).isNotNull()).hasNoNullFieldsOrProperties();
            }
        }, 1, null);
        app2.stop();
    }

    private final EnvoyControlRunnerTestApp buildEnvoyAppWithProperties(Map<String, ? extends Object> properties2) {
        return new EnvoyControlRunnerTestApp((Function0)new Function0<Map<String, ? extends Object>>(properties2){
            final /* synthetic */ Map<String, Object> $properties;
            {
                this.$properties = $properties;
                super(0);
            }

            @NotNull
            public final Map<String, Object> invoke() {
                return this.$properties;
            }
        }, consul.getServer().getPort(), null, 0, 0, 28, null);
    }

    private final Response getState(int appPort) {
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(ClientsFactory.INSTANCE.createClient().newBuilder().build().newCall(new Request.Builder().get().url("http://localhost:" + appPort + "/state").addHeader("Accept-Encoding", "gzip").build()).execute());
    }

    private final void waitUntilHealthy(EnvoyControlTestApp app2) {
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).untilAsserted(() -> StateControllerTest.waitUntilHealthy$lambda$0(app2));
    }

    private static final void waitUntilHealthy$lambda$0(EnvoyControlTestApp $app) {
        Intrinsics.checkNotNullParameter((Object)$app, (String)"$app");
        Assertions.assertThat((boolean)$app.isHealthy()).isTrue();
    }

    @JvmStatic
    private static final Map<String, Object> regularProperties() {
        return StateControllerTest.Companion.regularProperties();
    }

    @JvmStatic
    private static final Map<String, Object> gzipEnabledProperties() {
        return StateControllerTest.Companion.gzipEnabledProperties();
    }

    public static final /* synthetic */ Response access$getState(StateControllerTest $this, int appPort) {
        return $this.getState(appPort);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0003J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0003R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/StateControllerTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "gzipEnabledProperties", "", "", "regularProperties", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final Map<String, Object> regularProperties() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.sync.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.metadata-key", (Object)"tag"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.auto-service-tag-enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.reject-requests-with-duplicated-auto-service-tag", (Object)true)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @JvmStatic
        private final Map<String, Object> gzipEnabledProperties() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"server.compression.enabled", (Object)true), TuplesKt.to((Object)"server.compression.mime-types", (Object)"application/json,application/xml,text/html,text/xml,text/plain,application/javascript,text/css"), TuplesKt.to((Object)"server.compression.min-response-size", (Object)"1"), TuplesKt.to((Object)"envoy-control.sync.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.metadata-key", (Object)"tag"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.auto-service-tag-enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.reject-requests-with-duplicated-auto-service-tag", (Object)true)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

