/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.consul;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.traits.DockerfileTrait;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulClientConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulServerConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.GenericContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u0000H\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulContainer;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "dc", "", "externalPort", "", "id", "consulConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulConfig;", "internalPort", "(Ljava/lang/String;IILpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulConfig;I)V", "getInternalPort", "()I", "awaitConsulReady", "blockExternalTraffic", "", "configure", "sendSignal", "signal", "sigcont", "sigstop", "unblockExternalTraffic", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nConsulContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsulContainer.kt\npl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1855#2,2:83\n*S KotlinDebug\n*F\n+ 1 ConsulContainer.kt\npl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulContainer\n*L\n35#1:83,2\n*E\n"})
public final class ConsulContainer
extends GenericContainer<ConsulContainer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dc;
    private final int externalPort;
    private final int id;
    @NotNull
    private final ConsulConfig consulConfig;
    private final int internalPort;
    @NotNull
    public static final String pidFile = "/tmp/consul.pid";
    @NotNull
    public static final String configDir = "/consul/config";

    public ConsulContainer(@NotNull String dc, int externalPort, int id, @NotNull ConsulConfig consulConfig, int internalPort) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        Intrinsics.checkNotNullParameter((Object)consulConfig, (String)"consulConfig");
        DockerfileTrait dockerfileTrait = new ImageFromDockerfile().withDockerfileFromBuilder(arg_0 -> ConsulContainer._init_$lambda$0(consulConfig, internalPort, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dockerfileTrait, (String)"withDockerfileFromBuilder(...)");
        super((ImageFromDockerfile)dockerfileTrait);
        this.dc = dc;
        this.externalPort = externalPort;
        this.id = id;
        this.consulConfig = consulConfig;
        this.internalPort = internalPort;
    }

    public /* synthetic */ ConsulContainer(String string, int n, int n2, ConsulConfig consulConfig, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            consulConfig = new ConsulServerConfig(n2, string, 0, null, 12, null);
        }
        if ((n4 & 0x10) != 0) {
            n3 = 8500;
        }
        this(string, n, n2, consulConfig, n3);
    }

    public final int getInternalPort() {
        return this.internalPort;
    }

    @Override
    protected void configure() {
        super.configure();
        this.setPortBindings(CollectionsKt.listOf((Object)(this.externalPort + ":" + this.internalPort)));
        this.awaitConsulReady();
    }

    private final ConsulContainer awaitConsulReady() {
        ConsulContainer consulContainer;
        Iterable $this$forEach$iv = this.consulConfig.getJsonFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File jsonFile = (File)element$iv;
            boolean bl = false;
            this.withClasspathResourceMapping(jsonFile.getPath(), "/consul/config/" + jsonFile.getName(), BindMode.READ_ONLY);
        }
        this.withPrivilegedMode(true);
        ConsulConfig consulConfig = this.consulConfig;
        if (consulConfig instanceof ConsulServerConfig) {
            org.testcontainers.containers.GenericContainer genericContainer = this.waitingFor((WaitStrategy)Wait.forHttp((String)"/ui").forStatusCode(200));
            Intrinsics.checkNotNullExpressionValue((Object)genericContainer, (String)"waitingFor(...)");
            consulContainer = (ConsulContainer)genericContainer;
        } else if (consulConfig instanceof ConsulClientConfig) {
            org.testcontainers.containers.GenericContainer genericContainer = this.waitingFor((WaitStrategy)Wait.forHttp((String)"/v1/status/leader").forStatusCode(200));
            Intrinsics.checkNotNullExpressionValue((Object)genericContainer, (String)"waitingFor(...)");
            consulContainer = (ConsulContainer)genericContainer;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return consulContainer;
    }

    public final void blockExternalTraffic() {
        String[] stringArray = new String[]{"iptables -F", "iptables -P INPUT DROP", "iptables -P OUTPUT DROP", "iptables -P FORWARD DROP", "iptables -A INPUT -i lo -j ACCEPT", "iptables -A OUTPUT -o lo -j ACCEPT"};
        String[] commands = stringArray;
        this.runCommands(commands);
    }

    public final void unblockExternalTraffic() {
        String[] stringArray = new String[]{"iptables -F", "iptables -P INPUT ACCEPT", "iptables -P FORWARD ACCEPT", "iptables -P OUTPUT ACCEPT"};
        String[] commands = stringArray;
        this.runCommands(commands);
    }

    private final void sendSignal(String signal) {
        String[] stringArray = new String[]{"cat", pidFile};
        String pid = this.execInContainer(stringArray).getStdout();
        stringArray = new String[]{"kill", "-" + signal, pid};
        this.execInContainer(stringArray);
    }

    @Override
    public void sigstop() {
        this.sendSignal("STOP");
    }

    @Override
    public void sigcont() {
        this.sendSignal("CONT");
    }

    private static final void _init_$lambda$0(ConsulConfig $consulConfig, int $internalPort, DockerfileBuilder it) {
        Intrinsics.checkNotNullParameter((Object)$consulConfig, (String)"$consulConfig");
        Object[] objectArray = new String[]{"apk", "add", "iproute2"};
        DockerfileBuilder dockerfileBuilder = (DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)it.from("consul:1.11.11")).run((String[])objectArray)).cmd($consulConfig.launchCommand());
        objectArray = new Integer[]{$internalPort};
        ((DockerfileBuilder)dockerfileBuilder.expose((Integer[])objectArray)).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulContainer$Companion;", "", "()V", "configDir", "", "pidFile", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

