/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.envoy;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.dockerfile.traits.RunStatementTrait;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.containers.SSLGenericContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyAdmin;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0006J$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u000fJ\b\u0010\u001f\u001a\u00020\u000fH\u0014J\u0012\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\u0006\u0010#\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0006J\u0010\u0010%\u001a\u00020\u00062\b\b\u0002\u0010&\u001a\u00020\u001dJ\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/containers/SSLGenericContainer;", "config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "localServiceIp", "Lkotlin/Function0;", "", "envoyControl1XdsPort", "", "envoyControl2XdsPort", "logLevel", "image", "wrapperServiceIp", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;Lkotlin/jvm/functions/Function0;IILjava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "addDnsEntry", "", "host", "ip", "addIptablesRedirect", "redirectToPort", "destinationPort", "admin", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin;", "adminUrl", "callInContainer", "Lorg/testcontainers/containers/Container$ExecResult;", "hostname", "path", "isHttps", "", "cleanIptables", "configure", "containerIsStarting", "containerInfo", "Lcom/github/dockerjava/api/command/InspectContainerResponse;", "egressListenerUrl", "ingressHost", "ingressListenerUrl", "secured", "removeDnsEntry", "Companion", "envoy-control-tests"})
public final class EnvoyContainer
extends SSLGenericContainer<EnvoyContainer> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final EnvoyConfig config;
    @NotNull
    private final Function0<String> localServiceIp;
    private final int envoyControl1XdsPort;
    private final int envoyControl2XdsPort;
    @NotNull
    private final String logLevel;
    @NotNull
    private final Function0<String> wrapperServiceIp;
    @NotNull
    private static final Lazy<Logger> logger$delegate;
    @NotNull
    private static final String CONFIG_DEST = "/etc/envoy/envoy.yaml";
    @NotNull
    private static final String LAUNCH_ENVOY_SCRIPT = "envoy/launch_envoy.sh";
    @NotNull
    private static final String LAUNCH_ENVOY_SCRIPT_DEST = "/usr/local/bin/launch_envoy.sh";
    @NotNull
    private static final String EXTRA_DIR = "envoy/extra";
    @NotNull
    private static final String EXTRA_DIR_DEST = "/etc/envoy/extra";
    @NotNull
    public static final String ENVOY_UID_ENV_NAME = "ENVOY_UID";
    public static final int EGRESS_LISTENER_CONTAINER_PORT = 5000;
    public static final int INGRESS_LISTENER_CONTAINER_PORT = 5001;
    private static final int ADMIN_PORT = 10000;
    @NotNull
    private static final String MIN_SUPPORTED_ENVOY_VERSION = "v1.30.4";
    @NotNull
    private static final String MAX_SUPPORTED_ENVOY_VERSION = "v1.34.0";
    @NotNull
    private static final String DEFAULT_IMAGE;

    public EnvoyContainer(@NotNull EnvoyConfig config, @NotNull Function0<String> localServiceIp, int envoyControl1XdsPort, int envoyControl2XdsPort, @NotNull String logLevel, @NotNull String image, @NotNull Function0<String> wrapperServiceIp) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(localServiceIp, (String)"localServiceIp");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(wrapperServiceIp, (String)"wrapperServiceIp");
        RunStatementTrait runStatementTrait = ((DockerfileBuilder)((DockerfileBuilder)new DockerfileBuilder().from(image)).run("apt-get update && apt-get install -y curl iproute2 iptables dnsmasq")).run("adduser --disabled-password --gecos \"\" test");
        Intrinsics.checkNotNullExpressionValue((Object)runStatementTrait, (String)"run(...)");
        super((DockerfileBuilder)runStatementTrait, null, null, 6, null);
        this.config = config;
        this.localServiceIp = localServiceIp;
        this.envoyControl1XdsPort = envoyControl1XdsPort;
        this.envoyControl2XdsPort = envoyControl2XdsPort;
        this.logLevel = logLevel;
        this.wrapperServiceIp = wrapperServiceIp;
    }

    public /* synthetic */ EnvoyContainer(EnvoyConfig envoyConfig, Function0 function0, int n, int n2, String string, String string2, Function0 function02, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = n;
        }
        if ((n3 & 0x10) != 0) {
            string = "info";
        }
        if ((n3 & 0x20) != 0) {
            string2 = DEFAULT_IMAGE;
        }
        if ((n3 & 0x40) != 0) {
            function02 = 1.INSTANCE;
        }
        this(envoyConfig, (Function0<String>)function0, n, n2, string, string2, (Function0<String>)function02);
    }

    @Override
    protected void configure() {
        super.configure();
        this.withClasspathResourceMapping(LAUNCH_ENVOY_SCRIPT, LAUNCH_ENVOY_SCRIPT_DEST, BindMode.READ_ONLY);
        this.withClasspathResourceMapping(this.config.getFilePath(), CONFIG_DEST, BindMode.READ_ONLY);
        if (new ClassPathResource(EXTRA_DIR).exists()) {
            this.withClasspathResourceMapping(EXTRA_DIR, EXTRA_DIR_DEST, BindMode.READ_ONLY);
        }
        this.withEnv(ENVOY_UID_ENV_NAME, "0");
        Object[] objectArray = new Integer[]{5000, 5001, 10000};
        this.withExposedPorts((Integer[])objectArray);
        this.withPrivilegedMode(true);
        objectArray = new String[]{"/bin/sh", LAUNCH_ENVOY_SCRIPT_DEST, String.valueOf(this.envoyControl1XdsPort), String.valueOf(this.envoyControl2XdsPort), CONFIG_DEST, this.localServiceIp.invoke(), this.config.getTrustedCa(), this.config.getCertificateChain(), this.config.getPrivateKey(), this.config.getServiceName(), this.wrapperServiceIp.invoke(), "--config-yaml", this.config.getConfigOverride(), "-l", this.logLevel};
        this.withCommand((String[])objectArray);
    }

    public final void addIptablesRedirect(int redirectToPort, int destinationPort) {
        String[] stringArray = new String[]{"sh", "-c", "iptables -t nat -A OUTPUT -p tcp -m tcp --dport " + destinationPort + " -m owner --uid-owner 0 -j RETURN"};
        this.execInContainer(stringArray);
        stringArray = new String[]{"sh", "-c", "iptables -t nat -A OUTPUT -p tcp -m tcp --dport " + destinationPort + " -m owner --gid-owner 0 -j RETURN"};
        this.execInContainer(stringArray);
        stringArray = new String[]{"sh", "-c", "iptables -t nat -A OUTPUT -p tcp --dport " + destinationPort + " -j REDIRECT --to-ports " + redirectToPort};
        this.execInContainer(stringArray);
    }

    public final void cleanIptables() {
        String[] stringArray = new String[]{"sh", "-c", "iptables -t nat -F"};
        this.execInContainer(stringArray);
    }

    @Nullable
    public final Container.ExecResult callInContainer(@NotNull String hostname2, @NotNull String path, boolean isHttps) {
        Intrinsics.checkNotNullParameter((Object)hostname2, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (isHttps) {
            String[] stringArray = new String[]{"su", "test", "-c", "curl https://" + hostname2 + "/" + path + " --insecure"};
            return this.execInContainer(stringArray);
        }
        String[] stringArray = new String[]{"su", "test", "-c", "curl http://" + hostname2 + "/" + path};
        return this.execInContainer(stringArray);
    }

    public static /* synthetic */ Container.ExecResult callInContainer$default(EnvoyContainer envoyContainer, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return envoyContainer.callInContainer(string, string2, bl);
    }

    public final void addDnsEntry(@NotNull String host, @NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"sh", "-c", "echo address=/" + host + "/" + ip + " >> /etc/dnsmasq.conf"};
        this.execInContainer(stringArray);
        stringArray = new String[]{"sh", "-c", "/etc/init.d/dnsmasq restart"};
        this.execInContainer(stringArray);
    }

    public final void removeDnsEntry(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String[] stringArray = new String[]{"sh", "-c", "sed -i 's/.*" + host + ".*//' /etc/dnsmasq.conf"};
        this.execInContainer(stringArray);
        stringArray = new String[]{"sh", "-c", "/etc/init.d/dnsmasq restart"};
        this.execInContainer(stringArray);
    }

    @Override
    protected void containerIsStarting(@Nullable InspectContainerResponse containerInfo) {
        this.followOutput((Consumer)new Slf4jLogConsumer(Companion.getLogger()).withPrefix("ENVOY"));
        super.containerIsStarting(containerInfo);
    }

    @NotNull
    public final String egressListenerUrl() {
        return "http://" + this.getContainerIpAddress() + ":" + this.getMappedPort(5000) + "/";
    }

    @NotNull
    public final String ingressListenerUrl(boolean secured) {
        String schema = secured ? "https" : "http";
        return schema + "://" + this.getContainerIpAddress() + ":" + this.getMappedPort(5001);
    }

    public static /* synthetic */ String ingressListenerUrl$default(EnvoyContainer envoyContainer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return envoyContainer.ingressListenerUrl(bl);
    }

    @NotNull
    public final String adminUrl() {
        return "http://" + this.getContainerIpAddress() + ":" + this.getMappedPort(10000);
    }

    @NotNull
    public final EnvoyAdmin admin() {
        return new EnvoyAdmin(this.adminUrl(), null, 2, null);
    }

    @NotNull
    public final String ingressHost() {
        return StringsKt.removePrefix((String)EnvoyContainer.ingressListenerUrl$default(this, false, 1, null), (CharSequence)"http://");
    }

    /*
     * Unable to fully structure code
     */
    static {
        block7: {
            EnvoyContainer.Companion = new Companion(null);
            EnvoyContainer.logger$delegate = LoggerKt.logger((Object)EnvoyContainer.Companion);
            $this$DEFAULT_IMAGE_u24lambda_u240 = EnvoyContainer.Companion;
            $i$a$-run-EnvoyContainer$Companion$DEFAULT_IMAGE$1 = false;
            v0 = System.getProperty("pl.allegro.tech.servicemesh.envoyVersion");
            if (v0 == null) {
                v0 = "";
            }
            versionArg = v0;
            switch (versionArg.hashCode()) {
                case 0: {
                    if (!versionArg.equals("")) {
                        ** break;
                    }
                    ** GOTO lbl19
                }
                case 108114: {
                    if (versionArg.equals("min")) break;
                    ** break;
                }
                case 107876: {
                    if (!versionArg.equals("max")) ** break;
lbl19:
                    // 2 sources

                    v1 = "v1.34.0";
                    break block7;
                }
            }
            v1 = "v1.30.4";
            break block7;
lbl23:
            // 4 sources

            v1 = var2_2;
        }
        version = v1;
        $this$DEFAULT_IMAGE_u24lambda_u240.getLogger().info("Using envoy version: " + (String)version);
        EnvoyContainer.DEFAULT_IMAGE = "envoyproxy/envoy:" + (String)version;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer$Companion;", "", "()V", "ADMIN_PORT", "", "CONFIG_DEST", "", "DEFAULT_IMAGE", "getDEFAULT_IMAGE", "()Ljava/lang/String;", "EGRESS_LISTENER_CONTAINER_PORT", "ENVOY_UID_ENV_NAME", "EXTRA_DIR", "EXTRA_DIR_DEST", "INGRESS_LISTENER_CONTAINER_PORT", "LAUNCH_ENVOY_SCRIPT", "LAUNCH_ENVOY_SCRIPT_DEST", "MAX_SUPPORTED_ENVOY_VERSION", "MIN_SUPPORTED_ENVOY_VERSION", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final String getDEFAULT_IMAGE() {
            return DEFAULT_IMAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

