/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.envoy;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyAdmin;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.BeforeAndAfterAllOnce;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.ContainerExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\u001f\u0010\"\u001a\u00020\u001c2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%J\u0016\u0010*\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%J\u001f\u0010+\u001a\u00020\u001c2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%\u00a2\u0006\u0002\u0010&J\u001f\u0010,\u001a\u00020\u001c2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$\"\u00020%\u00a2\u0006\u0002\u0010&J\b\u0010-\u001a\u00020\u001cH\u0014R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtensionBase;", "localService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;", "config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "wrapperService", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtensionBase;Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;Lpl/allegro/tech/servicemesh/envoycontrol/config/service/ServiceExtension;)V", "container", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "getContainer", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "ctx", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/BeforeAndAfterAllOnce$Context;", "getCtx", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/BeforeAndAfterAllOnce$Context;", "egressOperations", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EgressOperations;", "getEgressOperations", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EgressOperations;", "ingressOperations", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/IngressOperations;", "getIngressOperations", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/IngressOperations;", "afterEach", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "preconditions", "recordRBACLogs", "stopRecordingRBAC", "waitForAvailableEndpoints", "serviceNames", "", "", "([Ljava/lang/String;)V", "waitForClusterEndpointHealthy", "cluster", "endpointIp", "waitForClusterEndpointNotHealthy", "waitForNoAvailableEndpoints", "waitForReadyServices", "waitUntilHealthy", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nEnvoyExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvoyExtension.kt\npl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,128:1\n13309#2,2:129\n13309#2,2:131\n13309#2,2:133\n*S KotlinDebug\n*F\n+ 1 EnvoyExtension.kt\npl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension\n*L\n61#1:129,2\n72#1:131,2\n81#1:133,2\n*E\n"})
public final class EnvoyExtension
extends ContainerExtension
implements AfterEachCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvoyControlExtensionBase envoyControl;
    @Nullable
    private final ServiceExtension<?> localService;
    @Nullable
    private final ServiceExtension<?> wrapperService;
    @NotNull
    private final EnvoyContainer container;
    @NotNull
    private final IngressOperations ingressOperations;
    @NotNull
    private final EgressOperations egressOperations;
    @NotNull
    private final BeforeAndAfterAllOnce.Context ctx;
    @NotNull
    private static final Lazy<Logger> logger$delegate = LoggerKt.logger((Object)Companion);

    public EnvoyExtension(@NotNull EnvoyControlExtensionBase envoyControl4, @Nullable ServiceExtension<?> localService, @NotNull EnvoyConfig config, @Nullable ServiceExtension<?> wrapperService) {
        Intrinsics.checkNotNullParameter((Object)envoyControl4, (String)"envoyControl");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.envoyControl = envoyControl4;
        this.localService = localService;
        this.wrapperService = wrapperService;
        GenericContainer genericContainer = new EnvoyContainer(config, (Function0)new Function0<String>(this){
            final /* synthetic */ EnvoyExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object = EnvoyExtension.access$getLocalService$p(this.this$0);
                if (object == null || (object = object.container()) == null || (object = object.ipAddress()) == null) {
                    object = "127.0.0.1";
                }
                return object;
            }
        }, this.envoyControl.getApp().getGrpcPort(), 0, null, null, (Function0)new Function0<String>(this){
            final /* synthetic */ EnvoyExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object = EnvoyExtension.access$getWrapperService$p(this.this$0);
                if (object == null || (object = object.container()) == null || (object = object.ipAddress()) == null) {
                    object = "127.0.0.1";
                }
                return object;
            }
        }, 56, null).withNetwork(Network.SHARED);
        Intrinsics.checkNotNullExpressionValue((Object)genericContainer, (String)"withNetwork(...)");
        this.container = (EnvoyContainer)genericContainer;
        this.ingressOperations = new IngressOperations(this.getContainer());
        this.egressOperations = new EgressOperations(this.getContainer());
        this.ctx = new BeforeAndAfterAllOnce.Context(null, false, 3, null);
    }

    public /* synthetic */ EnvoyExtension(EnvoyControlExtensionBase envoyControlExtensionBase, ServiceExtension serviceExtension, EnvoyConfig envoyConfig, ServiceExtension serviceExtension2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serviceExtension = null;
        }
        if ((n & 4) != 0) {
            envoyConfig = EnvoyControlTestConfigurationKt.getRandomConfigFile();
        }
        if ((n & 8) != 0) {
            serviceExtension2 = null;
        }
        this(envoyControlExtensionBase, serviceExtension, envoyConfig, serviceExtension2);
    }

    @NotNull
    public EnvoyContainer getContainer() {
        return this.container;
    }

    @NotNull
    public final IngressOperations getIngressOperations() {
        return this.ingressOperations;
    }

    @NotNull
    public final EgressOperations getEgressOperations() {
        return this.egressOperations;
    }

    @Override
    protected void preconditions(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ServiceExtension<?> serviceExtension = this.localService;
        if (serviceExtension != null) {
            serviceExtension.beforeAll(context);
        }
        ServiceExtension<?> serviceExtension2 = this.wrapperService;
        if (serviceExtension2 != null) {
            serviceExtension2.beforeAll(context);
        }
        this.envoyControl.beforeAll(context);
    }

    @Override
    protected void waitUntilHealthy() {
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> EnvoyExtension.waitUntilHealthy$lambda$0(this));
    }

    @Override
    @NotNull
    public BeforeAndAfterAllOnce.Context getCtx() {
        return this.ctx;
    }

    public void afterEach(@Nullable ExtensionContext context) {
        this.getContainer().admin().resetCounters();
    }

    public final void waitForReadyServices(String ... serviceNames) {
        Intrinsics.checkNotNullParameter((Object)serviceNames, (String)"serviceNames");
        String[] $this$forEach$iv = serviceNames;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(this, it){
                final /* synthetic */ EnvoyExtension this$0;
                final /* synthetic */ String $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Response response2;
                    Response it = response2 = EgressOperations.callService$default(this.this$0.getEgressOperations(), this.$it, null, null, null, null, 30, null);
                    boolean bl = false;
                    ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                    Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                    ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                }
            }, 3, null);
        }
    }

    public final void waitForAvailableEndpoints(String ... serviceNames) {
        Intrinsics.checkNotNullParameter((Object)serviceNames, (String)"serviceNames");
        EnvoyAdmin admin = this.getContainer().admin();
        String[] $this$forEach$iv = serviceNames;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(admin, it){
                final /* synthetic */ EnvoyAdmin $admin;
                final /* synthetic */ String $it;
                {
                    this.$admin = $admin;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Assertions.assertThat((int)this.$admin.numOfEndpoints(this.$it)).isGreaterThan(0);
                }
            }, 3, null);
        }
    }

    public final void waitForNoAvailableEndpoints(String ... serviceNames) {
        Intrinsics.checkNotNullParameter((Object)serviceNames, (String)"serviceNames");
        EnvoyAdmin admin = this.getContainer().admin();
        String[] $this$forEach$iv = serviceNames;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>(admin, it){
                final /* synthetic */ EnvoyAdmin $admin;
                final /* synthetic */ String $it;
                {
                    this.$admin = $admin;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    Assertions.assertThat((int)this.$admin.numOfEndpoints(this.$it)).isEqualTo(0);
                }
            }, 3, null);
        }
    }

    public final void waitForClusterEndpointHealthy(@NotNull String cluster, @NotNull String endpointIp) {
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)endpointIp, (String)"endpointIp");
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractBooleanAssert<?>>(this, cluster, endpointIp){
            final /* synthetic */ EnvoyExtension this$0;
            final /* synthetic */ String $cluster;
            final /* synthetic */ String $endpointIp;
            {
                this.this$0 = $receiver;
                this.$cluster = $cluster;
                this.$endpointIp = $endpointIp;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.this$0.getContainer().admin().isEndpointHealthy(this.$cluster, this.$endpointIp)).withFailMessage(() -> waitForClusterEndpointHealthy.1.invoke$lambda$0(this.$cluster, this.$endpointIp, this.this$0))).isTrue();
            }

            private static final String invoke$lambda$0(String $cluster, String $endpointIp, EnvoyExtension this$0) {
                Intrinsics.checkNotNullParameter((Object)$cluster, (String)"$cluster");
                Intrinsics.checkNotNullParameter((Object)$endpointIp, (String)"$endpointIp");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return "Expected to see healthy endpoint of cluster '" + $cluster + "' with address '" + $endpointIp + "' in envoy " + this$0.getContainer().adminUrl() + "/clusters, but it's not present. Found following endpoints: " + this$0.getContainer().admin().endpointsAddress($cluster);
            }
        }, 1, null);
    }

    public final void waitForClusterEndpointNotHealthy(@NotNull String cluster, @NotNull String endpointIp) {
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)endpointIp, (String)"endpointIp");
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractBooleanAssert<?>>(this, cluster, endpointIp){
            final /* synthetic */ EnvoyExtension this$0;
            final /* synthetic */ String $cluster;
            final /* synthetic */ String $endpointIp;
            {
                this.this$0 = $receiver;
                this.$cluster = $cluster;
                this.$endpointIp = $endpointIp;
                super(0);
            }

            public final AbstractBooleanAssert<?> invoke() {
                return ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.this$0.getContainer().admin().isEndpointHealthy(this.$cluster, this.$endpointIp)).withFailMessage(() -> waitForClusterEndpointNotHealthy.1.invoke$lambda$0(this.$cluster, this.$endpointIp, this.this$0))).isFalse();
            }

            private static final String invoke$lambda$0(String $cluster, String $endpointIp, EnvoyExtension this$0) {
                Intrinsics.checkNotNullParameter((Object)$cluster, (String)"$cluster");
                Intrinsics.checkNotNullParameter((Object)$endpointIp, (String)"$endpointIp");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return "Expected to not see endpoint of cluster '" + $cluster + "' with address '" + $endpointIp + "' in envoy " + this$0.getContainer().adminUrl() + "/clusters, but it's still present. Found following endpoints: " + this$0.getContainer().admin().endpointsAddress($cluster);
            }
        }, 1, null);
    }

    public final void recordRBACLogs() {
        this.getContainer().getLogRecorder().recordLogs((Function1<? super String, Boolean>)((Function1)recordRBACLogs.1.INSTANCE));
    }

    public final void stopRecordingRBAC() {
        this.getContainer().getLogRecorder().stopRecording();
    }

    private static final void waitUntilHealthy$lambda$0(EnvoyExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Assertions.assertThat((boolean)this$0.getContainer().admin().isIngressReady());
    }

    public static final /* synthetic */ ServiceExtension access$getLocalService$p(EnvoyExtension $this) {
        return $this.localService;
    }

    public static final /* synthetic */ ServiceExtension access$getWrapperService$p(EnvoyExtension $this) {
        return $this.wrapperService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

