/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.envoy;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.HttpResponseCloser;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ*\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0017R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u000e\u0010\b\u00a8\u0006!"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/IngressOperations;", "", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;)V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "getEnvoy", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyContainer;", "insecureClient", "getInsecureClient", "insecureClient$delegate", "callLocalService", "Lokhttp3/Response;", "endpoint", "", "headers", "Lokhttp3/Headers;", "useTls", "", "callLocalServiceInsecure", "callPostLocalService", "body", "Lokhttp3/RequestBody;", "callServiceWithOriginalDst", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "path", "serviceName", "envoy-control-tests"})
public final class IngressOperations {
    @NotNull
    private final EnvoyContainer envoy;
    @NotNull
    private final Lazy client$delegate;
    @NotNull
    private final Lazy insecureClient$delegate;

    public IngressOperations(@NotNull EnvoyContainer envoy) {
        Intrinsics.checkNotNullParameter((Object)((Object)envoy), (String)"envoy");
        this.envoy = envoy;
        this.client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);
        this.insecureClient$delegate = LazyKt.lazy((Function0)insecureClient.2.INSTANCE);
    }

    @NotNull
    public final EnvoyContainer getEnvoy() {
        return this.envoy;
    }

    private final OkHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    private final OkHttpClient getInsecureClient() {
        Lazy lazy = this.insecureClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @NotNull
    public final Response callLocalService(@NotNull String endpoint, @NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return IngressOperations.callLocalService$default(this, endpoint, headers, this.getClient(), false, 8, null);
    }

    public static /* synthetic */ Response callLocalService$default(IngressOperations ingressOperations, String string, Headers headers, int n, Object object) {
        if ((n & 2) != 0) {
            headers = Headers.Companion.of(new String[0]);
        }
        return ingressOperations.callLocalService(string, headers);
    }

    @NotNull
    public final Response callLocalServiceInsecure(@NotNull String endpoint, @NotNull Headers headers, boolean useTls) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        return this.callLocalService(endpoint, headers, this.getInsecureClient(), useTls);
    }

    public static /* synthetic */ Response callLocalServiceInsecure$default(IngressOperations ingressOperations, String string, Headers headers, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            headers = Headers.Companion.of(new String[0]);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return ingressOperations.callLocalServiceInsecure(string, headers, bl);
    }

    @NotNull
    public final Response callPostLocalService(@NotNull String endpoint, @NotNull Headers headers, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(this.getClient().newCall(new Request.Builder().post(body).headers(headers).url(EnvoyContainer.ingressListenerUrl$default(this.envoy, false, 1, null) + endpoint).build()).execute());
    }

    @NotNull
    public final Response callServiceWithOriginalDst(@NotNull EchoServiceExtension service, @NotNull String path, @NotNull String serviceName, boolean useTls) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"x-envoy-original-dst-host", (Object)service.container().address()), TuplesKt.to((Object)"host", (Object)"envoy-original-destination"), TuplesKt.to((Object)"x-service-name", (Object)serviceName)};
        return this.callLocalServiceInsecure(path, Headers.Companion.of(MapsKt.mapOf((Pair[])pairArray)), useTls);
    }

    public static /* synthetic */ Response callServiceWithOriginalDst$default(IngressOperations ingressOperations, EchoServiceExtension echoServiceExtension, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return ingressOperations.callServiceWithOriginalDst(echoServiceExtension, string, string2, bl);
    }

    private final Response callLocalService(String endpoint, Headers headers, OkHttpClient client2, boolean useTls) {
        return HttpResponseCloser.INSTANCE.addToCloseableResponses(client2.newCall(new Request.Builder().get().headers(headers).url(this.envoy.ingressListenerUrl(useTls) + endpoint).build()).execute());
    }

    static /* synthetic */ Response callLocalService$default(IngressOperations ingressOperations, String string, Headers headers, OkHttpClient okHttpClient, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return ingressOperations.callLocalService(string, headers, okHttpClient, bl);
    }
}

