/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.dockerfile.statement.Statement;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.CommandFailedException;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.ContainerUnableToObtainHostIpException;
import pl.allegro.tech.servicemesh.envoycontrol.config.testcontainers.LogRecorder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 7*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\b\u0016\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\u0012\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0007J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010%\u001a\n '*\u0004\u0018\u00010&0&J\u0019\u0010(\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0007H\u0002J\b\u0010.\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u00020\u0014H\u0016J\u000e\u00100\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007J+\u00101\u001a\u00028\u00002\b\u00102\u001a\u0004\u0018\u00010\u00072\b\u00103\u001a\u0004\u0018\u00010\u00072\b\u00104\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00068"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "SELF", "Lorg/testcontainers/containers/GenericContainer;", "image", "Lorg/testcontainers/images/builder/ImageFromDockerfile;", "(Lorg/testcontainers/images/builder/ImageFromDockerfile;)V", "dockerImageName", "", "(Ljava/lang/String;)V", "statements", "", "Lorg/testcontainers/images/builder/dockerfile/statement/Statement;", "(Ljava/util/List;)V", "HOST_IP_SCRIPT", "HOST_IP_SCRIPT_DEST", "logRecorder", "Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/LogRecorder;", "getLogRecorder", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/LogRecorder;", "addHost", "", "host", "ip", "blockTrafficTo", "clearAllIptablesRules", "configure", "containerIsStarting", "containerInfo", "Lcom/github/dockerjava/api/command/InspectContainerResponse;", "containerName", "gatewayIp", "hostIp", "ipAddress", "notAlreadyMounted", "", "destination", "removeHost", "restart", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "runCommands", "commands", "", "([Ljava/lang/String;)V", "sendSignal", "signal", "sigcont", "sigstop", "unblockTrafficTo", "withClasspathResourceMapping", "resourcePath", "containerPath", "mode", "Lorg/testcontainers/containers/BindMode;", "(Ljava/lang/String;Ljava/lang/String;Lorg/testcontainers/containers/BindMode;)Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer;", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nGenericContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericContainer.kt\npl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,159:1\n2624#2,3:160\n1855#2,2:167\n13309#3:163\n13310#3:166\n37#4,2:164\n*S KotlinDebug\n*F\n+ 1 GenericContainer.kt\npl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer\n*L\n61#1:160,3\n15#1:167,2\n125#1:163\n125#1:166\n126#1:164,2\n*E\n"})
public class GenericContainer<SELF extends GenericContainer<SELF>>
extends org.testcontainers.containers.GenericContainer<SELF> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogRecorder logRecorder;
    @NotNull
    private final String HOST_IP_SCRIPT;
    @NotNull
    private final String HOST_IP_SCRIPT_DEST;
    @NotNull
    public static final String allInterfaces = "0.0.0.0";

    public GenericContainer(@NotNull ImageFromDockerfile image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super((Future)image);
        this.logRecorder = new LogRecorder();
        this.HOST_IP_SCRIPT = "testcontainers/host_ip.sh";
        this.HOST_IP_SCRIPT_DEST = "/usr/local/bin/host_ip.sh";
    }

    public GenericContainer(@NotNull String dockerImageName) {
        Intrinsics.checkNotNullParameter((Object)dockerImageName, (String)"dockerImageName");
        super(dockerImageName);
        this.logRecorder = new LogRecorder();
        this.HOST_IP_SCRIPT = "testcontainers/host_ip.sh";
        this.HOST_IP_SCRIPT_DEST = "/usr/local/bin/host_ip.sh";
    }

    public GenericContainer(@NotNull List<? extends Statement> statements) {
        Intrinsics.checkNotNullParameter(statements, (String)"statements");
        super((Future)new ImageFromDockerfile().withDockerfileFromBuilder(arg_0 -> GenericContainer._init_$lambda$1(statements, arg_0)));
        this.logRecorder = new LogRecorder();
        this.HOST_IP_SCRIPT = "testcontainers/host_ip.sh";
        this.HOST_IP_SCRIPT_DEST = "/usr/local/bin/host_ip.sh";
    }

    @NotNull
    public final LogRecorder getLogRecorder() {
        return this.logRecorder;
    }

    protected void configure() {
        super.configure();
        this.withClasspathResourceMapping(this.HOST_IP_SCRIPT, this.HOST_IP_SCRIPT_DEST, BindMode.READ_ONLY);
    }

    @NotNull
    public SELF withClasspathResourceMapping(@Nullable String resourcePath, @Nullable String containerPath, @Nullable BindMode mode) {
        GenericContainer genericContainer;
        if (this.notAlreadyMounted(containerPath)) {
            org.testcontainers.containers.GenericContainer genericContainer2 = super.withClasspathResourceMapping(resourcePath, containerPath, mode);
            Intrinsics.checkNotNull((Object)genericContainer2);
            genericContainer = (GenericContainer)genericContainer2;
        } else {
            Container container2 = this.self();
            Intrinsics.checkNotNull((Object)container2);
            genericContainer = (GenericContainer)container2;
        }
        return (SELF)((Object)genericContainer);
    }

    protected void containerIsStarting(@Nullable InspectContainerResponse containerInfo) {
        this.followOutput((Consumer)((Object)this.logRecorder));
    }

    public final void addHost(@NotNull String host, @NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"sh", "-c", "echo \"" + ip + "\t" + host + "\" >> /etc/hosts"};
        this.execInContainer(stringArray);
    }

    public final void removeHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String[] stringArray = new String[]{"sh", "-c", "grep -v '[[:blank:]]" + host + "$' /etc/hosts > /tmp/hosts"};
        this.execInContainer(stringArray);
        stringArray = new String[]{"sh", "-c", "cat /tmp/hosts > /etc/hosts"};
        this.execInContainer(stringArray);
    }

    public final boolean notAlreadyMounted(@Nullable String destination) {
        boolean bl;
        block3: {
            List list = this.getBinds();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBinds(...)");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Bind it = (Bind)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVolume().getPath(), (Object)destination)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final String hostIp() {
        String[] stringArray = new String[]{this.HOST_IP_SCRIPT_DEST};
        Container.ExecResult result = this.execInContainer(stringArray);
        String string = result.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
        boolean bl = ((CharSequence)string).length() > 0;
        String string2 = result.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
        if (bl | ((CharSequence)string2).length() == 0) {
            throw new ContainerUnableToObtainHostIpException("stderr: " + result.getStderr());
        }
        String string3 = result.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStdout(...)");
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @NotNull
    public final String ipAddress() {
        Map map = this.getContainerInfo().getNetworkSettings().getNetworks();
        Network network = this.getNetwork();
        Intrinsics.checkNotNull((Object)network, (String)"null cannot be cast to non-null type org.testcontainers.containers.Network.NetworkImpl");
        Object v = map.get(((Network.NetworkImpl)network).getName());
        Intrinsics.checkNotNull(v);
        String string = ((ContainerNetwork)v).getIpAddress();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String gatewayIp() {
        Map map = this.getContainerInfo().getNetworkSettings().getNetworks();
        Network network = this.getNetwork();
        Intrinsics.checkNotNull((Object)network, (String)"null cannot be cast to non-null type org.testcontainers.containers.Network.NetworkImpl");
        Object v = map.get(((Network.NetworkImpl)network).getName());
        Intrinsics.checkNotNull(v);
        String string = ((ContainerNetwork)v).getGateway();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public void sigstop() {
        this.sendSignal("STOP");
    }

    public void sigcont() {
        this.sendSignal("CONT");
    }

    public final void blockTrafficTo(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"iptables -A INPUT -s " + ip + " -j DROP", "iptables -A OUTPUT -d " + ip + " -j DROP"};
        this.runCommands(stringArray);
    }

    public final void unblockTrafficTo(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String[] stringArray = new String[]{"iptables -D INPUT -s " + ip + " -j DROP", "iptables -D OUTPUT -d " + ip + " -j DROP"};
        this.runCommands(stringArray);
    }

    public final void clearAllIptablesRules() {
        String[] stringArray = new String[]{"iptables -t nat -F", "iptables -t mangle -F", "iptables -F", "iptables -X"};
        this.runCommands(stringArray);
    }

    public final void runCommands(@NotNull String[] commands) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        String[] $this$forEach$iv = commands;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String command = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)command, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            Container.ExecResult result = this.execInContainer(Arrays.copyOf(stringArray2, stringArray2.length));
            if (result.getExitCode() == 0) continue;
            int n2 = result.getExitCode();
            String string = result.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String string2 = result.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
            throw new CommandFailedException(command, n2, string, string2, this.containerName());
        }
    }

    public final Void restart() {
        return this.dockerClient.restartContainerCmd(this.getContainerId()).exec();
    }

    private final void sendSignal(String signal) {
        this.getDockerClient().killContainerCmd(this.getContainerId()).withSignal(signal).exec();
    }

    @NotNull
    public final String containerName() {
        String string = this.getContainerId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContainerId(...)");
        String string2 = string;
        int n = 0;
        int n2 = 12;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    private static final void _init_$lambda$1(List $statements, DockerfileBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)$statements, (String)"$statements");
        Iterable $this$forEach$iv = $statements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Statement it = (Statement)element$iv;
            boolean bl = false;
            builder.withStatement(it);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/config/testcontainers/GenericContainer$Companion;", "", "()V", "allInterfaces", "", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

