/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.EnvoyAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.IngressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.IncomingPermissionsOriginalDestinationTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsOriginalDestinationTest;", "", "()V", "beforeEach", "", "cleanupTest", "should allow direct request when using orginal destination and echo service is specified as client", "should block direct request when using orginal destination and echo service is not specified as client", "waitForEnvoysInitialized", "Companion", "envoy-control-tests"})
public final class IncomingPermissionsOriginalDestinationTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String echoYaml = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints:\n        - path: \"/allowed-echo\"\n          unlistedClientsPolicy: blockAndLog\n          clients: [echo, envoy-original-destination]\n        - path: \"/blocked-echo\"\n          unlistedClientsPolicy: blockAndLog\n          clients: [echo2]\n      outgoing:\n        dependencies:\n          - service: \"echo\"\n          - service: \"echo2\"";
    @NotNull
    private static final EnvoyConfig echoConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, echoYaml, null, null, null, 59, null);
    @NotNull
    private static final EnvoyConfig failingEchoConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @NotNull
    private static final String prefix = "envoy-control.envoy.snapshot";
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension echoService2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echoEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;

    @BeforeEach
    public final void beforeEach() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echoEnvoy, null, "echo", false, CollectionsKt.listOf((Object)"mtls:enabled"), 10, null);
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), echo2Envoy, null, "echo2", false, CollectionsKt.listOf((Object)"mtls:enabled"), 10, null);
        this.waitForEnvoysInitialized();
        echoEnvoy.recordRBACLogs();
        echo2Envoy.recordRBACLogs();
    }

    private final void waitForEnvoysInitialized() {
        AwaitAssertionsKt.untilAsserted$default(null, null, waitForEnvoysInitialized.1.INSTANCE, 3, null);
    }

    @AfterEach
    public final void cleanupTest() {
        echoEnvoy.stopRecordingRBAC();
        echo2Envoy.stopRecordingRBAC();
    }

    @Test
    public final void should allow direct request when using orginal destination and echo service is specified as client() {
        Response response2 = echo2Envoy.getIngressOperations().callServiceWithOriginalDst(echoService2, "/allowed-echo", "echo", true);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoService2);
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
        EnvoyAssertionsKt.hasNoRBACDenials((ObjectAssert<EnvoyContainer>)objectAssert2);
    }

    @Test
    public final void should block direct request when using orginal destination and echo service is not specified as client() {
        Response response2 = IngressOperations.callServiceWithOriginalDst$default(echo2Envoy.getIngressOperations(), echoService2, "/blocked-echo", "echo", false, 8, null);
        ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
        ObjectAssert objectAssert2 = Assertions.assertThat((Object)((Object)echo2Envoy.getContainer()));
        String string = StringsKt.replaceAfterLast$default((String)echoEnvoy.getContainer().ipAddress(), (String)".", (String)"1", null, (int)4, null);
        Intrinsics.checkNotNull((Object)objectAssert2);
        EnvoyAssertionsKt.hasOneAccessDenialWithActionBlock$default(objectAssert2, "http", "/blocked-echo", "GET", "echo", false, "envoy-original-destination", string, false, 128, null);
    }

    static {
        Object object = EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig();
        Object object2 = echoYaml;
        failingEchoConfig = EnvoyConfig.copy$default((EnvoyConfig)object, null, "failing-echo", (String)object2, null, null, null, 57, null);
        consul = new ConsulExtension(false, 1, null);
        object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.outgoing-permissions.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.status.create-virtual-cluster", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        echoService = new EchoServiceExtension();
        echoService2 = new EchoServiceExtension();
        object = envoyControl;
        object2 = echoConfig;
        EchoServiceExtension echoServiceExtension = echoService;
        echoEnvoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, (EnvoyConfig)object2, null, 8, null);
        object = envoyControl;
        object2 = failingEchoConfig;
        echoServiceExtension = echoService2;
        echo2Envoy = new EnvoyExtension((EnvoyControlExtensionBase)object, echoServiceExtension, (EnvoyConfig)object2, null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/IncomingPermissionsOriginalDestinationTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "echo2Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echoConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echoEnvoy", "echoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "echoService2", "echoYaml", "", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "failingEchoConfig", "prefix", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

