/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.permissions;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.ClientsFactory;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.permissions.TlsBasedAuthenticationTest;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.EndpointMatch;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\u000eH\u0007J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u0016\u001a\u00020\u000eH\u0007\u00a8\u0006\u0018"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/TlsBasedAuthenticationTest;", "", "()V", "callEcho2", "Lokhttp3/Response;", "from", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "callEcho2FromEcho1", "callEcho2IngressUsingClientWithoutCertificate", "callEcho3FromEcho1", "callEcho3FromEcho2", "callEcho3FromEchoWithDifferentCa", "callEcho3FromEchoWithNotTrustingDefaultCa", "client should reject server certificate signed by not trusted CA", "", "server should reject client certificate signed by not trusted CA", "setup", "should allow client with wildcard in incoming permissions to be called from all authenticated clients", "should encrypt traffic between selected services", "should encrypt traffic between selected services even if only one endpoint supports mtls", "should not allow traffic that fails client SAN validation", "should not allow traffic that fails server SAN validation", "should reject client without a certificate during RBAC verification", "Companion", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nTlsBasedAuthenticationTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsBasedAuthenticationTest.kt\npl/allegro/tech/servicemesh/envoycontrol/permissions/TlsBasedAuthenticationTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
public final class TlsBasedAuthenticationTest {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Map<String, Object> ecProperties;
    @NotNull
    private static final EnvoyConfig echo1EnvoyConfig;
    @NotNull
    private static final EnvoyConfig echo2EnvoyConfig;
    @NotNull
    private static final EnvoyConfig envoyContainerWithEcho3SanConfig;
    @NotNull
    private static final EnvoyConfig echo3EnvoyConfigWildcard;
    @NotNull
    private static final EnvoyConfig envoyNotTrustingCa;
    @NotNull
    private static final EnvoyConfig envoyDifferentCaConfig;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service2;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo1Envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension echo2Envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyNotTrustingDefaultCa;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyDifferentCa;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoyContainerWithWildcardPrincipal;
    @NotNull
    private static final OkHttpClient insecureClient;

    @BeforeEach
    public final void setup() {
        TlsBasedAuthenticationTest.Companion.registerEcho2WithEnvoyOnIngress();
    }

    @Test
    public final void should encrypt traffic between selected services() {
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response validResponse = TlsBasedAuthenticationTest.access$callEcho2FromEcho1(this.this$0);
                String string = TlsBasedAuthenticationTest.echo1Envoy.getContainer().admin().statValue("cluster.echo2.ssl.handshake");
                Integer sslHandshakes = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Assertions.assertThat((Integer)sslHandshakes).isGreaterThan(0);
                String string2 = TlsBasedAuthenticationTest.echo2Envoy.getContainer().admin().statValue("http.ingress_https.downstream_cx_ssl_total");
                Integer sslConnections = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
                Assertions.assertThat((Integer)sslConnections).isGreaterThan(0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)validResponse);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), TlsBasedAuthenticationTest.service2);
            }
        }, 3, null);
    }

    @Test
    @Tag(value="flaky")
    public final void should encrypt traffic between selected services even if only one endpoint supports mtls() {
        TlsBasedAuthenticationTest.Companion.registerEcho2Insecure();
        AwaitAssertionsKt.untilAsserted$default(null, null, should encrypt traffic between selected services even if only one endpoint supports mtls.1.INSTANCE, 3, null);
        EgressOperations egressOperations = echo1Envoy.getEgressOperations();
        Object[] objectArray = new EchoServiceExtension[]{service1, service2};
        CallStats callStats = new CallStats(CollectionsKt.listOf((Object[])objectArray));
        CallStats callStats2 = EgressOperations.callServiceRepeatedly$default(egressOperations, "echo2", callStats, 2, 2, null, null, "/secured_endpoint", true, 48, null);
        Assertions.assertThat((int)callStats2.getFailedHits()).isEqualTo(0);
        Assertions.assertThat((int)callStats2.hits(service1)).isEqualTo(1);
        Assertions.assertThat((int)callStats2.hits(service2)).isEqualTo(1);
        String string = echo1Envoy.getContainer().admin().statValue("cluster.echo2.plaintext_match.total_match_count");
        Integer defaultToPlaintextMatchesCount = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        Assertions.assertThat((Integer)defaultToPlaintextMatchesCount).isEqualTo(1);
        String string2 = echo1Envoy.getContainer().admin().statValue("cluster.echo2.mtls_match.total_match_count");
        Integer enableMTLSMatchesCount = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
        Assertions.assertThat((Integer)enableMTLSMatchesCount).isEqualTo(1);
    }

    @Test
    public final void should not allow traffic that fails client SAN validation() {
        EnvoyExtension envoyContainerWithEcho3San = new EnvoyExtension(envoyControl, service2, envoyContainerWithEcho3SanConfig, null, 8, null);
        envoyContainerWithEcho3San.getContainer().start();
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this, envoyContainerWithEcho3San){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            final /* synthetic */ EnvoyExtension $envoyContainerWithEcho3San;
            {
                this.this$0 = $receiver;
                this.$envoyContainerWithEcho3San = $envoyContainerWithEcho3San;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response invalidResponse = TlsBasedAuthenticationTest.access$callEcho2(this.this$0, this.$envoyContainerWithEcho3San);
                String string = TlsBasedAuthenticationTest.echo2Envoy.getContainer().admin().statValue("http.ingress_https.rbac.denied");
                Integer sanValidationFailure = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Assertions.assertThat((Integer)sanValidationFailure).isGreaterThan(0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)invalidResponse);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
        envoyContainerWithEcho3San.getContainer().stop();
    }

    @Test
    public final void should not allow traffic that fails server SAN validation() {
        TlsBasedAuthenticationTest.Companion.registerEcho2EnvoyAsEcho3();
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response invalidResponse = TlsBasedAuthenticationTest.access$callEcho3FromEcho1(this.this$0);
                String string = TlsBasedAuthenticationTest.echo1Envoy.getContainer().admin().statValue("cluster.echo3.ssl.fail_verify_san");
                Integer sanValidationFailure = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Assertions.assertThat((Integer)sanValidationFailure).isGreaterThan(0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)invalidResponse);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
    }

    @Test
    public final void client should reject server certificate signed by not trusted CA() {
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response invalidResponse = TlsBasedAuthenticationTest.access$callEcho2(this.this$0, TlsBasedAuthenticationTest.envoyNotTrustingDefaultCa);
                String string = TlsBasedAuthenticationTest.echo2Envoy.getContainer().admin().statValue("listener.0.0.0.0_5001.ssl.connection_error");
                Integer serverTlsErrors = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Assertions.assertThat((Integer)serverTlsErrors).isGreaterThan(0);
                String string2 = TlsBasedAuthenticationTest.envoyNotTrustingDefaultCa.getContainer().admin().statValue("cluster.echo2.ssl.fail_verify_error");
                Integer clientVerificationErrors = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
                Assertions.assertThat((Integer)clientVerificationErrors).isGreaterThan(0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)invalidResponse);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
    }

    @Test
    public final void server should reject client certificate signed by not trusted CA() {
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response invalidResponse = TlsBasedAuthenticationTest.access$callEcho2(this.this$0, TlsBasedAuthenticationTest.envoyDifferentCa);
                String string = TlsBasedAuthenticationTest.echo2Envoy.getContainer().admin().statValue("listener.0.0.0.0_5001.ssl.fail_verify_error");
                Integer serverVerificationErrors = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Assertions.assertThat((Integer)serverVerificationErrors).isGreaterThan(0);
                String string2 = TlsBasedAuthenticationTest.envoyDifferentCa.getContainer().admin().statValue("cluster.echo2.ssl.connection_error");
                Integer clientTlsErrors = string2 != null ? Integer.valueOf(Integer.parseInt(string2)) : null;
                Assertions.assertThat((Integer)clientTlsErrors).isGreaterThan(0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)invalidResponse);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
    }

    @Test
    public final void should reject client without a certificate during RBAC verification() {
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response invalidResponse = TlsBasedAuthenticationTest.access$callEcho2IngressUsingClientWithoutCertificate(this.this$0);
                String string = TlsBasedAuthenticationTest.echo2Envoy.getContainer().admin().statValue("http.ingress_https.rbac.denied");
                Integer sanValidationFailure = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
                Assertions.assertThat((Integer)sanValidationFailure).isGreaterThan(0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)invalidResponse);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isForbidden((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
    }

    @Test
    public final void should allow client with wildcard in incoming permissions to be called from all authenticated clients() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        String string = envoyContainerWithWildcardPrincipal.getContainer().ipAddress();
        List list = CollectionsKt.listOf((Object)"mtls:enabled");
        ConsulOperations.registerService$default(consulOperations, "echo3", "echo3", string, 5001, false, list, null, 80, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ TlsBasedAuthenticationTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response validResponse1 = TlsBasedAuthenticationTest.access$callEcho3FromEcho1(this.this$0);
                Response validResponse2 = TlsBasedAuthenticationTest.access$callEcho3FromEcho2(this.this$0);
                Response invalidResponse1 = TlsBasedAuthenticationTest.access$callEcho3FromEchoWithDifferentCa(this.this$0);
                Response invalidResponse2 = TlsBasedAuthenticationTest.access$callEcho3FromEchoWithNotTrustingDefaultCa(this.this$0);
                ObjectAssert objectAssert = Assertions.assertThat((Object)validResponse1);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                ObjectAssert objectAssert2 = Assertions.assertThat((Object)validResponse2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert2, (String)"assertThat(...)");
                ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert2);
                ObjectAssert objectAssert3 = Assertions.assertThat((Object)invalidResponse1);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert3, (String)"assertThat(...)");
                ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert3);
                ObjectAssert objectAssert4 = Assertions.assertThat((Object)invalidResponse2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert4, (String)"assertThat(...)");
                return ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert4);
            }
        }, 3, null);
    }

    private final Response callEcho2IngressUsingClientWithoutCertificate() {
        String address = echo2Envoy.getContainer().ingressListenerUrl(true);
        Request.Builder builder = new Request.Builder().method("GET", null);
        HttpUrl.Builder builder2 = HttpUrl.Companion.get(address).newBuilder("/secured_endpoint");
        Intrinsics.checkNotNull((Object)builder2);
        Call request2 = insecureClient.newCall(builder.url(builder2.build()).build());
        return request2.execute();
    }

    private final Response callEcho2FromEcho1() {
        return EgressOperations.callService$default(echo1Envoy.getEgressOperations(), "echo2", null, "/secured_endpoint", null, null, 26, null);
    }

    private final Response callEcho2(EnvoyExtension from) {
        return EgressOperations.callService$default(from.getEgressOperations(), "echo2", null, "/secured_endpoint", null, null, 26, null);
    }

    private final Response callEcho3FromEcho1() {
        return EgressOperations.callService$default(echo1Envoy.getEgressOperations(), "echo3", null, "/secured_endpoint", null, null, 26, null);
    }

    private final Response callEcho3FromEcho2() {
        return EgressOperations.callService$default(echo2Envoy.getEgressOperations(), "echo3", null, "/secured_endpoint", null, null, 26, null);
    }

    private final Response callEcho3FromEchoWithNotTrustingDefaultCa() {
        return EgressOperations.callService$default(envoyNotTrustingDefaultCa.getEgressOperations(), "echo3", null, "/secured_endpoint", null, null, 26, null);
    }

    private final Response callEcho3FromEchoWithDifferentCa() {
        return EgressOperations.callService$default(envoyDifferentCa.getEgressOperations(), "echo3", null, "/secured_endpoint", null, null, 26, null);
    }

    public static final /* synthetic */ Response access$callEcho2FromEcho1(TlsBasedAuthenticationTest $this) {
        return $this.callEcho2FromEcho1();
    }

    public static final /* synthetic */ Response access$callEcho2(TlsBasedAuthenticationTest $this, EnvoyExtension from) {
        return $this.callEcho2(from);
    }

    public static final /* synthetic */ Response access$callEcho3FromEcho1(TlsBasedAuthenticationTest $this) {
        return $this.callEcho3FromEcho1();
    }

    public static final /* synthetic */ Response access$callEcho2IngressUsingClientWithoutCertificate(TlsBasedAuthenticationTest $this) {
        return $this.callEcho2IngressUsingClientWithoutCertificate();
    }

    public static final /* synthetic */ Response access$callEcho3FromEcho2(TlsBasedAuthenticationTest $this) {
        return $this.callEcho3FromEcho2();
    }

    public static final /* synthetic */ Response access$callEcho3FromEchoWithDifferentCa(TlsBasedAuthenticationTest $this) {
        return $this.callEcho3FromEchoWithDifferentCa();
    }

    public static final /* synthetic */ Response access$callEcho3FromEchoWithNotTrustingDefaultCa(TlsBasedAuthenticationTest $this) {
        return $this.callEcho3FromEchoWithNotTrustingDefaultCa();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void it;
        EndpointMatch endpointMatch;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[9];
        pairArray[0] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.enabled", (Object)true);
        pairArray[1] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.overlapping-paths-fix", (Object)true);
        pairArray[2] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.incoming-permissions.tls-authentication.services-allowed-to-use-wildcard", (Object)CollectionsKt.listOf((Object)"echo3"));
        pairArray[3] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.outgoing-permissions.services-allowed-to-use-wildcard", (Object)SetsKt.setOf((Object)"echo"));
        pairArray[4] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.status.create-virtual-cluster", (Object)true);
        Object[] objectArray = new EndpointMatch[1];
        EndpointMatch endpointMatch2 = endpointMatch = new EndpointMatch();
        int n = 0;
        Object[] objectArray2 = objectArray;
        String string = "envoy-control.envoy.snapshot.routes.status.endpoints";
        int n2 = 5;
        Pair[] pairArray2 = pairArray;
        boolean bl = false;
        it.setPath("/status/");
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = endpointMatch;
        pairArray2[n2] = TuplesKt.to((Object)string, (Object)CollectionsKt.mutableListOf((Object[])objectArray));
        pairArray[6] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.status.enabled", (Object)true);
        pairArray[7] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.status.path-prefix", (Object)"/status/");
        pairArray[8] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.policy", (Object)"ROUND_ROBIN");
        ecProperties = MapsKt.mapOf((Pair[])pairArray);
        echo1EnvoyConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo2\"\n          - service: \"echo3\"", null, null, null, 59, null);
        echo2EnvoyConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho2EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints:\n          - path: \"/secured_endpoint\"\n            clients: [\"echo\"]\n      outgoing:\n        dependencies:\n          - service: \"echo3\"", null, null, null, 59, null);
        envoyContainerWithEcho3SanConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho3EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        dependencies:\n          - service: \"echo2\"", null, null, null, 59, null);
        echo3EnvoyConfigWildcard = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho3EnvoyAuthConfig(), null, null, "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        endpoints:\n          - path: \"/secured_endpoint\"\n            clients: [\"*\"]", null, null, null, 59, null);
        envoyNotTrustingCa = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, null, "/app/root-ca2.crt", null, null, 55, null);
        envoyDifferentCaConfig = EnvoyConfig.copy$default(EnvoyControlTestConfigurationKt.getEcho1EnvoyAuthConfig(), null, null, null, null, "/app/fullchain_echo_root-ca2.pem", null, 47, null);
        consul = new ConsulExtension(false, 1, null);
        envoyControl = new EnvoyControlExtension(consul, ecProperties);
        service1 = new EchoServiceExtension();
        service2 = new EchoServiceExtension();
        echo1Envoy = new EnvoyExtension(envoyControl, service1, echo1EnvoyConfig, null, 8, null);
        echo2Envoy = new EnvoyExtension(envoyControl, service2, echo2EnvoyConfig, null, 8, null);
        envoyNotTrustingDefaultCa = new EnvoyExtension(envoyControl, service2, envoyNotTrustingCa, null, 8, null);
        envoyDifferentCa = new EnvoyExtension(envoyControl, service2, envoyDifferentCaConfig, null, 8, null);
        envoyContainerWithWildcardPrincipal = new EnvoyExtension(envoyControl, service1, echo3EnvoyConfigWildcard, null, 8, null);
        insecureClient = ClientsFactory.INSTANCE.createInsecureClient();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/permissions/TlsBasedAuthenticationTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "ecProperties", "", "", "echo1Envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "echo1EnvoyConfig", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "echo2Envoy", "echo2EnvoyConfig", "echo3EnvoyConfigWildcard", "envoyContainerWithEcho3SanConfig", "getEnvoyContainerWithEcho3SanConfig", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "envoyContainerWithWildcardPrincipal", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoyDifferentCa", "envoyDifferentCaConfig", "envoyNotTrustingCa", "envoyNotTrustingDefaultCa", "insecureClient", "Lokhttp3/OkHttpClient;", "service1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "service2", "registerEcho2EnvoyAsEcho3", "", "registerEcho2Insecure", "registerEcho2WithEnvoyOnIngress", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnvoyConfig getEnvoyContainerWithEcho3SanConfig() {
            return envoyContainerWithEcho3SanConfig;
        }

        private final void registerEcho2WithEnvoyOnIngress() {
            ConsulOperations.registerService$default(consul.getServer().getOperations(), "echo2", "echo2", echo2Envoy.getContainer().ipAddress(), 5001, false, CollectionsKt.listOf((Object)"mtls:enabled"), null, 80, null);
        }

        private final void registerEcho2EnvoyAsEcho3() {
            ConsulOperations.registerService$default(consul.getServer().getOperations(), "echo3", "echo3", echo2Envoy.getContainer().ipAddress(), 5001, false, CollectionsKt.listOf((Object)"mtls:enabled"), null, 80, null);
        }

        private final void registerEcho2Insecure() {
            ConsulOperations.registerService$default(consul.getServer().getOperations(), "echo2_not_secure", "echo2", service1.container().ipAddress(), 5678, false, CollectionsKt.emptyList(), null, 80, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

