/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.reliability;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import pl.allegro.tech.servicemesh.envoycontrol.LoggerKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulMultiClusterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyAdmin;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.SocketAddress;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlClusteredExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.reliability.ConsulInstancePropagationTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Tag(value="reliability")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulInstancePropagationTest;", "", "()V", "runAllScenarios", "", "runCount", "Ljava/util/concurrent/atomic/LongAdder;", "should test multiple services propagation", "Companion", "Scenarios", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nConsulInstancePropagationTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsulInstancePropagationTest.kt\npl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulInstancePropagationTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1549#2:180\n1620#2,3:181\n1549#2:184\n1620#2,3:185\n*S KotlinDebug\n*F\n+ 1 ConsulInstancePropagationTest.kt\npl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulInstancePropagationTest\n*L\n71#1:180\n71#1:181,3\n77#1:184\n77#1:185,3\n*E\n"})
public final class ConsulInstancePropagationTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Logger> logger$delegate = LoggerKt.logger((Object)Companion);
    private static final int verificationTimes = 1;
    private static final int services = 10;
    private static final int repeatScenarios = 10;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulMultiClusterExtension consulClusters = new ConsulMultiClusterExtension();
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlClusteredExtension envoyControlDc1;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension firstService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension secondService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void should test multiple services propagation() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        LongAdder runCount = new LongAdder();
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        Iterable $this$map$iv = (Iterable)new IntRange(1, 10);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(threadPool.submit(() -> ConsulInstancePropagationTest.should_test_multiple_services_propagation$lambda$1$lambda$0(this, runCount)));
        }
        List futures = (List)destination$iv$iv;
        try {
            $this$map$iv = futures;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Future it = (Future)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.get());
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        catch (Exception e) {
            Assertions.fail((String)("Error running scenarios " + e.getMessage()));
        }
        finally {
            Assertions.assertThat((int)((int)runCount.sum())).isEqualTo(100);
        }
    }

    private final void runAllScenarios(LongAdder runCount) {
        Scenarios scenarios = new Scenarios("echo-" + Random.Default.nextInt(10000000));
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Thread.sleep(Random.Default.nextLong(1000L));
            ConsulInstancePropagationTest.Companion.getLogger().info("Running scenarios for " + scenarios.getServiceName() + " for " + (it + 1) + " time");
            Scenarios $this$runAllScenarios_u24lambda_u244_u24lambda_u243 = scenarios;
            boolean bl2 = false;
            try {
                $this$runAllScenarios_u24lambda_u244_u24lambda_u243.spawnFirstInstance();
                $this$runAllScenarios_u24lambda_u244_u24lambda_u243.spawnSecondInstance();
                $this$runAllScenarios_u24lambda_u244_u24lambda_u243.destroySecondInstance();
                $this$runAllScenarios_u24lambda_u244_u24lambda_u243.destroyLastInstance();
            }
            catch (Throwable e) {
                ConsulInstancePropagationTest.Companion.getLogger().error("Error while running scenario", e);
                throw e;
            }
            runCount.increment();
        }
    }

    private static final void should_test_multiple_services_propagation$lambda$1$lambda$0(ConsulInstancePropagationTest this$0, LongAdder $runCount) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$runCount, (String)"$runCount");
        this$0.runAllScenarios($runCount);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.stateSampleDuration", (Object)Duration.ofSeconds(0L)), TuplesKt.to((Object)"envoy-control.envoy.snapshot.outgoing-permissions.servicesAllowedToUseWildcard", (Object)"test-service")};
        properties = MapsKt.mapOf((Pair[])pairArray);
        envoyControlDc1 = new EnvoyControlClusteredExtension(consulClusters.getServerFirst(), (Function0<? extends Map<String, ? extends Object>>)((Function0)Companion.envoyControlDc1.1.INSTANCE), (List<? extends BeforeAllCallback>)CollectionsKt.listOf((Object)consulClusters));
        envoy = new EnvoyExtension(envoyControlDc1, null, EnvoyControlTestConfigurationKt.getAdsAllDependencies(), null, 10, null);
        firstService = new EchoServiceExtension();
        secondService = new EchoServiceExtension();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR%\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00010\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulInstancePropagationTest$Companion;", "", "()V", "consulClusters", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulMultiClusterExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControlDc1", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlClusteredExtension;", "firstService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "properties", "", "", "kotlin.jvm.PlatformType", "getProperties", "()Ljava/util/Map;", "repeatScenarios", "", "secondService", "services", "verificationTimes", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLogger() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Map<String, Object> getProperties() {
            return properties;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0011J!\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u001c"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulInstancePropagationTest$Scenarios;", "", "serviceName", "", "(Lpl/allegro/tech/servicemesh/envoycontrol/reliability/ConsulInstancePropagationTest;Ljava/lang/String;)V", "admin", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyAdmin;", "firstInstanceId", "getFirstInstanceId", "()Ljava/lang/String;", "setFirstInstanceId", "(Ljava/lang/String;)V", "secondInstanceId", "getSecondInstanceId", "setSecondInstanceId", "getServiceName", "deregisterService", "", "serviceId", "destroyLastInstance", "destroySecondInstance", "spawnFirstInstance", "spawnSecondInstance", "waitForEchosInAdmin", "containers", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoContainer;", "([Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoContainer;)V", "envoy-control-tests"})
    public final class Scenarios {
        @NotNull
        private final String serviceName;
        @Nullable
        private String firstInstanceId;
        @Nullable
        private String secondInstanceId;
        @NotNull
        private final EnvoyAdmin admin;

        public Scenarios(String serviceName) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            this.serviceName = serviceName;
            this.admin = envoy.getContainer().admin();
        }

        @NotNull
        public final String getServiceName() {
            return this.serviceName;
        }

        @Nullable
        public final String getFirstInstanceId() {
            return this.firstInstanceId;
        }

        public final void setFirstInstanceId(@Nullable String string) {
            this.firstInstanceId = string;
        }

        @Nullable
        public final String getSecondInstanceId() {
            return this.secondInstanceId;
        }

        public final void setSecondInstanceId(@Nullable String string) {
            this.secondInstanceId = string;
        }

        public final void spawnFirstInstance() {
            this.firstInstanceId = ConsulOperations.registerService$default(consulClusters.getServerFirst().getOperations(), firstService, this.serviceName + "-1", this.serviceName, false, null, null, 56, null);
            EchoContainer[] echoContainerArray = new EchoContainer[]{firstService.container()};
            this.waitForEchosInAdmin(echoContainerArray);
            int n = 1;
            int n2 = 0;
            while (n2 < n) {
                Response response2;
                int it = n2++;
                boolean bl = false;
                Response it2 = response2 = EgressOperations.callService$default(envoy.getEgressOperations(), this.serviceName, null, null, null, null, 30, null);
                boolean bl2 = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), firstService);
            }
        }

        public final void spawnSecondInstance() {
            this.secondInstanceId = ConsulOperations.registerService$default(consulClusters.getServerFirst().getOperations(), secondService, this.serviceName + "-2", this.serviceName, false, null, null, 56, null);
            EchoContainer[] echoContainerArray = new EchoContainer[]{firstService.container(), secondService.container()};
            this.waitForEchosInAdmin(echoContainerArray);
            int n = 1;
            int n2 = 0;
            while (n2 < n) {
                Response response2;
                int it = n2++;
                boolean bl = false;
                Response it2 = response2 = EgressOperations.callService$default(envoy.getEgressOperations(), this.serviceName, null, null, null, null, 30, null);
                boolean bl2 = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                EchoServiceExtension[] echoServiceExtensionArray = new EchoServiceExtension[]{firstService, secondService};
                ResponseAssertionsKt.isEitherFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), echoServiceExtensionArray);
            }
        }

        public final void destroySecondInstance() {
            String string = this.secondInstanceId;
            Intrinsics.checkNotNull((Object)string);
            this.deregisterService(string);
            EchoContainer[] echoContainerArray = new EchoContainer[]{firstService.container()};
            this.waitForEchosInAdmin(echoContainerArray);
            int n = 1;
            int n2 = 0;
            while (n2 < n) {
                Response response2;
                int it = n2++;
                boolean bl = false;
                Response it2 = response2 = EgressOperations.callService$default(envoy.getEgressOperations(), this.serviceName, null, null, null, null, 30, null);
                boolean bl2 = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), firstService);
            }
        }

        private final void deregisterService(String serviceId) {
            consulClusters.getServerFirst().getOperations().deregisterService(serviceId);
        }

        public final void destroyLastInstance() {
            String string = this.firstInstanceId;
            Intrinsics.checkNotNull((Object)string);
            this.deregisterService(string);
            this.waitForEchosInAdmin(new EchoContainer[0]);
            int n = 1;
            int n2 = 0;
            while (n2 < n) {
                Response response2;
                int it = n2++;
                boolean bl = false;
                Response it2 = response2 = EgressOperations.callService$default(envoy.getEgressOperations(), this.serviceName, null, null, null, null, 30, null);
                boolean bl2 = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
            }
        }

        private final void waitForEchosInAdmin(EchoContainer ... containers) {
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ListAssert<String>>(this, containers){
                final /* synthetic */ Scenarios this$0;
                final /* synthetic */ EchoContainer[] $containers;
                {
                    this.this$0 = $receiver;
                    this.$containers = $containers;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final ListAssert<String> invoke() {
                    Collection collection;
                    EchoContainer[] $this$mapTo$iv$iv;
                    EchoContainer[] $this$map$iv = (EchoContainer[])Scenarios.access$getAdmin$p(this.this$0).endpointsAddress(this.this$0.getServiceName());
                    boolean $i$f$map = false;
                    EchoContainer[] echoContainerArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T t : $this$mapTo$iv$iv) {
                        void it;
                        SocketAddress socketAddress = (SocketAddress)t;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getAddress() + ":" + it.getPortValue());
                    }
                    List addresses = (List)destination$iv$iv;
                    $this$map$iv = this.$containers;
                    collection = (ListAssert)Assertions.assertThat((List)addresses).hasSize(this.$containers.length);
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    $i$f$mapTo = false;
                    int n = $this$mapTo$iv$iv.length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        EchoContainer item$iv$iv;
                        EchoContainer bl = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        collection2.add(it.address());
                    }
                    return (ListAssert)collection.containsExactlyInAnyOrderElementsOf((List)destination$iv$iv);
                }
            }, 3, null);
        }

        public static final /* synthetic */ EnvoyAdmin access$getAdmin$p(Scenarios $this) {
            return $this.admin;
        }
    }
}

