/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.ResponseWithBody;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.routing.CanaryLoadBalancingTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012J\b\u0010\u0014\u001a\u00020\u0005H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020\u001fH\u0007J\b\u0010!\u001a\u00020\u001fH\u0017R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006#"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/CanaryLoadBalancingTest;", "", "()V", "canaryHits", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "getCanaryHits", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;)I", "regularHits", "getRegularHits", "callEchoServiceRepeatedly", "minRepeat", "maxRepeat", "repeatUntil", "Lkotlin/Function1;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/ResponseWithBody;", "", "headers", "", "", "callStats", "canaryContainer", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "regularContainer", "should balance load according to weights", "", "should route request to canary instance only", "should route to both canary and regular instances when canary weight is 0", "Companion", "envoy-control-tests"})
public class CanaryLoadBalancingTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension canaryContainer;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension regularContainer;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;

    @Test
    public final void should balance load according to weights() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = this.canaryContainer();
        Object[] objectArray = new String[]{"canary", "weight:1"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = this.regularContainer();
        list = CollectionsKt.listOf((Object)"weight:20");
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Response>(this){
            final /* synthetic */ CanaryLoadBalancingTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2;
                Response it = response2 = EgressOperations.callService$default(this.this$0.envoy().getEgressOperations(), "echo", null, null, null, null, 30, null);
                boolean bl = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                return response2;
            }
        }, 3, null);
        CallStats stats2 = CanaryLoadBalancingTest.callEchoServiceRepeatedly$default(this, 30, 200, (Function1)new Function1<ResponseWithBody, Boolean>(this){
            final /* synthetic */ CanaryLoadBalancingTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ResponseWithBody response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                return response2.isFrom(this.this$0.canaryContainer());
            }
        }, null, 8, null);
        Assertions.assertThat((int)(this.getCanaryHits(stats2) + this.getRegularHits(stats2))).isEqualTo(stats2.getTotalHits());
        Assertions.assertThat((int)stats2.getTotalHits()).isGreaterThan(29);
        Assertions.assertThat((int)this.getCanaryHits(stats2)).isGreaterThan(0);
        Assertions.assertThat((int)this.getRegularHits(stats2)).isGreaterThan(this.getCanaryHits(stats2) * 3);
    }

    @Test
    public final void should route request to canary instance only() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = this.canaryContainer();
        Object[] objectArray = new String[]{"canary", "weight:1"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = this.regularContainer();
        list = CollectionsKt.listOf((Object)"weight:20");
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Response>(this){
            final /* synthetic */ CanaryLoadBalancingTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2;
                Response it = response2 = EgressOperations.callService$default(this.this$0.envoy().getEgressOperations(), "echo", null, null, null, null, 30, null);
                boolean bl = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                return response2;
            }
        }, 3, null);
        CallStats stats2 = CanaryLoadBalancingTest.callEchoServiceRepeatedly$default(this, 50, 50, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"X-Canary", (Object)"1")), 4, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(50);
        Assertions.assertThat((int)this.getCanaryHits(stats2)).isEqualTo(50);
        Assertions.assertThat((int)this.getRegularHits(stats2)).isEqualTo(0);
    }

    @Test
    public void should route to both canary and regular instances when canary weight is 0() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = this.canaryContainer();
        Object[] objectArray = new String[]{"canary", "weight:0"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = this.regularContainer();
        list = CollectionsKt.listOf((Object)"weight:20");
        ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Response>(this){
            final /* synthetic */ CanaryLoadBalancingTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Response invoke() {
                Response response2;
                Response it = response2 = EgressOperations.callService$default(this.this$0.envoy().getEgressOperations(), "echo", null, null, null, null, 30, null);
                boolean bl = false;
                ObjectAssert objectAssert = Assertions.assertThat((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                return response2;
            }
        }, 3, null);
        CallStats stats2 = CanaryLoadBalancingTest.callEchoServiceRepeatedly$default(this, 30, 200, (Function1)new Function1<ResponseWithBody, Boolean>(this){
            final /* synthetic */ CanaryLoadBalancingTest this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ResponseWithBody response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                return response2.isFrom(this.this$0.canaryContainer());
            }
        }, null, 8, null);
        Assertions.assertThat((int)(this.getCanaryHits(stats2) + this.getRegularHits(stats2))).isEqualTo(stats2.getTotalHits());
        Assertions.assertThat((int)stats2.getTotalHits()).isGreaterThan(29);
        Assertions.assertThat((int)this.getCanaryHits(stats2)).isGreaterThan(0);
    }

    @NotNull
    protected CallStats callStats() {
        Object[] objectArray = new EchoServiceExtension[]{this.canaryContainer(), this.regularContainer()};
        return new CallStats(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final CallStats callEchoServiceRepeatedly(int minRepeat, int maxRepeat, @NotNull Function1<? super ResponseWithBody, Boolean> repeatUntil, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(repeatUntil, (String)"repeatUntil");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        CallStats stats2 = this.callStats();
        EgressOperations.callServiceRepeatedly$default(this.envoy().getEgressOperations(), "echo", stats2, minRepeat, maxRepeat, repeatUntil, headers, null, false, 192, null);
        return stats2;
    }

    public static /* synthetic */ CallStats callEchoServiceRepeatedly$default(CanaryLoadBalancingTest canaryLoadBalancingTest, int n, int n2, Function1 function1, Map map, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callEchoServiceRepeatedly");
        }
        if ((n3 & 4) != 0) {
            function1 = callEchoServiceRepeatedly.1.INSTANCE;
        }
        if ((n3 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return canaryLoadBalancingTest.callEchoServiceRepeatedly(n, n2, (Function1<? super ResponseWithBody, Boolean>)function1, map);
    }

    public final int getRegularHits(@NotNull CallStats $this$regularHits) {
        Intrinsics.checkNotNullParameter((Object)$this$regularHits, (String)"<this>");
        return $this$regularHits.hits(this.regularContainer());
    }

    public final int getCanaryHits(@NotNull CallStats $this$canaryHits) {
        Intrinsics.checkNotNullParameter((Object)$this$canaryHits, (String)"<this>");
        return $this$canaryHits.hits(this.canaryContainer());
    }

    @NotNull
    public EnvoyControlExtension envoyControl() {
        return envoyControl;
    }

    @NotNull
    public EnvoyExtension envoy() {
        return envoy;
    }

    @NotNull
    public ConsulExtension consul() {
        return consul;
    }

    @NotNull
    public EchoServiceExtension canaryContainer() {
        return canaryContainer;
    }

    @NotNull
    public EchoServiceExtension regularContainer() {
        return regularContainer;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.source.consul.tags.weight", (Object)"weight"), TuplesKt.to((Object)"envoy-control.source.consul.tags.canary", (Object)"canary"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.weights.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.canary.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.canary.metadata-key", (Object)"canary"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.load-balancing.canary.metadata-value", (Object)"1")};
        properties = MapsKt.mapOf((Pair[])pairArray);
        consul = new ConsulExtension(false, 1, null);
        envoyControl = new EnvoyControlExtension(consul, properties);
        canaryContainer = new EchoServiceExtension();
        regularContainer = new EchoServiceExtension();
        envoy = new EnvoyExtension(envoyControl, null, null, null, 14, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/CanaryLoadBalancingTest$Companion;", "", "()V", "canaryContainer", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "properties", "", "", "regularContainer", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

