/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.ResponseWithBody;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.services.ServiceInstance;
import pl.allegro.tech.servicemesh.envoycontrol.services.ServiceInstances;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0004J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0007J\b\u0010\u0018\u001a\u00020\u0014H\u0007J\b\u0010\u0019\u001a\u00020\u0014H\u0007J\u0016\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001cH\u0004J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u0005H\u0004J \u0010!\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u0005H\u0004R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTestBase;", "", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "autoServiceTagEnabledEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "autoServiceTagDisabledEnvoy", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;)V", "getEnvoyControl", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "callEchoTenTimes", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "envoy", "assertNoErrors", "", "tag", "", "tagPreference", "callStats", "clientSideServiceTagOrTagPreference", "", "tagOrPreference", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTestBase$TagOrPreference;", "should consider client side service-tag", "should filter service instances according to tag preference", "should reject request service-tag if it duplicates service-tag-preference", "waitForEcConsulStateSynchronized", "expectedInstancesIds", "", "waitForEndpointReady", "serviceName", "serviceInstance", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "waitForEndpointRemoved", "Companion", "TagOrPreference", "envoy-control-tests"})
@SourceDebugExtension(value={"SMAP\nRoutingPolicyTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingPolicyTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTestBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,472:1\n1#2:473\n*E\n"})
public abstract class RoutingPolicyTestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvoyControlExtension envoyControl;
    @NotNull
    private final EnvoyExtension autoServiceTagEnabledEnvoy;
    @NotNull
    private final EnvoyExtension autoServiceTagDisabledEnvoy;
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension loremEchoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension ipsumEchoService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension otherEchoService;
    @NotNull
    private static final String autoServiceTagEnabledSettings;

    public RoutingPolicyTestBase(@NotNull EnvoyControlExtension envoyControl4, @NotNull EnvoyExtension autoServiceTagEnabledEnvoy, @NotNull EnvoyExtension autoServiceTagDisabledEnvoy) {
        Intrinsics.checkNotNullParameter((Object)envoyControl4, (String)"envoyControl");
        Intrinsics.checkNotNullParameter((Object)autoServiceTagEnabledEnvoy, (String)"autoServiceTagEnabledEnvoy");
        Intrinsics.checkNotNullParameter((Object)autoServiceTagDisabledEnvoy, (String)"autoServiceTagDisabledEnvoy");
        this.envoyControl = envoyControl4;
        this.autoServiceTagEnabledEnvoy = autoServiceTagEnabledEnvoy;
        this.autoServiceTagDisabledEnvoy = autoServiceTagDisabledEnvoy;
    }

    @NotNull
    public final EnvoyControlExtension getEnvoyControl() {
        return this.envoyControl;
    }

    @Test
    public final void should filter service instances according to tag preference() {
        Object[] objectArray = new String[3];
        ConsulOperations consulOperations = consul.getServer().getOperations();
        EchoServiceExtension echoServiceExtension = ipsumEchoService;
        Object[] objectArray2 = new String[]{"ipsum", "other"};
        List list = CollectionsKt.listOf((Object[])objectArray2);
        objectArray[0] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = loremEchoService;
        list = CollectionsKt.listOf((Object)"lorem");
        objectArray[1] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        consulOperations = consul.getServer().getOperations();
        echoServiceExtension = otherEchoService;
        list = CollectionsKt.emptyList();
        objectArray[2] = ConsulOperations.registerService$default(consulOperations, echoServiceExtension, null, "echo", false, list, null, 42, null);
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", ipsumEchoService, this.autoServiceTagEnabledEnvoy);
        CallStats stats2 = RoutingPolicyTestBase.callEchoTenTimes$default(this, this.autoServiceTagEnabledEnvoy, false, null, null, 14, null);
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumEchoService)).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(loremEchoService)).isEqualTo(0);
        Assertions.assertThat((int)stats2.hits(otherEchoService)).isEqualTo(0);
    }

    @Test
    public final void should consider client side service-tag() {
        this.clientSideServiceTagOrTagPreference(TagOrPreference.TAG);
    }

    public final void clientSideServiceTagOrTagPreference(@NotNull TagOrPreference tagOrPreference) {
        Intrinsics.checkNotNullParameter((Object)((Object)tagOrPreference), (String)"tagOrPreference");
        EchoServiceExtension ipsumBetaEchoService = ipsumEchoService;
        EchoServiceExtension ipsumAlphaEchoService = otherEchoService;
        EchoServiceExtension loremBetaEchoService = loremEchoService;
        ConsulOperations consulOperations = consul.getServer().getOperations();
        Object[] objectArray = new String[]{"ipsum", "beta"};
        Object object = CollectionsKt.listOf((Object[])objectArray);
        String ipsumBetaId = ConsulOperations.registerService$default(consulOperations, ipsumBetaEchoService, null, "echo", false, (List)object, null, 42, null);
        object = consul.getServer().getOperations();
        Object object2 = new String[]{"lorem", "beta"};
        objectArray = CollectionsKt.listOf((Object[])object2);
        String loremBetaId = ConsulOperations.registerService$default((ConsulOperations)object, loremBetaEchoService, null, "echo", false, (List)objectArray, null, 42, null);
        objectArray = consul.getServer().getOperations();
        Object[] objectArray2 = new String[]{"ipsum", "alpha"};
        object2 = CollectionsKt.listOf((Object[])objectArray2);
        String ipsumAlphaId = ConsulOperations.registerService$default((ConsulOperations)objectArray, ipsumAlphaEchoService, null, "echo", false, (List)object2, null, 42, null);
        objectArray = new String[]{ipsumBetaId, ipsumAlphaId, loremBetaId};
        this.waitForEcConsulStateSynchronized(CollectionsKt.listOf((Object[])objectArray));
        this.waitForEndpointReady("echo", ipsumAlphaEchoService, this.autoServiceTagEnabledEnvoy);
        this.waitForEndpointReady("echo", ipsumAlphaEchoService, this.autoServiceTagDisabledEnvoy);
        objectArray = switch (WhenMappings.$EnumSwitchMapping$0[tagOrPreference.ordinal()]) {
            case 1 -> TuplesKt.to((Object)"beta", null);
            case 2 -> TuplesKt.to(null, (Object)"beta");
            default -> throw new NoWhenBranchMatchedException();
        };
        String tag = (String)objectArray.component1();
        String preference = (String)objectArray.component2();
        CallStats statsAutoServiceTag = RoutingPolicyTestBase.callEchoTenTimes$default(this, this.autoServiceTagEnabledEnvoy, false, tag, preference, 2, null);
        CallStats statsNoAutoServiceTag = RoutingPolicyTestBase.callEchoTenTimes$default(this, this.autoServiceTagDisabledEnvoy, false, tag, preference, 2, null);
        CallStats stats2 = statsAutoServiceTag;
        boolean bl = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumBetaEchoService)).isEqualTo(10);
        stats2 = statsNoAutoServiceTag;
        boolean bl2 = false;
        Assertions.assertThat((int)stats2.getTotalHits()).isEqualTo(10);
        Assertions.assertThat((int)stats2.hits(ipsumBetaEchoService)).isEqualTo(5);
        Assertions.assertThat((int)stats2.hits(loremBetaEchoService)).isEqualTo(5);
    }

    @Test
    public final void should reject request service-tag if it duplicates service-tag-preference() {
        ConsulOperations consulOperations = consul.getServer().getOperations();
        Object object = new String[]{"lorem", "est"};
        List list = CollectionsKt.listOf((Object[])object);
        object = loremEchoService;
        ConsulOperations.registerService$default(consulOperations, (ServiceExtension)object, null, "echo", false, list, null, 42, null);
        this.waitForEndpointReady("echo", loremEchoService, this.autoServiceTagEnabledEnvoy);
        Response notDuplicatedTagResponse = EgressOperations.callService$default(this.autoServiceTagEnabledEnvoy.getEgressOperations(), "echo", MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag", (Object)"est")), null, null, null, 28, null);
        Response it = EgressOperations.callService$default(this.autoServiceTagEnabledEnvoy.getEgressOperations(), "echo", MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag", (Object)"lorem")), null, null, null, 28, null);
        boolean bl = false;
        ResponseWithBody duplicatedTagResponseLorem = new ResponseWithBody(it);
        Response it2 = EgressOperations.callService$default(this.autoServiceTagEnabledEnvoy.getEgressOperations(), "echo", MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag", (Object)"ipsum")), null, null, null, 28, null);
        boolean bl2 = false;
        ResponseWithBody duplicatedTagResponseIpsum = new ResponseWithBody(it2);
        ObjectAssert objectAssert = Assertions.assertThat((Object)notDuplicatedTagResponse);
        Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
        ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), loremEchoService);
        Assertions.assertThat((int)duplicatedTagResponseLorem.getResponse().code()).isEqualTo(400);
        Assertions.assertThat((String)duplicatedTagResponseLorem.getBody()).isEqualTo("Request service-tag 'lorem' duplicates auto service-tag preference. Remove service-tag parameter from the request");
        Assertions.assertThat((int)duplicatedTagResponseIpsum.getResponse().code()).isEqualTo(400);
        Assertions.assertThat((String)duplicatedTagResponseIpsum.getBody()).isEqualTo("Request service-tag 'ipsum' duplicates auto service-tag preference. Remove service-tag parameter from the request");
    }

    protected final void waitForEcConsulStateSynchronized(@NotNull Collection<String> expectedInstancesIds) {
        Intrinsics.checkNotNullParameter(expectedInstancesIds, (String)"expectedInstancesIds");
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractCollectionAssert<?, ?, ?, ?>>(this, expectedInstancesIds){
            final /* synthetic */ RoutingPolicyTestBase this$0;
            final /* synthetic */ Collection<String> $expectedInstancesIds;
            {
                this.this$0 = $receiver;
                this.$expectedInstancesIds = $expectedInstancesIds;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final AbstractCollectionAssert<?, ?, ?, ?> invoke() {
                void $this$mapTo$iv$iv;
                ServiceInstances serviceInstances = this.this$0.getEnvoyControl().getApp().getState().get("echo");
                Set<E> set = serviceInstances != null ? serviceInstances.getInstances() : null;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set<E> echoInstances = set;
                Iterable $this$map$iv = echoInstances;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ServiceInstance serviceInstance = (ServiceInstance)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getId());
                }
                Object[] objectArray = new Object[]{this.$expectedInstancesIds, echoInstances};
                return (AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)CollectionsKt.toSet((Iterable)((List)destination$iv$iv))).withFailMessage("EC instances state of 'echo' service not consistent with consul. Expected instances: %s, Found: %s", objectArray)).isEqualTo((Object)CollectionsKt.toSet((Iterable)this.$expectedInstancesIds));
            }
        }, 1, null);
    }

    protected final void waitForEndpointReady(@NotNull String serviceName, @NotNull EchoServiceExtension serviceInstance, @NotNull EnvoyExtension envoy) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)serviceInstance, (String)"serviceInstance");
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        envoy.waitForClusterEndpointHealthy(serviceName, serviceInstance.container().ipAddress());
    }

    protected final void waitForEndpointRemoved(@NotNull String serviceName, @NotNull EchoServiceExtension serviceInstance, @NotNull EnvoyExtension envoy) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)serviceInstance, (String)"serviceInstance");
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        envoy.waitForClusterEndpointNotHealthy(serviceName, serviceInstance.container().ipAddress());
    }

    private final CallStats callStats() {
        Object[] objectArray = new EchoServiceExtension[]{ipsumEchoService, loremEchoService, otherEchoService};
        return new CallStats(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    protected final CallStats callEchoTenTimes(@NotNull EnvoyExtension envoy, boolean assertNoErrors, @Nullable String tag, @Nullable String tagPreference) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        CallStats stats2 = this.callStats();
        EgressOperations egressOperations = envoy.getEgressOperations();
        Map $this$callEchoTenTimes_u24lambda_u244 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        if (tag != null) {
            $this$callEchoTenTimes_u24lambda_u244.put("x-service-tag", tag);
        }
        if (tagPreference != null) {
            $this$callEchoTenTimes_u24lambda_u244.put("x-service-tag-preference", tagPreference);
        }
        Map map2 = MapsKt.build((Map)map);
        EgressOperations.callServiceRepeatedly$default(egressOperations, "echo", stats2, 0, 10, null, map2, null, assertNoErrors, 84, null);
        return stats2;
    }

    public static /* synthetic */ CallStats callEchoTenTimes$default(RoutingPolicyTestBase routingPolicyTestBase, EnvoyExtension envoyExtension, boolean bl, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callEchoTenTimes");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return routingPolicyTestBase.callEchoTenTimes(envoyExtension, bl, string, string2);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.metadata-key", (Object)"tag"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.auto-service-tag-enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.reject-requests-with-duplicated-auto-service-tag", (Object)true)};
        properties = MapsKt.mapOf((Pair[])pairArray);
        consul = new ConsulExtension(false, 1, null);
        loremEchoService = new EchoServiceExtension();
        ipsumEchoService = new EchoServiceExtension();
        otherEchoService = new EchoServiceExtension();
        autoServiceTagEnabledSettings = "node:\n  metadata:\n    proxy_settings:\n      outgoing:\n        routingPolicy:\n          autoServiceTag: true\n          serviceTagPreference: [\"ipsum\", \"lorem\"]\n        dependencies:\n          - service: \"echo\" ";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTestBase$Companion;", "", "()V", "autoServiceTagEnabledSettings", "", "getAutoServiceTagEnabledSettings", "()Ljava/lang/String;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "ipsumEchoService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "loremEchoService", "otherEchoService", "properties", "", "getProperties", "()Ljava/util/Map;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> getProperties() {
            return properties;
        }

        @NotNull
        public final String getAutoServiceTagEnabledSettings() {
            return autoServiceTagEnabledSettings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/RoutingPolicyTestBase$TagOrPreference;", "", "(Ljava/lang/String;I)V", "TAG", "TAG_PREFERENCE", "envoy-control-tests"})
    public static final class TagOrPreference
    extends Enum<TagOrPreference> {
        public static final /* enum */ TagOrPreference TAG = new TagOrPreference();
        public static final /* enum */ TagOrPreference TAG_PREFERENCE = new TagOrPreference();
        private static final /* synthetic */ TagOrPreference[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TagOrPreference[] values() {
            return (TagOrPreference[])$VALUES.clone();
        }

        public static TagOrPreference valueOf(String value) {
            return Enum.valueOf(TagOrPreference.class, value);
        }

        @NotNull
        public static EnumEntries<TagOrPreference> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tagOrPreferenceArray = new TagOrPreference[]{TagOrPreference.TAG, TagOrPreference.TAG_PREFERENCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TagOrPreference.values().length];
            try {
                nArray[TagOrPreference.TAG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TagOrPreference.TAG_PREFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

