/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestClassOrder;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.CallStats;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.sharing.ContainerExtension;
import pl.allegro.tech.servicemesh.envoycontrol.routing.ServiceTagPreferenceTestBase;

@TestClassOrder(value=ClassOrderer.OrderAnnotation.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00062\u00020\u0001:\u0004\u0006\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceTestBase;", "()V", "report", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/CallStats;", "Companion", "ThenGlobalInstanceAppears", "WhenThereIsNoGlobalInstance", "WhenThereIsNoGlobalInstanceSetup", "envoy-control-tests"})
public final class ServiceTagPreferenceFallbackToAnyTest
extends ServiceTagPreferenceTestBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @NotNull
    private static final EnvoyExtension envoyGlobal;
    @NotNull
    private static final EnvoyExtension envoyVte2;
    @NotNull
    private static final HttpsEchoExtension echoVte5;
    @NotNull
    private static final HttpsEchoExtension echoVte6;
    @NotNull
    private static final HttpsEchoExtension echoGlobal;
    @NotNull
    private static final List<HttpsEchoExtension> allServices;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ContainerExtension.Parallel containers;

    public ServiceTagPreferenceFallbackToAnyTest() {
        super(allServices);
    }

    @Override
    @NotNull
    public String report(@NotNull CallStats $this$report) {
        Intrinsics.checkNotNullParameter((Object)$this$report, (String)"<this>");
        return "hits: {global: " + $this$report.hits(echoGlobal) + ", vte5: " + $this$report.hits(echoVte5) + ", vte6: " + $this$report.hits(echoVte6) + "}";
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.enable-for-all", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.fallback-to-any.enable-for-services-with-default-preference-equal-to", (Object)"global")};
        envoyControl = new EnvoyControlExtension(ServiceTagPreferenceTestBase.consul, MapsKt.plus(ServiceTagPreferenceTestBase.Companion.getProperties(), (Map)MapsKt.mapOf((Pair[])object)));
        envoyGlobal = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        Object it = object = new EnvoyExtension(envoyControl, null, null, null, 14, null);
        boolean bl = false;
        ((EnvoyExtension)it).getContainer().withEnv("DEFAULT_SERVICE_TAG_PREFERENCE", "vte2|global");
        envoyVte2 = object;
        echoVte5 = new HttpsEchoExtension();
        echoVte6 = new HttpsEchoExtension();
        echoGlobal = new HttpsEchoExtension();
        object = new HttpsEchoExtension[]{echoGlobal, echoVte5, echoVte6};
        allServices = CollectionsKt.listOf((Object[])object);
        object = new ContainerExtension[]{envoyGlobal, envoyVte2, echoVte5, echoVte6, echoGlobal};
        containers = new ContainerExtension.Parallel((ContainerExtension[])object);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$Companion;", "", "()V", "allServices", "", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "getAllServices", "()Ljava/util/List;", "containers", "Lpl/allegro/tech/servicemesh/envoycontrol/config/sharing/ContainerExtension$Parallel;", "echoGlobal", "getEchoGlobal", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "echoVte5", "getEchoVte5", "echoVte6", "getEchoVte6", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoyGlobal", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "getEnvoyGlobal", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyVte2", "getEnvoyVte2", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnvoyExtension getEnvoyGlobal() {
            return envoyGlobal;
        }

        @NotNull
        public final EnvoyExtension getEnvoyVte2() {
            return envoyVte2;
        }

        @NotNull
        public final HttpsEchoExtension getEchoVte5() {
            return echoVte5;
        }

        @NotNull
        public final HttpsEchoExtension getEchoVte6() {
            return echoVte6;
        }

        @NotNull
        public final HttpsEchoExtension getEchoGlobal() {
            return echoGlobal;
        }

        @NotNull
        public final List<HttpsEchoExtension> getAllServices() {
            return allServices;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Order(value=2)
    @Nested
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$ThenGlobalInstanceAppears;", "", "(Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest;)V", "global envoy should switch to global instance", "", "registerGlobal", "envoy-control-tests"})
    @SourceDebugExtension(value={"SMAP\nServiceTagPreferenceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$ThenGlobalInstanceAppears\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n1855#2:433\n1855#2,2:434\n1856#2:436\n*S KotlinDebug\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$ThenGlobalInstanceAppears\n*L\n352#1:433\n353#1:434,2\n352#1:436\n*E\n"})
    public final class ThenGlobalInstanceAppears {
        @Test
        public final void global envoy should switch to global instance() {
            this.registerGlobal();
            ServiceTagPreferenceFallbackToAnyTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceFallbackToAnyTest.this, Companion.getEnvoyGlobal(), "echo", null, null, 6, null), Companion.getEchoGlobal());
        }

        public final void registerGlobal() {
            Object[] objectArray = ServiceTagPreferenceTestBase.consul.getServer().getOperations();
            List list = CollectionsKt.listOf((Object)"global");
            ConsulOperations.registerService$default((ConsulOperations)objectArray, Companion.getEchoGlobal(), null, "echo", false, list, null, 42, null);
            objectArray = new EnvoyExtension[]{Companion.getEnvoyGlobal(), Companion.getEnvoyVte2()};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EnvoyExtension envoy = (EnvoyExtension)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = Companion.getAllServices();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    HttpsEchoExtension service = (HttpsEchoExtension)element$iv2;
                    boolean bl2 = false;
                    envoy.waitForClusterEndpointHealthy("echo", service.container().ipAddress());
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Order(value=1)
    @Nested
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$WhenThereIsNoGlobalInstance;", "Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$WhenThereIsNoGlobalInstanceSetup;", "(Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest;)V", "global instance should NOT fallback to any when service-tag is used", "", "global instance should fallback to any", "global instance should route to instance according to preference if matching instance is found", "not global instance should NOT fallback to any", "envoy-control-tests"})
    public final class WhenThereIsNoGlobalInstance
    extends WhenThereIsNoGlobalInstanceSetup {
        @Test
        public final void global instance should fallback to any() {
            Object[] objectArray = new HttpsEchoExtension[]{Companion.getEchoVte5(), Companion.getEchoVte6()};
            ServiceTagPreferenceFallbackToAnyTest.this.assertResponsesFromRandomInstances(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceFallbackToAnyTest.this, Companion.getEnvoyGlobal(), "echo", null, null, 6, null), CollectionsKt.listOf((Object[])objectArray));
            objectArray = new HttpsEchoExtension[]{Companion.getEchoVte5(), Companion.getEchoVte6()};
            ServiceTagPreferenceFallbackToAnyTest.this.assertResponsesFromRandomInstances(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceFallbackToAnyTest.this, Companion.getEnvoyGlobal(), "echo", "vte100|global", null, 4, null), CollectionsKt.listOf((Object[])objectArray));
        }

        @Test
        public final void not global instance should NOT fallback to any() {
            Response it = ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceFallbackToAnyTest.this, Companion.getEnvoyVte2(), "echo", null, null, 6, null);
            boolean bl = false;
            ObjectAssert objectAssert = Assertions.assertThat((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
            ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
        }

        @Test
        public final void global instance should NOT fallback to any when service-tag is used() {
            Response it = ServiceTagPreferenceTestBase.callService$default(ServiceTagPreferenceFallbackToAnyTest.this, Companion.getEnvoyGlobal(), "echo", null, "vte100", 2, null);
            boolean bl = false;
            ObjectAssert objectAssert = Assertions.assertThat((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
            ResponseAssertionsKt.isUnreachable((ObjectAssert<Response>)objectAssert);
        }

        @Test
        public final void global instance should route to instance according to preference if matching instance is found() {
            ServiceTagPreferenceFallbackToAnyTest.this.assertAllResponsesOkAndFrom(ServiceTagPreferenceTestBase.callServiceRepeatedly$default(ServiceTagPreferenceFallbackToAnyTest.this, Companion.getEnvoyGlobal(), "echo", "vte6", null, 4, null), Companion.getEchoVte6());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$WhenThereIsNoGlobalInstanceSetup;", "", "()V", "Companion", "envoy-control-tests"})
    public static class WhenThereIsNoGlobalInstanceSetup {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @JvmStatic
        @BeforeAll
        public static final void registerServices() {
            Companion.registerServices();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$WhenThereIsNoGlobalInstanceSetup$Companion;", "", "()V", "registerServices", "", "envoy-control-tests"})
        @SourceDebugExtension(value={"SMAP\nServiceTagPreferenceTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$WhenThereIsNoGlobalInstanceSetup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n1855#2:433\n1855#2,2:434\n1856#2:436\n*S KotlinDebug\n*F\n+ 1 ServiceTagPreferenceTest.kt\npl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceFallbackToAnyTest$WhenThereIsNoGlobalInstanceSetup$Companion\n*L\n294#1:433\n295#1:434,2\n294#1:436\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @BeforeAll
            public final void registerServices() {
                Object[] objectArray = ServiceTagPreferenceTestBase.consul.getServer().getOperations();
                List list = CollectionsKt.listOf((Object)"vte5");
                ConsulOperations.registerService$default((ConsulOperations)objectArray, ServiceTagPreferenceFallbackToAnyTest.Companion.getEchoVte5(), null, "echo", false, list, null, 42, null);
                objectArray = ServiceTagPreferenceTestBase.consul.getServer().getOperations();
                list = CollectionsKt.listOf((Object)"vte6");
                ConsulOperations.registerService$default((ConsulOperations)objectArray, ServiceTagPreferenceFallbackToAnyTest.Companion.getEchoVte6(), null, "echo", false, list, null, 42, null);
                objectArray = new EnvoyExtension[]{ServiceTagPreferenceFallbackToAnyTest.Companion.getEnvoyGlobal(), ServiceTagPreferenceFallbackToAnyTest.Companion.getEnvoyVte2()};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EnvoyExtension envoy = (EnvoyExtension)element$iv;
                    boolean bl = false;
                    Object[] objectArray2 = new HttpsEchoExtension[]{ServiceTagPreferenceFallbackToAnyTest.Companion.getEchoVte5(), ServiceTagPreferenceFallbackToAnyTest.Companion.getEchoVte6()};
                    Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])objectArray2);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        HttpsEchoExtension service = (HttpsEchoExtension)element$iv2;
                        boolean bl2 = false;
                        envoy.waitForClusterEndpointHealthy("echo", service.container().ipAddress());
                    }
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

