/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol.routing;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import okhttp3.Headers;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoContainerKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.HttpsEchoResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceIngressTest;", "", "()V", "should pass default service tag preference if it's more specific than the request one", "", "should pass default service tag preference if request preference is absent", "should pass request x-service-tag-preference if it's more specific", "Companion", "envoy-control-tests"})
public final class ServiceTagPreferenceIngressTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @NotNull
    private static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @NotNull
    private static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @NotNull
    private static final HttpsEchoExtension localService;
    @RegisterExtension
    @NotNull
    private static final EnvoyExtension envoyVte22;

    @Test
    public final void should pass request x-service-tag-preference if it's more specific() {
        HttpsEchoResponse it = HttpsEchoContainerKt.asHttpsEchoResponse(envoyVte22.getIngressOperations().callLocalService("/", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag-preference", (Object)"lvte-1|vte22|global")))));
        boolean bl = false;
        MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"lvte-1|vte22|global");
    }

    @Test
    public final void should pass default service tag preference if it's more specific than the request one() {
        HttpsEchoResponse it = HttpsEchoContainerKt.asHttpsEchoResponse(envoyVte22.getIngressOperations().callLocalService("/", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"x-service-tag-preference", (Object)"global")))));
        boolean bl = false;
        MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"vte22|global");
    }

    @Test
    public final void should pass default service tag preference if request preference is absent() {
        HttpsEchoResponse it = HttpsEchoContainerKt.asHttpsEchoResponse(envoyVte22.getIngressOperations().callLocalService("/", Headers.Companion.of(new String[0])));
        boolean bl = false;
        MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat(it.getRequestHeaders()).containsEntry((Object)"x-service-tag-preference", (Object)"vte22|global");
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.enabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.header", (Object)"x-service-tag-preference"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.default-preference-env", (Object)"DEFAULT_SERVICE_TAG_PREFERENCE"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.default-preference-fallback", (Object)"global"), TuplesKt.to((Object)"envoy-control.envoy.snapshot.routing.service-tags.preference-routing.enable-for-all", (Object)true)};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        localService = new HttpsEchoExtension();
        Object it = object = new EnvoyExtension(envoyControl, localService, null, null, 12, null);
        boolean bl = false;
        ((EnvoyExtension)it).getContainer().withEnv("DEFAULT_SERVICE_TAG_PREFERENCE", "vte22|global");
        envoyVte22 = object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/routing/ServiceTagPreferenceIngressTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "getConsul", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "getEnvoyControl", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "envoyVte22", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "getEnvoyVte22", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "localService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "getLocalService", "()Lpl/allegro/tech/servicemesh/envoycontrol/config/service/HttpsEchoExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConsulExtension getConsul() {
            return consul;
        }

        @NotNull
        public final EnvoyControlExtension getEnvoyControl() {
            return envoyControl;
        }

        @NotNull
        public final HttpsEchoExtension getLocalService() {
            return localService;
        }

        @NotNull
        public final EnvoyExtension getEnvoyVte22() {
            return envoyVte22;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

