/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.snapshot.SecuredRoute;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J\b\u0010\n\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007\u00a8\u0006\r"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/AdminRouteTest;", "", "()V", "should block access to all admin endpoints when request contains the disable header", "", "caseDescription", "", "request", "Lkotlin/Function0;", "Lokhttp3/Response;", "should get access to secured endpoints when authorized only", "should get admin redirected port on ingress port when enabled", "Companion", "envoy-control-tests"})
public final class AdminRouteTest {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Map<String, Object> properties;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy;

    @Test
    public final void should get admin redirected port on ingress port when enabled() {
        Response response2 = envoy.getIngressOperations().callLocalService("/status/envoy", Headers.Companion.of(MapsKt.emptyMap()));
        Assertions.assertThat((boolean)response2.isSuccessful()).isTrue();
    }

    @Test
    public final void should get access to secured endpoints when authorized only() {
        Response configDumpResponseUnauthorized = envoy.getIngressOperations().callLocalService("/status/envoy/config_dump", Headers.Companion.of(MapsKt.emptyMap()));
        Response configDumpResponseAuthorized = envoy.getIngressOperations().callLocalService("/status/envoy/config_dump", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"authorization", (Object)"admin_secret_token"))));
        Response resetCountersResponseUnauthorized = envoy.getIngressOperations().callPostLocalService("/status/envoy/reset_counters", Headers.Companion.of(MapsKt.emptyMap()), RequestBody.Companion.create(MediaType.Companion.get("application/json"), "{}"));
        Response resetCountersResponseAuthorized = envoy.getIngressOperations().callPostLocalService("/status/envoy/reset_counters", Headers.Companion.of(MapsKt.mapOf((Pair)TuplesKt.to((Object)"authorization", (Object)"admin_secret_token"))), RequestBody.Companion.create(MediaType.Companion.get("application/json"), "{}"));
        Assertions.assertThat((int)configDumpResponseUnauthorized.code()).isEqualTo(401);
        Assertions.assertThat((boolean)configDumpResponseAuthorized.isSuccessful()).isTrue();
        Assertions.assertThat((int)resetCountersResponseUnauthorized.code()).isEqualTo(401);
        Assertions.assertThat((boolean)resetCountersResponseAuthorized.isSuccessful()).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"disableOnHeaderTestCases"})
    public final void should block access to all admin endpoints when request contains the disable header(@NotNull String caseDescription, @NotNull Function0<Response> request2) {
        Intrinsics.checkNotNullParameter((Object)caseDescription, (String)"caseDescription");
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Response)request2.invoke()).code()).describedAs(caseDescription, new Object[0])).isEqualTo(403);
    }

    @JvmStatic
    @NotNull
    public static final Stream<Arguments> disableOnHeaderTestCases() {
        return Companion.disableOnHeaderTestCases();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$properties_u24lambda_u240;
        SecuredRoute securedRoute;
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.admin.publicAccessEnabled", (Object)true);
        pairArray[1] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.admin.path-prefix", (Object)"/status/envoy");
        pairArray[2] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.admin.token", (Object)"admin_secret_token");
        pairArray[3] = TuplesKt.to((Object)"envoy-control.envoy.snapshot.routes.admin.disable.on-header", (Object)"to-disable");
        SecuredRoute securedRoute2 = securedRoute = new SecuredRoute();
        String string = "envoy-control.envoy.snapshot.routes.admin.securedPaths";
        int n = 4;
        Pair[] pairArray2 = pairArray;
        boolean bl = false;
        $this$properties_u24lambda_u240.setPathPrefix("/config_dump");
        $this$properties_u24lambda_u240.setMethod("GET");
        Unit unit = Unit.INSTANCE;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)CollectionsKt.listOf((Object)securedRoute));
        properties = MapsKt.mapOf((Pair[])pairArray);
        consul = new ConsulExtension(false, 1, null);
        envoyControl = new EnvoyControlExtension(consul, properties);
        service = new EchoServiceExtension();
        envoy = new EnvoyExtension(envoyControl, service, null, null, 12, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/AdminRouteTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "properties", "", "", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "disableOnHeaderTestCases", "Ljava/util/stream/Stream;", "Lorg/junit/jupiter/params/provider/Arguments;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Stream<Arguments> disableOnHeaderTestCases() {
            Pair disableHeader = TuplesKt.to((Object)"to-disable", (Object)"");
            Arguments[] argumentsArray = new Arguments[7];
            Object[] objectArray = new Object[]{"admin root", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    return AdminRouteTest.envoy.getIngressOperations().callLocalService("/status/envoy/", Headers.Companion.of(MapsKt.mapOf(this.$disableHeader)));
                }
            }};
            argumentsArray[0] = Arguments.of((Object[])objectArray);
            objectArray = new Object[]{"admin root without trailing slash", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    return AdminRouteTest.envoy.getIngressOperations().callLocalService("/status/envoy", Headers.Companion.of(MapsKt.mapOf(this.$disableHeader)));
                }
            }};
            argumentsArray[1] = Arguments.of((Object[])objectArray);
            objectArray = new Object[]{"clusters", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    return AdminRouteTest.envoy.getIngressOperations().callLocalService("/status/envoy/clusters", Headers.Companion.of(MapsKt.mapOf(this.$disableHeader)));
                }
            }};
            argumentsArray[2] = Arguments.of((Object[])objectArray);
            objectArray = new Object[]{"config dump as unauthorized", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    return AdminRouteTest.envoy.getIngressOperations().callLocalService("/status/envoy/config_dump", Headers.Companion.of(MapsKt.mapOf(this.$disableHeader)));
                }
            }};
            argumentsArray[3] = Arguments.of((Object[])objectArray);
            objectArray = new Object[]{"config dump as authorized", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    Pair[] pairArray = new Pair[]{this.$disableHeader, TuplesKt.to((Object)"authorization", (Object)"admin_secret_token")};
                    return AdminRouteTest.envoy.getIngressOperations().callLocalService("/status/envoy/config_dump", Headers.Companion.of(MapsKt.mapOf((Pair[])pairArray)));
                }
            }};
            argumentsArray[4] = Arguments.of((Object[])objectArray);
            objectArray = new Object[]{"reset counters as unauthorized", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    return AdminRouteTest.envoy.getIngressOperations().callPostLocalService("/status/envoy/reset_counters", Headers.Companion.of(MapsKt.mapOf(this.$disableHeader)), RequestBody.Companion.create(MediaType.Companion.get("application/json"), "{}"));
                }
            }};
            argumentsArray[5] = Arguments.of((Object[])objectArray);
            objectArray = new Object[]{"reset counters as authorized", new Function0<Response>((Pair<String, String>)disableHeader){
                final /* synthetic */ Pair<String, String> $disableHeader;
                {
                    this.$disableHeader = $disableHeader;
                    super(0);
                }

                @NotNull
                public final Response invoke() {
                    Pair[] pairArray = new Pair[]{this.$disableHeader, TuplesKt.to((Object)"authorization", (Object)"admin_secret_token")};
                    return AdminRouteTest.envoy.getIngressOperations().callPostLocalService("/status/envoy/reset_counters", Headers.Companion.of(MapsKt.mapOf((Pair[])pairArray)), RequestBody.Companion.create(MediaType.Companion.get("application/json"), "{}"));
                }
            }};
            argumentsArray[6] = Arguments.of((Object[])objectArray);
            Stream<Arguments> stream = Stream.of(argumentsArray);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
            return stream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

