/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.CompressionFilterTest;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyConfig;
import pl.allegro.tech.servicemesh.envoycontrol.config.EnvoyControlTestConfigurationKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtensionBase;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoContainer;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.GenericServiceExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.ServiceContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a8\u0006\u000f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/CompressionFilterTest;", "", "()V", "should compress response with brotli", "", "should compress response with gzip", "should not compress response when accept encoding header is missing", "should not enable compression on unlisted service", "isCompressedWith", "Lorg/assertj/core/api/ObjectAssert;", "Lokhttp3/Response;", "encoding", "", "isNotCompressed", "Companion", "envoy-control-tests"})
public final class CompressionFilterTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SERVICE_NAME = "service-1";
    @NotNull
    private static final String LONG_STRING = "Workshallmeantheworkofauthorship,whetherinSourceorObjectform,madeavailableundertheLicensesindicatedbyacopyrightnoticethatisincludedinorattachedtothework(anexampleisprovidedintheAppendixbelow).";
    @NotNull
    private static final String serviceConfig = "node:\n  metadata:\n    proxy_settings:\n      incoming:\n        unlistedEndpointsPolicy: log\n        endpoints: []";
    @NotNull
    private static final EnvoyConfig config;
    @NotNull
    private static final EnvoyConfig unListedServiceConfig;
    @NotNull
    private static final String longText;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<EchoContainer> service;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final GenericServiceExtension<EchoContainer> noCompressionService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension downstreamService;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension downstreamEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension noCompressionEnvoy;
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension serviceEnvoy;

    @Test
    public final void should compress response with brotli() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), serviceEnvoy, null, SERVICE_NAME, false, null, 26, null);
        String[] stringArray = new String[]{SERVICE_NAME};
        downstreamEnvoy.waitForReadyServices(stringArray);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ CompressionFilterTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response response2 = EgressOperations.callService$default(CompressionFilterTest.downstreamEnvoy.getEgressOperations(), "service-1", MapsKt.mapOf((Pair)TuplesKt.to((Object)"accept-encoding", (Object)"br")), null, null, null, 28, null);
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return CompressionFilterTest.access$isCompressedWith(this.this$0, objectAssert, "br");
            }
        }, 3, null);
    }

    @Test
    public final void should compress response with gzip() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), serviceEnvoy, null, SERVICE_NAME, false, null, 26, null);
        String[] stringArray = new String[]{SERVICE_NAME};
        downstreamEnvoy.waitForReadyServices(stringArray);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ CompressionFilterTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response response2 = EgressOperations.callService$default(CompressionFilterTest.downstreamEnvoy.getEgressOperations(), "service-1", MapsKt.mapOf((Pair)TuplesKt.to((Object)"accept-encoding", (Object)"gzip")), null, null, null, 28, null);
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return CompressionFilterTest.access$isCompressedWith(this.this$0, objectAssert, "gzip");
            }
        }, 3, null);
    }

    @Test
    public final void should not compress response when accept encoding header is missing() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), serviceEnvoy, null, SERVICE_NAME, false, null, 26, null);
        String[] stringArray = new String[]{SERVICE_NAME};
        downstreamEnvoy.waitForReadyServices(stringArray);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ CompressionFilterTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response response2 = EgressOperations.callService$default(CompressionFilterTest.downstreamEnvoy.getEgressOperations(), "service-1", null, null, null, null, 30, null);
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return CompressionFilterTest.access$isNotCompressed(this.this$0, objectAssert);
            }
        }, 3, null);
    }

    @Test
    public final void should not enable compression on unlisted service() {
        ConsulOperations.registerServiceWithEnvoyOnIngress$default(consul.getServer().getOperations(), serviceEnvoy, null, SERVICE_NAME, false, null, 26, null);
        String[] stringArray = new String[]{SERVICE_NAME};
        noCompressionEnvoy.waitForReadyServices(stringArray);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(this){
            final /* synthetic */ CompressionFilterTest this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                Response response2 = EgressOperations.callService$default(CompressionFilterTest.noCompressionEnvoy.getEgressOperations(), "service-1", MapsKt.mapOf((Pair)TuplesKt.to((Object)"accept-encoding", (Object)"gzip")), null, null, null, 28, null);
                System.out.println((Object)response2.headers().toString());
                ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return CompressionFilterTest.access$isNotCompressed(this.this$0, objectAssert);
            }
        }, 3, null);
    }

    private final ObjectAssert<Response> isCompressedWith(ObjectAssert<Response> $this$isCompressedWith, String encoding) {
        $this$isCompressedWith.matches(arg_0 -> CompressionFilterTest.isCompressedWith$lambda$0((Function1)new Function1<Response, Boolean>(encoding){
            final /* synthetic */ String $encoding;
            {
                this.$encoding = $encoding;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(Response it) {
                boolean bl;
                if (it.isSuccessful()) {
                    boolean bl2;
                    block5: {
                        void $this$any$iv;
                        Iterable iterable = (Iterable)it.headers();
                        String string = this.$encoding;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Pair x = (Pair)element$iv;
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual((Object)x.getFirst(), (Object)"content-encoding") && Intrinsics.areEqual((Object)x.getSecond(), (Object)string))) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }, arg_0));
        return $this$isCompressedWith;
    }

    private final ObjectAssert<Response> isNotCompressed(ObjectAssert<Response> $this$isNotCompressed) {
        $this$isNotCompressed.matches(arg_0 -> CompressionFilterTest.isNotCompressed$lambda$1(isNotCompressed.1.INSTANCE, arg_0));
        return $this$isNotCompressed;
    }

    private static final boolean isCompressedWith$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isNotCompressed$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ObjectAssert access$isCompressedWith(CompressionFilterTest $this, ObjectAssert $receiver, String encoding) {
        return $this.isCompressedWith((ObjectAssert<Response>)$receiver, encoding);
    }

    public static final /* synthetic */ ObjectAssert access$isNotCompressed(CompressionFilterTest $this, ObjectAssert $receiver) {
        return $this.isNotCompressed((ObjectAssert<Response>)$receiver);
    }

    static {
        Object object = EnvoyControlTestConfigurationKt.getXds();
        Object object2 = serviceConfig;
        config = EnvoyConfig.copy$default((EnvoyConfig)object, null, SERVICE_NAME, (String)object2, null, null, null, 57, null);
        unListedServiceConfig = EnvoyControlTestConfigurationKt.getAdsAllDependencies();
        longText = StringsKt.repeat((CharSequence)LONG_STRING, (int)100);
        consul = new ConsulExtension(false, 1, null);
        object = new Pair[]{TuplesKt.to((Object)"envoy-control.envoy.snapshot.compression.minContentLength", (Object)100), TuplesKt.to((Object)"envoy-control.envoy.snapshot.compression.responseCompressionEnabled", (Object)true), TuplesKt.to((Object)"envoy-control.envoy.snapshot.outgoing-permissions.servicesAllowedToUseWildcard", (Object)"test-service")};
        envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair[])object));
        service = new GenericServiceExtension<ServiceContainer>(new EchoContainer(longText));
        noCompressionService = new GenericServiceExtension<ServiceContainer>(new EchoContainer(longText));
        downstreamService = new EchoServiceExtension();
        downstreamEnvoy = new EnvoyExtension(envoyControl, downstreamService, EnvoyControlTestConfigurationKt.getXdsCompression(), null, 8, null);
        noCompressionEnvoy = new EnvoyExtension(envoyControl, noCompressionService, unListedServiceConfig, null, 8, null);
        object = envoyControl;
        object2 = config;
        GenericServiceExtension<EchoContainer> genericServiceExtension = service;
        serviceEnvoy = new EnvoyExtension((EnvoyControlExtensionBase)object, genericServiceExtension, (EnvoyConfig)object2, null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/CompressionFilterTest$Companion;", "", "()V", "LONG_STRING", "", "SERVICE_NAME", "config", "Lpl/allegro/tech/servicemesh/envoycontrol/config/EnvoyConfig;", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "downstreamEnvoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "downstreamService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "longText", "noCompressionEnvoy", "noCompressionService", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/GenericServiceExtension;", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoContainer;", "service", "serviceConfig", "serviceEnvoy", "unListedServiceConfig", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

