/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\u0005H&J\b\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017\u00a8\u0006\u0012"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/EnvoyControlHttp2Test;", "", "assertDidNotUseHttp1", "", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "assertDidNotUseHttp2", "assertUsedHttp1", "assertUsedHttp2", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "secondEnvoy", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "should establish http1 connection between envoy and a service by default", "should establish http2 connection between envoys", "envoy-control-tests"})
public interface EnvoyControlHttp2Test {
    @NotNull
    public ConsulExtension consul();

    @NotNull
    public EnvoyControlExtension envoyControl();

    @NotNull
    public EchoServiceExtension service();

    @NotNull
    public EnvoyExtension envoy();

    @NotNull
    public EnvoyExtension secondEnvoy();

    @Test
    public void should establish http2 connection between envoys();

    @Test
    public void should establish http1 connection between envoy and a service by default();

    public void assertUsedHttp2(@NotNull EnvoyExtension var1);

    public void assertDidNotUseHttp2(@NotNull EnvoyExtension var1);

    public void assertDidNotUseHttp1(@NotNull EnvoyExtension var1);

    public void assertUsedHttp1(@NotNull EnvoyExtension var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void should establish http2 connection between envoys(@NotNull EnvoyControlHttp2Test $this) {
            ConsulOperations.registerService$default($this.consul().getServer().getOperations(), null, "proxy1", $this.secondEnvoy().getContainer().ipAddress(), 5001, false, CollectionsKt.listOf((Object)"envoy"), null, 81, null);
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>($this){
                final /* synthetic */ EnvoyControlHttp2Test this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Response response2 = EgressOperations.callService$default(this.this$0.envoy().getEgressOperations(), "proxy1", null, null, null, null, 30, null);
                    ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                    Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                    ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
                    this.this$0.assertDidNotUseHttp1(this.this$0.envoy());
                    this.this$0.assertUsedHttp2(this.this$0.envoy());
                }
            }, 3, null);
        }

        @Test
        public static void should establish http1 connection between envoy and a service by default(@NotNull EnvoyControlHttp2Test $this) {
            ConsulOperations.registerService$default($this.consul().getServer().getOperations(), $this.service(), null, "echo", false, null, null, 58, null);
            AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<Unit>($this){
                final /* synthetic */ EnvoyControlHttp2Test this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Response response2 = EgressOperations.callService$default(this.this$0.envoy().getEgressOperations(), "echo", null, null, null, null, 30, null);
                    ObjectAssert objectAssert = Assertions.assertThat((Object)response2);
                    Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                    ResponseAssertionsKt.isFrom(ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert), this.this$0.service());
                    this.this$0.assertUsedHttp1(this.this$0.envoy());
                    this.this$0.assertDidNotUseHttp2(this.this$0.envoy());
                }
            }, 3, null);
        }

        public static void assertUsedHttp2(@NotNull EnvoyControlHttp2Test $this, @NotNull EnvoyExtension envoy) {
            Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
            String string = envoy.getContainer().admin().statValue("cluster.proxy1.upstream_cx_http2_total");
            Integer http2Connections = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            Assertions.assertThat((Integer)http2Connections).isGreaterThan(0);
        }

        public static void assertDidNotUseHttp2(@NotNull EnvoyControlHttp2Test $this, @NotNull EnvoyExtension envoy) {
            Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
            String string = envoy.getContainer().admin().statValue("cluster.echo.upstream_cx_http2_total");
            Integer http2Connections = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            Assertions.assertThat((Integer)http2Connections).isEqualTo(0);
        }

        public static void assertDidNotUseHttp1(@NotNull EnvoyControlHttp2Test $this, @NotNull EnvoyExtension envoy) {
            Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
            String string = envoy.getContainer().admin().statValue("cluster.proxy1.upstream_cx_http1_total");
            Integer http1Connections = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            Assertions.assertThat((Integer)http1Connections).isEqualTo(0);
        }

        public static void assertUsedHttp1(@NotNull EnvoyControlHttp2Test $this, @NotNull EnvoyExtension envoy) {
            Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
            String string = envoy.getContainer().admin().statValue("cluster.echo.upstream_cx_http1_total");
            Integer http1Connections = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            Assertions.assertThat((Integer)http1Connections).isGreaterThan(0);
        }
    }
}

