/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.servicemesh.envoycontrol;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.AwaitAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.assertions.ResponseAssertionsKt;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.consul.ConsulOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EgressOperations;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoy.EnvoyExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.envoycontrol.EnvoyControlExtension;
import pl.allegro.tech.servicemesh.envoycontrol.config.service.EchoServiceExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/HttpIdleTimeoutTest;", "", "()V", "activeConnections", "", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "name", "", "(Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;Ljava/lang/String;)Ljava/lang/Integer;", "should close idle connections after 1s for HTTP1", "", "should close idle connections after 1s for HTTP2", "Companion", "envoy-control-tests"})
public final class HttpIdleTimeoutTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final ConsulExtension consul = new ConsulExtension(false, 1, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyControlExtension envoyControl = new EnvoyControlExtension(consul, MapsKt.mapOf((Pair)TuplesKt.to((Object)"envoy-control.envoy.snapshot.egress.commonHttp.connectionIdleTimeout", (Object)Duration.ofSeconds(10L))));
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EchoServiceExtension service = new EchoServiceExtension();
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension envoy = new EnvoyExtension(envoyControl, service, null, null, 12, null);
    @RegisterExtension
    @JvmField
    @NotNull
    public static final EnvoyExtension secondEnvoy = new EnvoyExtension(envoyControl, service, null, null, 12, null);

    @Test
    public final void should close idle connections after 1s for HTTP2() {
        String name = "proxy1";
        ConsulOperations.registerService$default(consul.getServer().getOperations(), null, name, secondEnvoy.getContainer().ipAddress(), 5001, false, CollectionsKt.listOf((Object)"envoy"), null, 81, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                ObjectAssert objectAssert = Assertions.assertThat((Object)EgressOperations.callService$default(HttpIdleTimeoutTest.envoy.getEgressOperations(), this.$name, null, null, null, null, 30, null));
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractIntegerAssert<?>>(this, name){
            final /* synthetic */ HttpIdleTimeoutTest this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final AbstractIntegerAssert<?> invoke() {
                return Assertions.assertThat((Integer)this.this$0.activeConnections(HttpIdleTimeoutTest.envoy, this.$name)).isEqualTo(1);
            }
        }, 3, null);
        Duration duration = Duration.ofSeconds(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractIntegerAssert<?>>(this, name){
            final /* synthetic */ HttpIdleTimeoutTest this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final AbstractIntegerAssert<?> invoke() {
                return Assertions.assertThat((Integer)this.this$0.activeConnections(HttpIdleTimeoutTest.envoy, this.$name)).isEqualTo(0);
            }
        }, 1, null);
    }

    @Test
    public final void should close idle connections after 1s for HTTP1() {
        String name = "proxy2";
        ConsulOperations.registerService$default(consul.getServer().getOperations(), null, name, secondEnvoy.getContainer().ipAddress(), 5001, false, null, null, 113, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, (Function0)new Function0<ObjectAssert<Response>>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(0);
            }

            @NotNull
            public final ObjectAssert<Response> invoke() {
                ObjectAssert objectAssert = Assertions.assertThat((Object)EgressOperations.callService$default(HttpIdleTimeoutTest.envoy.getEgressOperations(), this.$name, null, null, null, null, 30, null));
                Intrinsics.checkNotNullExpressionValue((Object)objectAssert, (String)"assertThat(...)");
                return ResponseAssertionsKt.isOk((ObjectAssert<Response>)objectAssert);
            }
        }, 3, null);
        AwaitAssertionsKt.untilAsserted$default(null, null, new Function0<AbstractIntegerAssert<?>>(this, name){
            final /* synthetic */ HttpIdleTimeoutTest this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final AbstractIntegerAssert<?> invoke() {
                return Assertions.assertThat((Integer)this.this$0.activeConnections(HttpIdleTimeoutTest.envoy, this.$name)).isEqualTo(1);
            }
        }, 3, null);
        Duration duration = Duration.ofSeconds(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        AwaitAssertionsKt.untilAsserted$default(null, duration, new Function0<AbstractIntegerAssert<?>>(this, name){
            final /* synthetic */ HttpIdleTimeoutTest this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final AbstractIntegerAssert<?> invoke() {
                return Assertions.assertThat((Integer)this.this$0.activeConnections(HttpIdleTimeoutTest.envoy, this.$name)).isEqualTo(0);
            }
        }, 1, null);
    }

    @Nullable
    public final Integer activeConnections(@NotNull EnvoyExtension envoy, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)envoy, (String)"envoy");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = envoy.getContainer().admin().statValue("cluster." + name + ".upstream_cx_active");
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lpl/allegro/tech/servicemesh/envoycontrol/HttpIdleTimeoutTest$Companion;", "", "()V", "consul", "Lpl/allegro/tech/servicemesh/envoycontrol/config/consul/ConsulExtension;", "envoy", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoy/EnvoyExtension;", "envoyControl", "Lpl/allegro/tech/servicemesh/envoycontrol/config/envoycontrol/EnvoyControlExtension;", "secondEnvoy", "service", "Lpl/allegro/tech/servicemesh/envoycontrol/config/service/EchoServiceExtension;", "envoy-control-tests"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

